/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.mesh;

import com.beatcraft.client.render.mesh.Geometry;
import com.beatcraft.client.render.mesh.QuadMesh;
import com.beatcraft.client.render.mesh.Triangle;
import com.beatcraft.client.render.mesh.TriangleMesh;
import net.minecraft.class_287;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Quad
implements Geometry {
    private final int[] indices;
    private final Vector2f[] uvs;

    public Quad(int a, int b, int c, int d, Vector2f uvA, Vector2f uvB, Vector2f uvC, Vector2f uvD) {
        this.indices = new int[]{a, b, c, d};
        this.uvs = new Vector2f[]{uvA, uvB, uvC, uvD};
    }

    public int a() {
        return this.indices[0];
    }

    public int b() {
        return this.indices[1];
    }

    public int c() {
        return this.indices[2];
    }

    public int d() {
        return this.indices[3];
    }

    public Vector2f uvA() {
        return this.uvs[0];
    }

    public Vector2f uvB() {
        return this.uvs[1];
    }

    public Vector2f uvC() {
        return this.uvs[2];
    }

    public Vector2f uvD() {
        return this.uvs[3];
    }

    public int[] getIndices() {
        return this.indices;
    }

    public Vector2f[] getUvs() {
        return this.uvs;
    }

    public Triangle[] toTriangles(QuadMesh quadMesh, TriangleMesh triMesh) {
        Vector3f v1 = quadMesh.vertices.get(this.indices[0]);
        Vector3f v2 = quadMesh.vertices.get(this.indices[1]);
        Vector3f v3 = quadMesh.vertices.get(this.indices[2]);
        Vector3f v4 = quadMesh.vertices.get(this.indices[3]);
        if (!triMesh.vertices.contains(v1)) {
            triMesh.vertices.add(v1);
        }
        if (!triMesh.vertices.contains(v2)) {
            triMesh.vertices.add(v2);
        }
        if (!triMesh.vertices.contains(v3)) {
            triMesh.vertices.add(v3);
        }
        if (!triMesh.vertices.contains(v4)) {
            triMesh.vertices.add(v4);
        }
        int ta = triMesh.vertices.indexOf(v1);
        int tb = triMesh.vertices.indexOf(v2);
        int tc = triMesh.vertices.indexOf(v3);
        int td = triMesh.vertices.indexOf(v4);
        return new Triangle[]{new Triangle(ta, tb, tc, this.uvs[0], this.uvs[1], this.uvs[2]), new Triangle(tc, ta, td, this.uvs[2], this.uvs[0], this.uvs[3])};
    }

    public void draw(class_287 buffer, int color, QuadMesh mesh, Vector3f position, Quaternionf orientation, Vector3f cameraPos) {
        Vector3f v0 = mesh.vertices.get(this.indices[0]).rotate((Quaternionfc)orientation, new Vector3f()).add((Vector3fc)position).sub((Vector3fc)cameraPos);
        Vector3f v1 = mesh.vertices.get(this.indices[1]).rotate((Quaternionfc)orientation, new Vector3f()).add((Vector3fc)position).sub((Vector3fc)cameraPos);
        Vector3f v2 = mesh.vertices.get(this.indices[2]).rotate((Quaternionfc)orientation, new Vector3f()).add((Vector3fc)position).sub((Vector3fc)cameraPos);
        Vector3f v3 = mesh.vertices.get(this.indices[3]).rotate((Quaternionfc)orientation, new Vector3f()).add((Vector3fc)position).sub((Vector3fc)cameraPos);
        buffer.method_22912(v0.x, v0.y, v0.z).method_22913(this.uvs[0].x, this.uvs[0].y).method_39415(color);
        buffer.method_22912(v1.x, v1.y, v1.z).method_22913(this.uvs[1].x, this.uvs[1].y).method_39415(color);
        buffer.method_22912(v2.x, v2.y, v2.z).method_22913(this.uvs[2].x, this.uvs[2].y).method_39415(color);
        buffer.method_22912(v3.x, v3.y, v3.z).method_22913(this.uvs[3].x, this.uvs[3].y).method_39415(color);
    }
}

