/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.mesh;

import com.beatcraft.client.render.mesh.Mesh;
import com.beatcraft.client.render.mesh.Triangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TriangleMesh
implements Mesh {
    public ArrayList<Vector3f> vertices;
    public ArrayList<Triangle> tris;
    public int color;
    public class_2960 texture;

    public TriangleMesh() {
        this.vertices = new ArrayList();
        this.tris = new ArrayList();
    }

    public TriangleMesh(List<Vector3f> vertices, List<Triangle> tris) {
        this.vertices = new ArrayList<Vector3f>(vertices);
        this.tris = new ArrayList<Triangle>(tris);
    }

    public void addGeometry(List<Vector3f> vertices, List<Triangle> tris) {
        int offset = this.vertices.size();
        this.vertices.addAll(vertices);
        for (Triangle tri : tris) {
            tri.offsetTri(offset);
            this.tris.add(tri);
        }
    }

    @Override
    public void drawToBuffer(class_287 buffer, Vector3f position, Quaternionf orientation, Vector3f cameraPos) {
        this.tris.forEach(tri -> tri.draw(buffer, this.color, this, position, orientation, cameraPos));
    }

    public void drawToBufferMirrored(class_287 buffer, Vector3f position, Quaternionf orientation, Vector3f cameraPos) {
        Vector3f flippedPosition = position.mul(1.0f, -1.0f, 1.0f, new Vector3f());
        Quaternionf flippedOrientation = new Quaternionf(-orientation.x, orientation.y, -orientation.z, orientation.w);
        this.tris.forEach(tri -> tri.drawMirrored(buffer, this.color, this, flippedPosition, flippedOrientation, cameraPos));
    }

    public void addTris(Triangle[] tris) {
        this.tris.addAll(Arrays.asList(tris));
    }
}

