/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.particle;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.render.instancing.ColorNoteInstanceData;
import com.beatcraft.client.render.instancing.InstancedMesh;
import com.beatcraft.client.render.particle.Particle;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.utils.MathUtil;
import net.minecraft.class_287;
import net.minecraft.class_5819;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class Debris
implements Particle {
    private final BeatmapController mapController;
    private final Vector3f position;
    private final Quaternionf orientation;
    private final Vector3f velocity;
    private final Vector3f decay;
    private final Quaternionf spin;
    public Vector4f slice;
    private final int randomIndex;
    private final Color color;
    private final double spawnTime;
    private final InstancedMesh<ColorNoteInstanceData> mesh;
    private static final float DISSOLVE_TIME = 2.0f;
    public boolean persistent = false;

    public Debris(BeatmapController beatmap, Vector3f position, Quaternionf orientation, Vector3f velocity, Quaternionf spin, Vector4f slice, Color color, InstancedMesh<ColorNoteInstanceData> mesh) {
        this.mapController = beatmap;
        this.position = position;
        this.velocity = velocity;
        this.orientation = orientation;
        this.spin = spin;
        this.slice = slice;
        this.color = color;
        this.decay = new Vector3f(0.99f, 0.99f, 0.99f);
        this.spawnTime = (double)System.nanoTime() / 1.0E9;
        this.mesh = mesh;
        this.randomIndex = class_5819.method_43047().method_43051(0, 200);
    }

    @Override
    public void update(float deltaTime, class_287 buffer, Vector3f cameraPos) {
        if (!this.persistent && this.mapController.isPlaying()) {
            this.orientation.mul((Quaternionfc)this.spin.mul(deltaTime, new Quaternionf())).normalize();
            this.position.add((Vector3fc)this.velocity.mul(deltaTime, new Vector3f()));
            this.velocity.add((Vector3fc)new Vector3f(0.0f, -9.81f, 0.0f).mul(deltaTime));
            this.velocity.mul((Vector3fc)this.decay);
        }
        Matrix4f pos = new Matrix4f().identity();
        pos.translate((Vector3fc)this.position);
        pos.translate((Vector3fc)new Vector3f((Vector3fc)cameraPos).negate());
        pos.rotate((Quaternionfc)this.orientation);
        pos.scale(0.5f);
        double t = MathUtil.inverseLerp(this.spawnTime, this.spawnTime + 2.0, (double)System.nanoTime() / 1.0E9);
        this.mesh.draw(ColorNoteInstanceData.create(pos, this.color, (float)t, this.randomIndex, this.slice));
    }

    @Override
    public boolean shouldRemove() {
        return !this.persistent && MathUtil.inverseLerp(this.spawnTime, this.spawnTime + 2.0, (double)System.nanoTime() / 1.0E9) >= 1.0;
    }
}

