/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.replay;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.BeatmapManager;
import com.beatcraft.client.replay.ReplayInfo;
import com.beatcraft.common.data.map.SongData;
import com.beatcraft.common.data.map.SongDownloader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;

public class ReplayHandler {
    private final BeatmapController controller;
    public static final int VERSION = 1;
    private static boolean recordPlayback = false;
    private static final ArrayList<ReplayInfo> replayData = new ArrayList();

    public ReplayHandler(BeatmapController controller) {
        this.controller = controller;
    }

    public static int getReplayCount() {
        return replayData.size();
    }

    public static List<ReplayInfo> getReplays(int startIndex, int length) {
        ArrayList<ReplayInfo> out = new ArrayList<ReplayInfo>();
        for (int i = startIndex; i < startIndex + length - 1; ++i) {
            if (i >= replayData.size()) continue;
            out.add(replayData.get(i));
        }
        return out;
    }

    public static void loadReplays() {
        ReplayHandler.loadReplays(true);
    }

    public static void loadReplays(boolean updateReplayScreen) {
        String replayFolder = String.valueOf(class_310.method_1551().field_1697.toPath()) + "/beatcraft/replay/";
        File folder = new File(replayFolder);
        if (!folder.exists() && !folder.mkdirs()) {
            Beatcraft.LOGGER.error("Failed to create replay folder");
            return;
        }
        File[] replayFiles = folder.listFiles(File::isFile);
        if (replayFiles == null) {
            Beatcraft.LOGGER.error("Failed to load replays");
            return;
        }
        replayData.clear();
        for (File replay : replayFiles) {
            ReplayInfo info;
            String fullPath = replay.getAbsolutePath();
            if (!fullPath.endsWith(".replay") || (info = ReplayHandler.loadReplay(fullPath)) == null) continue;
            replayData.add(info);
        }
        if (updateReplayScreen) {
            for (BeatmapController controller : BeatmapManager.beatmaps) {
                controller.hudRenderer.modifierMenuPanel.setupReplayPage();
            }
        }
    }

    public void recordNextMap() {
        recordPlayback = true;
        this.controller.hudRenderer.modifierMenuPanel.setReplayToggleState(true);
    }

    public void cancelRecording() {
        recordPlayback = false;
        this.controller.playRecorder.outputFile = null;
        this.controller.hudRenderer.modifierMenuPanel.setReplayToggleState(false);
    }

    public boolean isRecording() {
        return recordPlayback;
    }

    private static String getCurrentTimestamp() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        return LocalDateTime.now().format(formatter);
    }

    public void setup(String mapID, String set, String diff) {
        if (mapID == null) {
            Beatcraft.LOGGER.warn("Map has no ID and therefore won't be able to be played back properly, so recording is canceled");
            return;
        }
        this.controller.playRecorder.outputFile = String.format("beatcraft-%s-%s-%s-%s.replay", mapID, SongDownloader.filterString(set), SongDownloader.filterString(diff), ReplayHandler.getCurrentTimestamp());
        this.controller.playRecorder.songID = mapID;
        this.controller.playRecorder.difficultySet = set;
        this.controller.playRecorder.difficulty = diff;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ReplayInfo loadReplay(String path) {
        try (RandomAccessFile file = new RandomAccessFile(path, "r");){
            ReplayInfo replayInfo;
            block17: {
                FileChannel channel;
                block15: {
                    ReplayInfo replayInfo2;
                    block16: {
                        channel = file.getChannel();
                        try {
                            ByteBuffer buffer = ByteBuffer.allocate(512);
                            channel.read(buffer);
                            buffer.flip();
                            int replayVersion = buffer.getInt();
                            if (replayVersion != 1) break block15;
                            replayInfo2 = ReplayHandler.loadV1(buffer, path);
                            if (channel == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        channel.close();
                    }
                    return replayInfo2;
                }
                replayInfo = null;
                if (channel == null) break block17;
                channel.close();
            }
            return replayInfo;
        }
        catch (Exception e) {
            Beatcraft.LOGGER.error("Error loading replay file '{}'", (Object)path, (Object)e);
            return null;
        }
    }

    private static ReplayInfo loadV1(ByteBuffer buffer, String path) {
        int idSize = buffer.getInt();
        byte[] idBytes = new byte[idSize];
        buffer.get(idBytes);
        String mapID = new String(idBytes, StandardCharsets.UTF_8);
        int setSize = buffer.getInt();
        byte[] setBytes = new byte[setSize];
        buffer.get(setBytes);
        String set = new String(setBytes, StandardCharsets.UTF_8);
        int diffSize = buffer.getInt();
        byte[] diffBytes = new byte[diffSize];
        buffer.get(diffBytes);
        String diff = new String(diffBytes, StandardCharsets.UTF_8);
        String name = ReplayHandler.lookup(mapID);
        Beatcraft.LOGGER.info("Loaded replay: {}, {}, {}, {}", new Object[]{mapID, name, set, diff});
        return new ReplayInfo(mapID, name == null ? "MAP NOT FOUND" : name, set, diff, path, name != null);
    }

    private static String lookup(String id) {
        SongData song = BeatcraftClient.songs.getById(id);
        if (song == null) {
            return null;
        }
        return String.format("%s | %s", song.getTitle(), song.getMappers());
    }

    public static void delete(ReplayInfo info) {
        try {
            Files.deleteIfExists(Path.of(info.replayFilePath(), new String[0]));
            ReplayHandler.loadReplays(false);
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to delete replay file!", (Throwable)e);
        }
    }
}

