/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.screen;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import net.minecraft.class_2561;

public class OptionList {
    private static final int OPTS_PER_PAGE = 8;
    private int opts = 0;
    public int page = 0;
    public int pageCount;
    public final ArrayList<ArrayList<Option>> pages = new ArrayList();
    private boolean built = false;
    private boolean multiplePages = false;

    public OptionList() {
        this.pages.add(new ArrayList());
    }

    public OptionList addOption(Option option) {
        if (this.built) {
            throw new RuntimeException("Cannot add pages after being built");
        }
        if (this.opts == 8) {
            ++this.page;
            this.opts = 1;
            this.pages.add(new ArrayList());
        } else {
            ++this.opts;
        }
        this.pages.getLast().add(option);
        return this;
    }

    public OptionList build() {
        this.built = true;
        this.pageCount = this.page + 1;
        this.multiplePages = this.pageCount > 1;
        this.page = 0;
        return this;
    }

    public static class MultiChoiceOption<T>
    extends Option {
        private final Callable<T> getValue;
        private final Consumer<T> setValue;
        private final LinkedHashMap<T, class_2561> valueDisplays;

        public MultiChoiceOption(class_2561 displayName, LinkedHashMap<T, class_2561> valueDisplays, Callable<T> getValue, Consumer<T> setValue) {
            super(displayName);
            this.getValue = getValue;
            this.setValue = setValue;
            this.valueDisplays = valueDisplays;
        }
    }

    public static class SliderOption
    extends Option {
        private final float minValue;
        private final float maxValue;
        private final int steps;
        private final float step;
        private final Callable<Float> getValue;
        private final Consumer<Float> setValue;

        public SliderOption(class_2561 displayName, float minVal, float maxVal, int steps, Callable<Float> getValue, Consumer<Float> setValue) {
            super(displayName);
            this.minValue = minVal;
            this.maxValue = maxVal;
            this.steps = steps;
            this.setValue = setValue;
            this.getValue = getValue;
            this.step = (maxVal - minVal) / (float)steps;
        }
    }

    public static class Option {
        protected final class_2561 displayName;

        public Option(class_2561 displayName) {
            this.displayName = displayName;
        }
    }
}

