/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.common.data;

import com.beatcraft.Beatcraft;
import com.beatcraft.common.data.ControllerProfile;
import com.beatcraft.common.data.types.CycleStack;
import com.beatcraft.common.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;

public class PlayerConfig {
    public static final int FORMAT = 1;
    public final File configFile = new File("./config/beatcraft/config.json");
    public final File configFolder = new File("./config/beatcraft/");
    public final AudioSettings audio = new AudioSettings();
    public final QualitySettings quality = new QualitySettings();
    public final ControllerSettings controller = new ControllerSettings();
    public final Preferences preferences = new Preferences();
    public final DebugSettings debug = new DebugSettings();
    public final MiscSettings misc = new MiscSettings();

    public PlayerConfig(JsonObject json) {
        this();
        if (json.has("version")) {
            int ver = json.get("version").getAsInt();
            if (ver == 1) {
                this.audio.parse$v1(json.getAsJsonObject("audio"));
                this.quality.parse$v1(json.getAsJsonObject("quality"));
                this.controller.parse$v1(json.getAsJsonObject("controller"));
                this.preferences.parse$v1(json.getAsJsonObject("preferences"));
                this.debug.parse$v1(json.getAsJsonObject("debug"));
                this.misc.parse$v1(json.getAsJsonObject("misc"));
            } else {
                Beatcraft.LOGGER.warn("Unrecognized config format version: {}, using default config values", (Object)ver);
            }
        } else {
            this.audio.parse$old(json);
            this.quality.parse$old(json);
            this.controller.parse$old(json);
            this.preferences.parse$old(json);
            this.debug.parse$old(json);
        }
        CycleStack.updateTrailSize(this.preferences.trailIntensity());
    }

    private void writeJson(JsonObject json) {
        json.addProperty("version", (Number)1);
        json.add("audio", (JsonElement)this.audio.getJson());
        json.add("quality", (JsonElement)this.quality.getJson());
        json.add("controller", (JsonElement)this.controller.getJson());
        json.add("preferences", (JsonElement)this.preferences.getJson());
        json.add("debug", (JsonElement)this.debug.getJson());
        json.add("misc", (JsonElement)this.misc.getJson());
    }

    public PlayerConfig() {
        if (!this.configFile.exists()) {
            boolean bl = this.configFolder.mkdirs();
        }
        if (!this.configFile.exists()) {
            try {
                boolean ignored = this.configFile.createNewFile();
                this.writeToFile();
            }
            catch (IOException e) {
                Beatcraft.LOGGER.error("Error creating player config file: ", (Throwable)e);
            }
        }
    }

    public static PlayerConfig loadFromFile() {
        try {
            String jsonString = Files.readString(Path.of("./config/beatcraft/config.json", new String[0]));
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            return new PlayerConfig(json);
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to load player config! ", (Throwable)e);
            return new PlayerConfig();
        }
    }

    public void writeToFile() {
        try {
            JsonObject json = new JsonObject();
            this.writeJson(json);
            Files.writeString(Path.of("./config/beatcraft/config.json", new String[0]), (CharSequence)json.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to save player config ", (Throwable)e);
        }
    }

    public class AudioSettings {
        public Option<Float> volume = new Option<Float>(Float.valueOf(1.0f), "Beatmap song volume", "");
        public Option<Float> ambientVolumeScale = new Option<Float>(Float.valueOf(0.8f), "", "Not implemented");
        public Option<Integer> latency = new Option<Integer>(0, "Audio delay (ms)", "");
        public Option<Boolean> overrideLatency = new Option<Boolean>(false, "Should latency be accounted for", "");

        public float volume() {
            return this.volume.get().floatValue();
        }

        public void volume(float set) {
            this.volume.set(Float.valueOf(set));
        }

        public float ambientVolumeScale() {
            return this.ambientVolumeScale.get().floatValue();
        }

        public void ambientVolumeScale(float set) {
            this.ambientVolumeScale.set(Float.valueOf(set));
        }

        public int latency() {
            return this.latency.get();
        }

        public void latency(int set) {
            this.latency.set(set);
        }

        public boolean overrideLatency() {
            return this.overrideLatency.get();
        }

        public void overrideLatency(boolean set) {
            this.overrideLatency.set(set);
        }

        public JsonObject getJson() {
            JsonObject json = new JsonObject();
            json.addProperty("volume", (Number)this.volume.get());
            json.addProperty("ambient_volume_scale", (Number)this.ambientVolumeScale.get());
            json.addProperty("latency", (Number)this.latency.get());
            json.addProperty("override_latency", this.overrideLatency.get());
            return json;
        }

        public PlayerConfig parent() {
            return PlayerConfig.this;
        }

        public void parse$old(JsonObject json) {
            if (json == null) {
                return;
            }
            this.volume.value = Float.valueOf(Math.clamp(JsonUtil.getOrDefault(json, "audio.volume", JsonElement::getAsFloat, (Float)this.volume.value).floatValue(), 0.0f, 1.0f));
            this.ambientVolumeScale.value = Float.valueOf(Math.clamp(JsonUtil.getOrDefault(json, "audio.ambient_volume_scale", JsonElement::getAsFloat, (Float)this.ambientVolumeScale.value).floatValue(), 0.0f, 1.0f));
            this.latency.value = Math.min(0, JsonUtil.getOrDefault(json, "audio.latency", JsonElement::getAsInt, (Integer)this.latency.value));
            this.overrideLatency.value = JsonUtil.getOrDefault(json, "audio.override_latency", JsonElement::getAsBoolean, (Boolean)this.overrideLatency.value);
        }

        public void parse$v1(JsonObject json) {
            if (json == null) {
                return;
            }
            this.volume.value = JsonUtil.getOrDefault(json, "volume", JsonElement::getAsFloat, (Float)this.volume.value);
            this.ambientVolumeScale.value = JsonUtil.getOrDefault(json, "ambient_volume_scale", JsonElement::getAsFloat, (Float)this.ambientVolumeScale.value);
            this.latency.value = JsonUtil.getOrDefault(json, "latency", JsonElement::getAsInt, (Integer)this.latency.value);
            this.overrideLatency.value = JsonUtil.getOrDefault(json, "override_latency", JsonElement::getAsBoolean, (Boolean)this.overrideLatency.value);
        }
    }

    public class QualitySettings {
        public Option<Boolean> doBloomfog = new Option<Boolean>(true, "Toggles the Bloomfog render effect", "[Medium performance impact]");
        public Option<Boolean> doBloom = new Option<Boolean>(true, "Toggles Bloom post effect", "[Low performance impact]");
        public Option<Boolean> doMirror = new Option<Boolean>(true, "Toggles Mirror render effect", "[Performance varies]");
        public Option<MirrorQuality> mirrorQuality = new Option<MirrorQuality>(MirrorQuality.EXACT, "Controls mirror rendering method", "EXACT: [Medium-Extreme performance impact]\nSCUFFED: [Medium performance impact]");
        public Option<Integer> mirrorLimit = new Option<Integer>(1, "How many unique mirrors should be rendered?", "1: [Medium performance impact]\n2: [High performance impact]\n3+: [Extreme performance impact]");
        public Option<Boolean> skyFog = new Option<Boolean>(true, "Replace minecraft sky with a black, starless skybox", "[No performance impact]");
        public Option<Boolean> smokeGraphics = new Option<Boolean>(true, "Whether to render smoke around the player", "[Minimal performance impact]");
        public Option<Boolean> burnMarkTrails = new Option<Boolean>(true, "Saber burn marks", "NOT IMPLEMENTED");
        public Option<Boolean> sparkParticles = new Option<Boolean>(true, "Saber cut particles", "[Minimal performance impact]");

        public boolean doBloomfog() {
            return this.doBloomfog.get();
        }

        public void doBloomfog(boolean set) {
            this.doBloomfog.set(set);
        }

        public boolean doBloom() {
            return this.doBloom.get();
        }

        public void doBloom(boolean set) {
            this.doBloom.set(set);
        }

        public boolean doMirror() {
            return this.doMirror.get();
        }

        public void doMirror(boolean set) {
            this.doMirror.set(set);
        }

        public MirrorQuality mirrorQuality() {
            return this.mirrorQuality.get();
        }

        public void mirrorQuality(MirrorQuality set) {
            this.mirrorQuality.set(set);
        }

        public int mirrorLimit() {
            return this.mirrorLimit.get();
        }

        public void mirrorLimit(int set) {
            this.mirrorLimit.set(set);
        }

        public boolean skyFog() {
            return this.skyFog.get();
        }

        public void skyFog(boolean set) {
            this.skyFog.set(set);
        }

        public boolean smokeGraphics() {
            return this.smokeGraphics.get();
        }

        public void smokeGraphics(boolean set) {
            this.smokeGraphics.set(set);
        }

        public boolean burnMarkTrails() {
            return this.burnMarkTrails.get();
        }

        public void burnMarkTrails(boolean set) {
            this.burnMarkTrails.set(set);
        }

        public boolean sparkParticles() {
            return this.sparkParticles.get();
        }

        public void sparkParticles(boolean set) {
            this.sparkParticles.set(set);
        }

        public JsonObject getJson() {
            JsonObject json = new JsonObject();
            json.addProperty("bloomfog", (Boolean)this.doBloomfog.value);
            json.addProperty("bloom", (Boolean)this.doBloom.value);
            json.addProperty("mirror", (Boolean)this.doMirror.value);
            json.addProperty("mirror_limit", (Number)this.mirrorLimit.value);
            json.addProperty("mirror_quality", (Number)((MirrorQuality)((Object)this.mirrorQuality.value)).ordinal());
            json.addProperty("sky_fog", (Boolean)this.skyFog.value);
            json.addProperty("smoke_graphics", (Boolean)this.smokeGraphics.value);
            json.addProperty("burn_mark_trails", (Boolean)this.burnMarkTrails.value);
            json.addProperty("spark_particles", (Boolean)this.sparkParticles.value);
            return json;
        }

        public PlayerConfig parent() {
            return PlayerConfig.this;
        }

        public void parse$old(JsonObject json) {
            if (json == null) {
                return;
            }
            this.doBloomfog.value = JsonUtil.getOrDefault(json, "quality.bloomfog", JsonElement::getAsBoolean, (Boolean)this.doBloomfog.value);
            this.doBloom.value = JsonUtil.getOrDefault(json, "quality.bloom", JsonElement::getAsBoolean, (Boolean)this.doBloom.value);
            this.doMirror.value = JsonUtil.getOrDefault(json, "quality.mirror", JsonElement::getAsBoolean, (Boolean)this.doMirror.value);
            this.skyFog.value = JsonUtil.getOrDefault(json, "quality.sky_fog", JsonElement::getAsBoolean, (Boolean)this.skyFog.value);
            this.smokeGraphics.value = JsonUtil.getOrDefault(json, "quality.smoke_graphics", JsonElement::getAsBoolean, (Boolean)this.smokeGraphics.value);
            this.burnMarkTrails.value = JsonUtil.getOrDefault(json, "quality.burn_mark_trails", JsonElement::getAsBoolean, (Boolean)this.burnMarkTrails.value);
            this.sparkParticles.value = JsonUtil.getOrDefault(json, "quality.spark_particles", JsonElement::getAsBoolean, (Boolean)this.sparkParticles.value);
        }

        public void parse$v1(JsonObject json) {
            if (json == null) {
                return;
            }
            this.doBloomfog.value = JsonUtil.getOrDefault(json, "bloomfog", JsonElement::getAsBoolean, (Boolean)this.doBloomfog.value);
            this.doBloom.value = JsonUtil.getOrDefault(json, "bloom", JsonElement::getAsBoolean, (Boolean)this.doBloom.value);
            this.doMirror.value = JsonUtil.getOrDefault(json, "mirror", JsonElement::getAsBoolean, (Boolean)this.doMirror.value);
            this.mirrorLimit.value = Math.min(1, JsonUtil.getOrDefault(json, "mirror_limit", JsonElement::getAsInt, (Integer)this.mirrorLimit.value));
            this.mirrorQuality.value = MirrorQuality.values()[Math.clamp((long)JsonUtil.getOrDefault(json, "mirror_quality", JsonElement::getAsInt, Integer.valueOf(((MirrorQuality)((Object)this.mirrorQuality.value)).ordinal())).intValue(), 0, MirrorQuality.values().length)];
            this.skyFog.value = JsonUtil.getOrDefault(json, "sky_fog", JsonElement::getAsBoolean, (Boolean)this.skyFog.value);
            this.smokeGraphics.value = JsonUtil.getOrDefault(json, "smoke_graphics", JsonElement::getAsBoolean, (Boolean)this.smokeGraphics.value);
            this.burnMarkTrails.value = JsonUtil.getOrDefault(json, "burn_mark_trails", JsonElement::getAsBoolean, (Boolean)this.burnMarkTrails.value);
            this.sparkParticles.value = JsonUtil.getOrDefault(json, "spark_particles", JsonElement::getAsBoolean, (Boolean)this.sparkParticles.value);
        }

        public static enum MirrorQuality {
            EXACT,
            SCUFFED;

        }
    }

    public class ControllerSettings {
        private static final ControllerProfile DEFAULT_CONTROLLER_PROFILE = new ControllerProfile();
        public int selectedProfile = -1;
        public final ArrayList<ControllerProfile> profiles = new ArrayList();

        public ControllerProfile activeProfile() {
            if (this.selectedProfile == -1) {
                return DEFAULT_CONTROLLER_PROFILE;
            }
            return this.profiles.get(this.selectedProfile);
        }

        public JsonObject getJson() {
            JsonObject json = new JsonObject();
            json.addProperty("selected_profile", (Number)this.selectedProfile);
            JsonArray arr = new JsonArray();
            for (ControllerProfile profile : this.profiles) {
                profile.writeJson(arr);
            }
            json.add("profiles", (JsonElement)arr);
            return json;
        }

        public PlayerConfig parent() {
            return PlayerConfig.this;
        }

        public void parse$old(JsonObject json) {
            if (json == null) {
                return;
            }
            this.selectedProfile = JsonUtil.getOrDefault(json, "controller.selectedProfile.index", JsonElement::getAsInt, Integer.valueOf(this.selectedProfile));
            this.parseProfiles$v1(json.getAsJsonArray("controller.profiles"));
        }

        public void parse$v1(JsonObject json) {
            if (json == null) {
                return;
            }
            this.selectedProfile = JsonUtil.getOrDefault(json, "selected_profile", JsonElement::getAsInt, Integer.valueOf(this.selectedProfile));
            this.parseProfiles$v1(json.getAsJsonArray("profiles"));
        }

        private void parseProfiles$v1(JsonArray profiles) {
            for (JsonElement data : profiles) {
                ControllerProfile profile = new ControllerProfile(data.getAsJsonObject());
                this.profiles.add(profile);
            }
        }

        public int activeIndex() {
            return this.selectedProfile;
        }

        public void selectProfile(int index) {
            this.selectedProfile = Math.clamp((long)index, -1, this.profiles.size() - 1);
        }

        public void addProfile() {
            this.profiles.add(new ControllerProfile());
        }

        public int getProfileCount() {
            return this.profiles.size();
        }
    }

    public class Preferences {
        public Option<Boolean> reducedDebris = new Option<Boolean>(false, "Whether to spawn debris from notes", "[No performance impact]");
        public Option<Integer> trailIntensity = new Option<Integer>(30, "How many frames to save for saber trails", "[No performance impact]");
        public Option<HealthStyle> healthStyle = new Option<HealthStyle>(HealthStyle.Hearts, "Energy bar style", "Classic: the classic beat saber look\nHearts: minecraft hearts are used instead of a bar");
        public Option<String> selectedSaber = new Option<String>("#builtin:default", "", "");

        public boolean reducedDebris() {
            return this.reducedDebris.get();
        }

        public void reducedDebris(boolean set) {
            this.reducedDebris.set(set);
        }

        public int trailIntensity() {
            return this.trailIntensity.get();
        }

        public void trailIntensity(int set) {
            this.trailIntensity.set(set);
            CycleStack.updateTrailSize(set);
        }

        public HealthStyle healthStyle() {
            return this.healthStyle.get();
        }

        public void healthStyle(HealthStyle set) {
            this.healthStyle.set(set);
        }

        public void healthStyle(int set) {
            this.healthStyle(HealthStyle.values()[Math.clamp((long)set, 0, HealthStyle.values().length - 1)]);
        }

        public String selectedSaber() {
            return this.selectedSaber.get();
        }

        public void selectedSaber(String set) {
            this.selectedSaber.set(set);
        }

        public JsonObject getJson() {
            JsonObject json = new JsonObject();
            json.addProperty("reduced_debris", (Boolean)this.reducedDebris.value);
            json.addProperty("trail_intensity", (Number)this.trailIntensity.value);
            json.addProperty("health_style", (Number)((HealthStyle)((Object)this.healthStyle.value)).ordinal());
            json.addProperty("selected_saber", (String)this.selectedSaber.value);
            return json;
        }

        public PlayerConfig parent() {
            return PlayerConfig.this;
        }

        public void parse$old(JsonObject json) {
            if (json == null) {
                return;
            }
            this.reducedDebris.value = JsonUtil.getOrDefault(json, "option.reduced_debris", JsonElement::getAsBoolean, (Boolean)this.reducedDebris.value);
            this.trailIntensity.value = JsonUtil.getOrDefault(json, "option.trail_intensity", JsonElement::getAsInt, (Integer)this.trailIntensity.value);
            this.healthStyle.value = HealthStyle.values()[Math.clamp((long)JsonUtil.getOrDefault(json, "option.health_style", JsonElement::getAsInt, Integer.valueOf(((HealthStyle)((Object)this.healthStyle.value)).ordinal())).intValue(), 0, HealthStyle.values().length)];
        }

        public void parse$v1(JsonObject json) {
            if (json == null) {
                return;
            }
            this.reducedDebris.value = JsonUtil.getOrDefault(json, "reduced_debris", JsonElement::getAsBoolean, (Boolean)this.reducedDebris.value);
            this.trailIntensity.value = JsonUtil.getOrDefault(json, "trail_intensity", JsonElement::getAsInt, (Integer)this.trailIntensity.value);
            this.healthStyle.value = HealthStyle.values()[Math.clamp((long)JsonUtil.getOrDefault(json, "health_style", JsonElement::getAsInt, Integer.valueOf(((HealthStyle)((Object)this.healthStyle.value)).ordinal())).intValue(), 0, HealthStyle.values().length)];
            this.selectedSaber.value = JsonUtil.getOrDefault(json, "selected_saber", JsonElement::getAsString, (String)this.selectedSaber.value);
        }
    }

    public class DebugSettings {
        public final LightshowSettings lightshow = new LightshowSettings();
        public final BeatmapSettings beatmap = new BeatmapSettings();

        public JsonObject getJson() {
            JsonObject json = new JsonObject();
            json.add("lightshow", (JsonElement)this.lightshow.getJson());
            json.add("beatmap", (JsonElement)this.beatmap.getJson());
            return json;
        }

        public PlayerConfig parent() {
            return PlayerConfig.this;
        }

        public void parse$old(JsonObject json) {
            if (json == null) {
                return;
            }
            this.lightshow.parse$old(json);
        }

        public void parse$v1(JsonObject json) {
            if (json == null) {
                return;
            }
            this.lightshow.parse$v1(json.getAsJsonObject("lightshow"));
            this.beatmap.parse$v1(json.getAsJsonObject("beatmap"));
        }

        public class LightshowSettings {
            public Option<Boolean> renderEvents = new Option<Boolean>(false, "Light/Color events", "");
            public Option<Float> beatSpacing = new Option<Float>(Float.valueOf(8.0f), "space between beats in blocks (meters)", "");
            public Option<Float> lookAheadDistance = new Option<Float>(Float.valueOf(16.0f), "Distance in beats to start rendering events", "");
            public Option<Float> lookBehindDistance = new Option<Float>(Float.valueOf(8.0f), "Distance in beats to stop rendering events", "");

            public boolean renderEvents() {
                return this.renderEvents.get();
            }

            public void renderEvents(boolean set) {
                this.renderEvents.set(set);
            }

            public float beatSpacing() {
                return this.beatSpacing.get().floatValue();
            }

            public void beatSpacing(float set) {
                this.beatSpacing.set(Float.valueOf(set));
            }

            public float lookAheadDistance() {
                return this.lookAheadDistance.get().floatValue();
            }

            public void lookAheadDistance(float set) {
                this.lookAheadDistance.set(Float.valueOf(set));
            }

            public float lookBehindDistance() {
                return this.lookBehindDistance.get().floatValue();
            }

            public void lookBehindDistance(float set) {
                this.lookBehindDistance.set(Float.valueOf(set));
            }

            public JsonObject getJson() {
                JsonObject json = new JsonObject();
                json.addProperty("render_events", (Boolean)this.renderEvents.value);
                json.addProperty("look_ahead", (Number)this.lookAheadDistance.value);
                json.addProperty("look_behind", (Number)this.lookBehindDistance.value);
                json.addProperty("beat_spacing", (Number)this.beatSpacing.value);
                return json;
            }

            public PlayerConfig parent() {
                return PlayerConfig.this;
            }

            public void parse$old(JsonObject json) {
                if (json == null) {
                    return;
                }
                this.renderEvents.value = JsonUtil.getOrDefault(json, "debug.lightshow.render_events", JsonElement::getAsBoolean, (Boolean)this.renderEvents.value);
                this.lookAheadDistance.value = Float.valueOf(Math.min(0.01f, JsonUtil.getOrDefault(json, "debug.lightshow.look_ahead", JsonElement::getAsFloat, (Float)this.lookAheadDistance.value).floatValue()));
                this.lookBehindDistance.value = Float.valueOf(Math.min(0.01f, JsonUtil.getOrDefault(json, "debug.lightshow.look_behind", JsonElement::getAsFloat, (Float)this.lookBehindDistance.value).floatValue()));
                this.beatSpacing.value = Float.valueOf(Math.min(0.01f, JsonUtil.getOrDefault(json, "debug.lightshow.beat_spacing", JsonElement::getAsFloat, (Float)this.beatSpacing.value).floatValue()));
            }

            public void parse$v1(JsonObject json) {
                if (json == null) {
                    return;
                }
                this.renderEvents.value = JsonUtil.getOrDefault(json, "render_events", JsonElement::getAsBoolean, (Boolean)this.renderEvents.value);
                this.lookAheadDistance.value = Float.valueOf(Math.min(0.01f, JsonUtil.getOrDefault(json, "look_ahead", JsonElement::getAsFloat, (Float)this.lookAheadDistance.value).floatValue()));
                this.lookBehindDistance.value = Float.valueOf(Math.min(0.01f, JsonUtil.getOrDefault(json, "look_behind", JsonElement::getAsFloat, (Float)this.lookBehindDistance.value).floatValue()));
                this.beatSpacing.value = Float.valueOf(Math.min(0.01f, JsonUtil.getOrDefault(json, "beat_spacing", JsonElement::getAsFloat, (Float)this.beatSpacing.value).floatValue()));
            }
        }

        public class BeatmapSettings {
            public Option<Boolean> renderArcSplines = new Option<Boolean>(false, "Arc splines and control points", "");
            public Option<Boolean> renderHitboxes = new Option<Boolean>(false, "Hitboxes for Notes and bombs", "");
            public Option<Boolean> renderSaberColliders = new Option<Boolean>(false, "Saber hitboxes, other debug info for scoring", "");
            public Option<Boolean> renderBeatmapPosition = new Option<Boolean>(false, "Render beatmap origin", "");

            public boolean renderArcSplines() {
                return this.renderArcSplines.get();
            }

            public void renderArcSplines(boolean set) {
                this.renderArcSplines.set(set);
            }

            public boolean renderHitboxes() {
                return this.renderHitboxes.get();
            }

            public void renderHitboxes(boolean set) {
                this.renderHitboxes.set(set);
            }

            public boolean renderSaberColliders() {
                return this.renderSaberColliders.get();
            }

            public void renderSaberColliders(boolean set) {
                this.renderSaberColliders.set(set);
            }

            public boolean renderBeatmapPosition() {
                return this.renderBeatmapPosition.get();
            }

            public void renderBeatmapPosition(boolean set) {
                this.renderBeatmapPosition.set(set);
            }

            public JsonObject getJson() {
                JsonObject json = new JsonObject();
                json.addProperty("arcs", (Boolean)this.renderArcSplines.value);
                json.addProperty("hitboxes", (Boolean)this.renderHitboxes.value);
                json.addProperty("sabers", (Boolean)this.renderSaberColliders.value);
                json.addProperty("map_position", (Boolean)this.renderBeatmapPosition.value);
                return json;
            }

            public PlayerConfig parent() {
                return PlayerConfig.this;
            }

            public void parse$v1(JsonObject json) {
                if (json == null) {
                    return;
                }
                this.renderArcSplines.value = JsonUtil.getOrDefault(json, "arcs", JsonElement::getAsBoolean, (Boolean)this.renderArcSplines.value);
                this.renderHitboxes.value = JsonUtil.getOrDefault(json, "hitboxes", JsonElement::getAsBoolean, (Boolean)this.renderHitboxes.value);
                this.renderSaberColliders.value = JsonUtil.getOrDefault(json, "sabers", JsonElement::getAsBoolean, (Boolean)this.renderSaberColliders.value);
                this.renderBeatmapPosition.value = JsonUtil.getOrDefault(json, "map_position", JsonElement::getAsBoolean, (Boolean)this.renderBeatmapPosition.value);
            }
        }
    }

    public class MiscSettings {
        public Option<Boolean> allowBeatmapSharing = new Option<Boolean>(false, "If enabled, map info will be sent to the server and other players will be able to download maps from you (including custom maps you have that aren't on beatsaver)", "");

        public PlayerConfig parent() {
            return PlayerConfig.this;
        }

        public JsonObject getJson() {
            JsonObject json = new JsonObject();
            json.addProperty("share_beatmaps", (Boolean)this.allowBeatmapSharing.value);
            return json;
        }

        public void parse$v1(JsonObject json) {
            if (json == null) {
                return;
            }
            this.allowBeatmapSharing.value = JsonUtil.getOrDefault(json, "share_beatmaps", JsonElement::getAsBoolean, (Boolean)this.allowBeatmapSharing.value);
        }
    }

    public static enum HealthStyle {
        Classic,
        Hearts;

    }

    public static class Option<T> {
        private T value;
        public final String description;
        public final String note;

        public Option(T value, String description, String note) {
            this.value = value;
            this.description = description;
            this.note = note;
        }

        public void set(T val) {
            this.value = val;
        }

        public T get() {
            return this.value;
        }
    }
}

