/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.common.memory;

import com.beatcraft.Beatcraft;
import java.util.Stack;
import net.minecraft.class_243;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class MemoryPool {
    private static final Stack<Vector3f> sharedVector3fs = new Stack();
    private static long sharedVector3fBalance = 0L;
    private static final Stack<Vector2f> sharedVector2fs = new Stack();
    private static long sharedVector2fBalance = 0L;
    private static final Stack<Quaternionf> sharedQuaternionfs = new Stack();
    private static long sharedQuaternionfBalance = 0L;

    public static Vector3f newVector3f(Vector3f copyFrom) {
        return MemoryPool.newVector3f(copyFrom.x, copyFrom.y, copyFrom.z);
    }

    public static Vector3f newVector3f(class_243 copyFrom) {
        return MemoryPool.newVector3f((float)copyFrom.field_1352, (float)copyFrom.field_1351, (float)copyFrom.field_1350);
    }

    public static Vector3f newVector3f() {
        return MemoryPool.newVector3f(0.0f, 0.0f, 0.0f);
    }

    public static Vector3f newVector3f(float x, float y, float z) {
        ++sharedVector3fBalance;
        return sharedVector3fs.isEmpty() ? new Vector3f(x, y, z) : sharedVector3fs.pop().set(x, y, z);
    }

    public static Vector2f newVector2f(Vector2f copyFrom) {
        return MemoryPool.newVector2f(copyFrom.x, copyFrom.y);
    }

    public static Vector2f newVector2f() {
        return MemoryPool.newVector2f(0.0f, 0.0f);
    }

    public static Vector2f newVector2f(float x, float y) {
        ++sharedVector2fBalance;
        return sharedVector2fs.isEmpty() ? new Vector2f(x, y) : sharedVector2fs.pop().set(x, y);
    }

    public static Quaternionf newQuaternionf(Quaternionf copyFrom) {
        return MemoryPool.newQuaternionf(copyFrom.x, copyFrom.y, copyFrom.z, copyFrom.w);
    }

    public static Quaternionf newQuaternionf() {
        return MemoryPool.newQuaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static Quaternionf newQuaternionf(float x, float y, float z, float w) {
        ++sharedQuaternionfBalance;
        return sharedQuaternionfs.isEmpty() ? new Quaternionf(x, y, z, w) : sharedQuaternionfs.pop().set(x, y, z, w);
    }

    public static void releaseSafe(Vector3f ... vectors) {
        for (Vector3f vec : vectors) {
            sharedVector3fs.push(vec);
            if (--sharedVector3fBalance >= 0L) continue;
            sharedVector3fBalance = 0L;
        }
    }

    public static void release(Vector3f ... vectors) {
        for (Vector3f vec : vectors) {
            sharedVector3fs.push(vec);
            if (--sharedVector3fBalance >= 0L) continue;
            throw new RuntimeException("Vector3f memory balance went negative. this would cause a memory leak!");
        }
    }

    public static void release(Vector2f vec) {
        sharedVector2fs.push(vec);
        if (--sharedVector2fBalance < 0L) {
            throw new RuntimeException("Vector2f memory balance went negative. this would cause a memory leak!");
        }
    }

    public static void release(Vector2f ... vectors) {
        for (Vector2f vec : vectors) {
            MemoryPool.release(vec);
        }
    }

    public static void release(Quaternionf quat) {
        sharedQuaternionfs.push(quat);
        if (--sharedQuaternionfBalance < 0L) {
            throw new RuntimeException("Quaternionf memory balance went negative. this would cause a memory leak!");
        }
    }

    public static void releaseSafe(Quaternionf ... quaternions) {
        for (Quaternionf vec : quaternions) {
            sharedQuaternionfs.push(vec);
            if (--sharedQuaternionfBalance >= 0L) continue;
            sharedQuaternionfBalance = 0L;
        }
    }

    public static void clear() {
        sharedVector2fs.clear();
        sharedVector3fs.clear();
        sharedQuaternionfs.clear();
        Beatcraft.LOGGER.info("final shared memory balance: V3:{} V2:{} Q:{}", new Object[]{sharedVector3fBalance, sharedVector2fBalance, sharedQuaternionfBalance});
        sharedVector3fBalance = 0L;
        sharedVector2fBalance = 0L;
        sharedQuaternionfBalance = 0L;
    }
}

