/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.fabric.client.services;

import com.beatcraft.client.commands.ClientCommands;
import com.beatcraft.client.commands.CommandTree;
import com.beatcraft.client.services.ICommandManager;
import com.beatcraft.fabric.client.command.FabricCommandCallback;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2274;
import net.minecraft.class_2277;
import net.minecraft.class_5242;

public class CommandManager
implements ICommandManager {
    @Override
    public void register(CommandTree ... commands) {
        ClientCommandRegistrationCallback.EVENT.register((commandDispatcher, commandBuildContext) -> {
            for (CommandTree cmd : commands) {
                ArgumentBuilder<FabricClientCommandSource, ?> builder = this.parse(cmd);
                commandDispatcher.register((LiteralArgumentBuilder)builder);
            }
        });
    }

    private ArgumentBuilder<FabricClientCommandSource, ?> parse(CommandTree cmd) {
        LiteralArgumentBuilder builder;
        if (cmd.type == CommandTree.ArgumentType.Literal) {
            builder = ClientCommandManager.literal((String)cmd.name);
        } else {
            builder = ClientCommandManager.argument((String)cmd.name, this.getArg(cmd.type));
            if (cmd.suggestionProvider != null) {
                ((RequiredArgumentBuilder)builder).suggests((ctx, suggestionsBuilder) -> {
                    FabricCommandCallback callback = new FabricCommandCallback((CommandContext<FabricClientCommandSource>)ctx);
                    return cmd.suggestionProvider.apply(callback, suggestionsBuilder);
                });
            }
        }
        if (cmd.callback != null) {
            builder.executes(ctx -> {
                FabricCommandCallback cb = new FabricCommandCallback((CommandContext<FabricClientCommandSource>)ctx);
                ClientCommands.CommandResult fb = cmd.callback.apply(cb);
                if (fb.msg != null) {
                    if (fb.state >= 0) {
                        ((FabricClientCommandSource)ctx.getSource()).sendFeedback(fb.msg);
                    } else {
                        ((FabricClientCommandSource)ctx.getSource()).sendError(fb.msg);
                    }
                }
                return fb.state;
            });
        }
        for (CommandTree subBranch : cmd.branches) {
            builder.then(this.parse(subBranch));
        }
        return builder;
    }

    private ArgumentType<?> getArg(CommandTree.ArgumentType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case CommandTree.ArgumentType.Literal -> throw new RuntimeException("Tried to parse literal as argument");
            case CommandTree.ArgumentType.Integer -> IntegerArgumentType.integer();
            case CommandTree.ArgumentType.Float -> FloatArgumentType.floatArg();
            case CommandTree.ArgumentType.Vec3i -> class_2277.method_9735((boolean)false);
            case CommandTree.ArgumentType.Vec3f -> class_2277.method_9735((boolean)false);
            case CommandTree.ArgumentType.Vec2i -> class_2274.method_35802((boolean)false);
            case CommandTree.ArgumentType.Vec2f -> class_2274.method_35802((boolean)false);
            case CommandTree.ArgumentType.Uuid -> class_5242.method_27643();
            case CommandTree.ArgumentType.String -> StringArgumentType.string();
        };
    }
}

