/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.animation.AnimationPropertyContainer;
import com.beatcraft.client.animation.AnimationState;
import com.beatcraft.client.animation.event.AnimatedPathEventContainer;
import com.beatcraft.client.animation.event.AnimatedPropertyEventContainer;
import com.beatcraft.client.animation.pointdefinition.ColorPointDefinition;
import com.beatcraft.client.animation.pointdefinition.FloatPointDefinition;
import com.beatcraft.client.animation.pointdefinition.QuaternionPointDefinition;
import com.beatcraft.client.animation.pointdefinition.Vector3PointDefinition;
import com.beatcraft.client.animation.pointdefinition.Vector4PointDefinition;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.data.event.AnimateTrack;
import com.beatcraft.client.beatmap.data.event.AssignPathAnimation;
import com.beatcraft.client.beatmap.object.data.IBeatmapData;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import net.minecraft.util.GsonHelper;

public class Animation
extends AnimationPropertyContainer<FloatPointDefinition, Vector3PointDefinition, Vector4PointDefinition, QuaternionPointDefinition, ColorPointDefinition>
implements IBeatmapData<Animation> {
    private BeatmapController map;

    public Animation(BeatmapController map) {
        this.map = map;
    }

    @Override
    public Animation loadV2(JsonObject json, Difficulty difficulty) {
        this.offsetPosition = this.getPointDefinition(this.map, json, "_position", difficulty, Vector3PointDefinition::new);
        this.offsetWorldRotation = this.getPointDefinition(this.map, json, "_rotation", difficulty, QuaternionPointDefinition::new);
        this.localRotation = this.getPointDefinition(this.map, json, "_localRotation", difficulty, QuaternionPointDefinition::new);
        this.localPosition = this.getPointDefinition(this.map, json, "_localPosition", difficulty, Vector3PointDefinition::new);
        this.definitePosition = this.getPointDefinition(this.map, json, "_definitePosition", difficulty, Vector3PointDefinition::new);
        this.position = this.getPointDefinition(this.map, json, "_position", difficulty, Vector3PointDefinition::new);
        this.rotation = this.getPointDefinition(this.map, json, "_rotation", difficulty, QuaternionPointDefinition::new);
        this.scale = this.getPointDefinition(this.map, json, "_scale", difficulty, Vector3PointDefinition::new);
        this.dissolve = this.getPointDefinition(this.map, json, "_dissolve", difficulty, FloatPointDefinition::new);
        this.dissolveArrow = this.getPointDefinition(this.map, json, "_dissolveArrow", difficulty, FloatPointDefinition::new);
        this.interactable = this.getPointDefinition(this.map, json, "_interactable", difficulty, FloatPointDefinition::new);
        this.time = this.getPointDefinition(this.map, json, "_time", difficulty, FloatPointDefinition::new);
        this.color = this.getPointDefinition(this.map, json, "_color", difficulty, ColorPointDefinition::new);
        return this;
    }

    @Override
    public Animation loadV3(JsonObject json, Difficulty difficulty) {
        this.offsetPosition = this.getPointDefinition(this.map, json, "offsetPosition", difficulty, Vector3PointDefinition::new);
        this.offsetWorldRotation = this.getPointDefinition(this.map, json, "offsetWorldRotation", difficulty, QuaternionPointDefinition::new);
        this.localRotation = this.getPointDefinition(this.map, json, "localRotation", difficulty, QuaternionPointDefinition::new);
        this.localPosition = this.getPointDefinition(this.map, json, "localPosition", difficulty, Vector3PointDefinition::new);
        this.definitePosition = this.getPointDefinition(this.map, json, "definitePosition", difficulty, Vector3PointDefinition::new);
        this.position = this.getPointDefinition(this.map, json, "position", difficulty, Vector3PointDefinition::new);
        this.rotation = this.getPointDefinition(this.map, json, "rotation", difficulty, QuaternionPointDefinition::new);
        this.scale = this.getPointDefinition(this.map, json, "scale", difficulty, Vector3PointDefinition::new);
        this.dissolve = this.getPointDefinition(this.map, json, "dissolve", difficulty, FloatPointDefinition::new);
        this.dissolveArrow = this.getPointDefinition(this.map, json, "dissolveArrow", difficulty, FloatPointDefinition::new);
        this.interactable = this.getPointDefinition(this.map, json, "interactable", difficulty, FloatPointDefinition::new);
        this.time = this.getPointDefinition(this.map, json, "time", difficulty, FloatPointDefinition::new);
        this.color = this.getPointDefinition(this.map, json, "color", difficulty, ColorPointDefinition::new);
        return this;
    }

    private <T> T getPointDefinition(BeatmapController map, JsonObject json, String property, Difficulty difficulty, BiFunction<BeatmapController, JsonArray, T> factory) {
        if (!json.has(property)) {
            return null;
        }
        JsonElement element = json.get(property);
        if (GsonHelper.isStringValue((JsonElement)element)) {
            String name = element.getAsString();
            if (difficulty.pointDefinitions.containsKey(name)) {
                return factory.apply(map, difficulty.pointDefinitions.get(name));
            }
            Beatcraft.LOGGER.warn("Point Definition [{}] does not exist! Skipping...", (Object)name);
            return null;
        }
        return factory.apply(map, element.getAsJsonArray());
    }

    public AnimatedPropertyEventContainer toAnimatedPropertyEvents(AnimateTrack animateTrack) {
        return new AnimatedPropertyEventContainer(this, animateTrack);
    }

    public AnimatedPathEventContainer toAnimatedPathEvents(AssignPathAnimation assignPathAnimation) {
        return new AnimatedPathEventContainer(this, assignPathAnimation);
    }

    public AnimationState toState(float time) {
        return AnimationState.fromAnimation(this, time);
    }
}

