/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation;

import com.beatcraft.client.animation.AnimationPropertyContainer;
import com.beatcraft.client.animation.AnimationState;
import com.beatcraft.client.animation.event.AnimatedPathEventHandler;
import com.beatcraft.client.animation.event.Path;
import com.beatcraft.client.animation.track.AnimatedPath;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.utils.MathUtil;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class PathState
extends AnimationPropertyContainer<Path<Float>, Path<Vector3f>, Path<Vector4f>, Path<Quaternionf>, Path<Color>> {
    public void seekFromPath(float beat, AnimatedPath path) {
        this.offsetPosition = ((AnimatedPathEventHandler)path.offsetPosition).seek(beat);
        this.offsetWorldRotation = ((AnimatedPathEventHandler)path.offsetWorldRotation).seek(beat);
        this.localRotation = ((AnimatedPathEventHandler)path.localRotation).seek(beat);
        this.localPosition = ((AnimatedPathEventHandler)path.localPosition).seek(beat);
        this.definitePosition = ((AnimatedPathEventHandler)path.definitePosition).seek(beat);
        this.position = ((AnimatedPathEventHandler)path.position).seek(beat);
        this.rotation = ((AnimatedPathEventHandler)path.rotation).seek(beat);
        this.scale = ((AnimatedPathEventHandler)path.scale).seek(beat);
        this.dissolve = ((AnimatedPathEventHandler)path.dissolve).seek(beat);
        this.dissolveArrow = ((AnimatedPathEventHandler)path.dissolveArrow).seek(beat);
        this.interactable = ((AnimatedPathEventHandler)path.interactable).seek(beat);
        this.time = ((AnimatedPathEventHandler)path.time).seek(beat);
        this.color = ((AnimatedPathEventHandler)path.color).seek(beat);
    }

    public void updateFromPath(float beat, AnimatedPath path) {
        this.offsetPosition = ((AnimatedPathEventHandler)path.offsetPosition).update(beat);
        this.offsetWorldRotation = ((AnimatedPathEventHandler)path.offsetWorldRotation).update(beat);
        this.localRotation = ((AnimatedPathEventHandler)path.localRotation).update(beat);
        this.localPosition = ((AnimatedPathEventHandler)path.localPosition).update(beat);
        this.definitePosition = ((AnimatedPathEventHandler)path.definitePosition).update(beat);
        this.position = ((AnimatedPathEventHandler)path.position).update(beat);
        this.rotation = ((AnimatedPathEventHandler)path.rotation).update(beat);
        this.scale = ((AnimatedPathEventHandler)path.scale).update(beat);
        this.dissolve = ((AnimatedPathEventHandler)path.dissolve).update(beat);
        this.dissolveArrow = ((AnimatedPathEventHandler)path.dissolveArrow).update(beat);
        this.interactable = ((AnimatedPathEventHandler)path.interactable).update(beat);
        this.time = ((AnimatedPathEventHandler)path.time).update(beat);
        this.color = ((AnimatedPathEventHandler)path.color).update(beat);
    }

    public AnimationState interpolate(float t) {
        AnimationState state = new AnimationState();
        state.offsetPosition = PathState.interpolatePath((Path)this.offsetPosition, t, MathUtil::lerpVector3);
        state.offsetWorldRotation = PathState.interpolatePath((Path)this.offsetWorldRotation, t, MathUtil::lerpQuaternion);
        state.localRotation = PathState.interpolatePath((Path)this.localRotation, t, MathUtil::lerpQuaternion);
        state.localPosition = PathState.interpolatePath((Path)this.localPosition, t, MathUtil::lerpVector3);
        state.definitePosition = PathState.interpolatePath((Path)this.definitePosition, t, MathUtil::lerpVector3);
        state.position = PathState.interpolatePath((Path)this.position, t, MathUtil::lerpVector3);
        state.rotation = PathState.interpolatePath((Path)this.rotation, t, MathUtil::lerpQuaternion);
        state.scale = PathState.interpolatePath((Path)this.scale, t, MathUtil::lerpVector3);
        state.dissolve = PathState.interpolatePath((Path)this.dissolve, t, Math::lerp);
        state.dissolveArrow = PathState.interpolatePath((Path)this.dissolveArrow, t, Math::lerp);
        state.interactable = PathState.interpolatePath((Path)this.interactable, t, Math::lerp);
        state.time = PathState.interpolatePath((Path)this.time, t, Math::lerp);
        state.color = PathState.interpolatePath((Path)this.color, t, MathUtil::lerpColor);
        return state;
    }

    private static <T> T interpolatePath(Path<T> path, float time, Path.Interpolation<T> interpolation) {
        if (path == null) {
            return null;
        }
        return path.interpolate(time, interpolation);
    }
}

