/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.base_providers;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.animation.base_providers.BaseRotationProvider;
import com.beatcraft.client.animation.base_providers.BaseValueProvider;
import com.beatcraft.client.animation.base_providers.RotationProvider;
import com.beatcraft.client.animation.base_providers.SmoothRotationProvider;
import com.beatcraft.client.animation.base_providers.SmoothValueProvider;
import com.beatcraft.client.animation.base_providers.StaticValueProvider;
import com.beatcraft.client.animation.base_providers.SwizzleProvider;
import com.beatcraft.client.animation.base_providers.UpdatableValue;
import com.beatcraft.client.animation.base_providers.ValueProvider;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.ColorScheme;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.memory.MemoryPool;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BaseProviderHandler {
    public final BeatmapController controller;
    private final HashMap<String, ValueProvider> baseProviders = new HashMap();
    private final HashSet<UpdatableValue> updatableBaseProviders = new HashSet();
    private final HashMap<String, UpdatableValue> updatableProviders = new HashMap();

    public BaseProviderHandler(BeatmapController player) {
        this.controller = player;
    }

    public void update() {
        this.updatableProviders.values().forEach(UpdatableValue::update);
        this.updatableBaseProviders.forEach(UpdatableValue::update);
    }

    public void clear() {
        this.updatableProviders.clear();
    }

    public ValueProvider getProvider(String provider) {
        String[] splits = provider.split("\\.");
        ValueProvider base = this.baseProviders.get(splits[0]);
        if (splits.length == 1) {
            return base;
        }
        if (this.updatableProviders.containsKey(provider)) {
            return this.updatableProviders.get(provider);
        }
        Object subkey = splits[0];
        for (int i = 1; i < splits.length; ++i) {
            String split = splits[i];
            if (this.updatableProviders.containsKey(subkey = (String)subkey + "." + split)) {
                base = this.updatableProviders.get(subkey);
                continue;
            }
            if (split.startsWith("s")) {
                float mult = Float.parseFloat(split.substring(1).replace("_", "."));
                base = base instanceof RotationProvider ? new SmoothRotationProvider((RotationProvider)((Object)base), mult) : new SmoothValueProvider(base.getValues(), mult);
            } else {
                int[] parts = new int[split.length()];
                for (int c = 0; c < split.length(); ++c) {
                    parts[c] = switch (split.charAt(c)) {
                        case 'x' -> 0;
                        case 'y' -> 1;
                        case 'z' -> 2;
                        case 'w' -> 3;
                        default -> throw new IllegalArgumentException("swizzle can only contain x, y, z, and w");
                    };
                }
                base = new SwizzleProvider(base.getValues(), parts);
            }
            this.updatableProviders.put((String)subkey, (UpdatableValue)base);
        }
        return base;
    }

    public ValueProvider parseFromJson(JsonArray json, int expectedSize) {
        JsonElement a = json.get(0);
        if (a.isJsonPrimitive()) {
            if (a.getAsJsonPrimitive().isString()) {
                String s = a.getAsString();
                return this.getProvider(s);
            }
            if (a.getAsJsonPrimitive().isNumber()) {
                float[] vals = new float[expectedSize];
                for (int i = 0; i < expectedSize; ++i) {
                    JsonElement x = json.get(i);
                    if (x.isJsonPrimitive() && x.getAsJsonPrimitive().isNumber()) {
                        vals[i] = x.getAsFloat();
                        continue;
                    }
                    Beatcraft.LOGGER.warn("unhandled non-float value: {}", (Object)x);
                    vals[i] = 1.0f;
                }
                return new StaticValueProvider(vals);
            }
            Beatcraft.LOGGER.warn("Using fallback provider of 1s");
            float[] vals = new float[expectedSize];
            Arrays.fill(vals, 1.0f);
            return new StaticValueProvider(vals);
        }
        if (a.isJsonArray()) {
            JsonArray b = a.getAsJsonArray();
            float[] vals = new float[expectedSize];
            for (int i = 0; i < expectedSize; ++i) {
                JsonElement x = b.get(i);
                if (x.isJsonPrimitive() && x.getAsJsonPrimitive().isNumber()) {
                    vals[i] = x.getAsFloat();
                    continue;
                }
                Beatcraft.LOGGER.warn("unhandled non-float value (2): {}", (Object)x);
                vals[i] = 1.0f;
            }
            return new StaticValueProvider(vals);
        }
        Beatcraft.LOGGER.warn("using fallback provider of 1s");
        float[] f = new float[expectedSize];
        Arrays.fill(f, 1.0f);
        return new StaticValueProvider(f);
    }

    public void setupDynamicProviders() {
        this.baseProviders.clear();
        this.updatableBaseProviders.clear();
        BaseValueProvider baseHeadPosition = new BaseValueProvider(3, out -> {
            Vector3f v = this.controller.logic.headPos;
            out[0] = v.x;
            out[1] = v.y;
            out[2] = v.z;
        });
        BaseValueProvider baseHeadLocalPosition = new BaseValueProvider(3, out -> {
            Vector3f v = this.controller.logic.headPos;
            Vector3f o = this.controller.logic.playerGlobalPosition;
            out[0] = v.x - o.x;
            out[1] = v.y - o.y;
            out[2] = v.z - o.z;
        });
        BaseRotationProvider baseHeadRotation = new BaseRotationProvider(out -> out.set((Quaternionfc)this.controller.logic.headRot));
        BaseRotationProvider baseHeadLocalRotation = new BaseRotationProvider(out -> {
            Quaternionf h = this.controller.logic.headRot;
            Quaternionf o = this.controller.logic.playerGlobalRotation.conjugate(MemoryPool.newQuaternionf());
            out.set((Quaternionfc)h.mul((Quaternionfc)o));
            MemoryPool.releaseSafe(o);
        });
        BaseValueProvider baseHeadLocalScale = new BaseValueProvider(3, out -> {
            out[0] = 1.0f;
            out[1] = 1.0f;
            out[2] = 1.0f;
        });
        BaseValueProvider baseLeftHandPosition = new BaseValueProvider(3, out -> {
            Vector3f v = this.controller.logic.leftSaberPos;
            out[0] = v.x;
            out[1] = v.y;
            out[2] = v.z;
        });
        BaseValueProvider baseLeftHandLocalPosition = new BaseValueProvider(3, out -> {
            Vector3f v = this.controller.logic.leftSaberPos;
            Vector3f o = this.controller.logic.playerGlobalPosition;
            out[0] = v.x - o.x;
            out[1] = v.y - o.y;
            out[2] = v.z - o.z;
        });
        BaseRotationProvider baseLeftHandRotation = new BaseRotationProvider(out -> out.set((Quaternionfc)this.controller.logic.leftSaberRotation));
        BaseRotationProvider baseLeftHandLocalRotation = new BaseRotationProvider(out -> {
            Quaternionf h = this.controller.logic.leftSaberRotation;
            Quaternionf o = this.controller.logic.playerGlobalRotation.conjugate(MemoryPool.newQuaternionf());
            out.set((Quaternionfc)h.mul((Quaternionfc)o));
            MemoryPool.releaseSafe(o);
        });
        BaseValueProvider baseLeftHandLocalScale = new BaseValueProvider(3, out -> {
            out[0] = 1.0f;
            out[1] = 1.0f;
            out[2] = 1.0f;
        });
        BaseValueProvider baseRightHandPosition = new BaseValueProvider(3, out -> {
            Vector3f v = this.controller.logic.rightSaberPos;
            out[0] = v.x;
            out[1] = v.y;
            out[2] = v.z;
        });
        BaseValueProvider baseRightHandLocalPosition = new BaseValueProvider(3, out -> {
            Vector3f v = this.controller.logic.rightSaberPos;
            Vector3f o = this.controller.logic.playerGlobalPosition;
            out[0] = v.x - o.x;
            out[1] = v.y - o.y;
            out[2] = v.z - o.z;
        });
        BaseRotationProvider baseRightHandRotation = new BaseRotationProvider(out -> out.set((Quaternionfc)this.controller.logic.rightSaberRotation));
        BaseRotationProvider baseRightHandLocalRotation = new BaseRotationProvider(out -> {
            Quaternionf h = this.controller.logic.rightSaberRotation;
            Quaternionf o = this.controller.logic.playerGlobalRotation.conjugate(MemoryPool.newQuaternionf());
            out.set((Quaternionfc)h.mul((Quaternionfc)o));
            MemoryPool.releaseSafe(o);
        });
        BaseValueProvider baseRightHandLocalScale = new BaseValueProvider(3, out -> {
            out[0] = 1.0f;
            out[1] = 1.0f;
            out[2] = 1.0f;
        });
        BaseValueProvider baseCombo = new BaseValueProvider(1, out -> {
            out[0] = this.controller.logic.getCombo();
        });
        BaseValueProvider baseMultipliedScore = new BaseValueProvider(1, out -> {
            out[0] = this.controller.logic.getScore();
        });
        BaseValueProvider baseMaxPossibleMultipliedScore = new BaseValueProvider(1, out -> {
            out[0] = this.controller.logic.getMaxPossibleScore();
        });
        BaseValueProvider baseModifiedScore = new BaseValueProvider(1, out -> {
            out[0] = this.controller.logic.getScore();
        });
        BaseValueProvider baseMaxPossibleModifiedScore = new BaseValueProvider(1, out -> {
            out[0] = this.controller.logic.getMaxPossibleScore();
        });
        BaseValueProvider baseRelativeScore = new BaseValueProvider(1, out -> {
            out[0] = this.controller.logic.getAccuracy();
        });
        BaseValueProvider baseMultiplier = new BaseValueProvider(1, out -> {
            out[0] = this.controller.logic.getBonusModifier();
        });
        BaseValueProvider baseEnergy = new BaseValueProvider(1, out -> {
            out[0] = this.controller.logic.getHealthPercentage();
        });
        BaseValueProvider baseSongTime = new BaseValueProvider(1, out -> {
            out[0] = this.controller.currentSeconds;
        });
        BaseValueProvider baseSongLength = new BaseValueProvider(1, out -> {
            if (this.controller.info != null) {
                out[0] = this.controller.info.getSongDuration();
            }
        });
        this.baseProviders.putAll(Map.ofEntries(Map.entry("baseHeadPosition", baseHeadPosition), Map.entry("baseHeadLocalPosition", baseHeadLocalPosition), Map.entry("baseHeadRotation", baseHeadRotation), Map.entry("baseHeadLocalRotation", baseHeadLocalRotation), Map.entry("baseHeadLocalScale", baseHeadLocalScale), Map.entry("baseLeftHandPosition", baseLeftHandPosition), Map.entry("baseLeftHandLocalPosition", baseLeftHandLocalPosition), Map.entry("baseLeftHandRotation", baseLeftHandRotation), Map.entry("baseLeftHandLocalRotation", baseLeftHandLocalRotation), Map.entry("baseLeftHandLocalScale", baseLeftHandLocalScale), Map.entry("baseRightHandPosition", baseRightHandPosition), Map.entry("baseRightHandLocalPosition", baseRightHandLocalPosition), Map.entry("baseRightHandRotation", baseRightHandRotation), Map.entry("baseRightHandLocalRotation", baseRightHandLocalRotation), Map.entry("baseRightHandLocalScale", baseRightHandLocalScale), Map.entry("baseCombo", baseCombo), Map.entry("baseMultipliedScore", baseMultipliedScore), Map.entry("baseImmediateMaxPossibleMultipliedScore", baseMaxPossibleMultipliedScore), Map.entry("baseModifiedScore", baseModifiedScore), Map.entry("baseImmediateMaxPossibleModifiedScore", baseMaxPossibleModifiedScore), Map.entry("baseRelativeScore", baseRelativeScore), Map.entry("baseMultiplier", baseMultiplier), Map.entry("baseEnergy", baseEnergy), Map.entry("baseSongTime", baseSongTime), Map.entry("baseSongLength", baseSongLength)));
        this.updatableBaseProviders.addAll(this.baseProviders.values().stream().map(v -> (UpdatableValue)v).toList());
    }

    private BaseValueProvider colorProvider(Color color) {
        return new BaseValueProvider(4, out -> {
            out[0] = color.getRed();
            out[1] = color.getGreen();
            out[2] = color.getBlue();
            out[3] = color.getAlpha();
        });
    }

    public void setupStaticProviders(ColorScheme cs) {
        Color note0 = cs.getNoteLeftColor();
        Color note1 = cs.getNoteRightColor();
        Color obstacle = cs.getObstacleColor();
        Color envC0 = cs.getEnvironmentLeftColor();
        Color envC1 = cs.getEnvironmentRightColor();
        Color envCW = cs.getEnvironmentWhiteColor();
        Color envB0 = cs.getEnvironmentLeftColorBoost();
        Color envB1 = cs.getEnvironmentRightColorBoost();
        Color envBW = cs.getEnvironmentWhiteColorBoost();
        this.baseProviders.putAll(Map.ofEntries(Map.entry("baseNote0Color", this.colorProvider(note0)), Map.entry("baseNote1Color", this.colorProvider(note1)), Map.entry("baseObstacleColor", this.colorProvider(obstacle)), Map.entry("baseSaberAColor", this.colorProvider(note0)), Map.entry("baseSaberBColor", this.colorProvider(note1)), Map.entry("baseEnvironmentColor0", this.colorProvider(envC0)), Map.entry("baseEnvironmentColor1", this.colorProvider(envC1)), Map.entry("baseEnvironmentColorW", this.colorProvider(envCW)), Map.entry("baseEnvironmentColor0Boost", this.colorProvider(envB0)), Map.entry("baseEnvironmentColor1Boost", this.colorProvider(envB1)), Map.entry("baseEnvironmentColorWBoost", this.colorProvider(envBW))));
    }
}

