/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.base_providers;

import com.beatcraft.client.animation.base_providers.RotationProvider;
import com.beatcraft.client.animation.base_providers.UpdatableValue;
import com.beatcraft.common.memory.MemoryPool;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

class SmoothRotationProvider
extends UpdatableValue {
    private final RotationProvider rotationProvider;
    private final float mult;
    private final float[] values = new float[3];
    private double lastTime;
    private final Quaternionf lastQuaternion = new Quaternionf();

    SmoothRotationProvider(RotationProvider provider, float mult) {
        this.rotationProvider = provider;
        this.mult = mult;
        this.lastTime = (double)System.nanoTime() / 1.0E9;
    }

    @Override
    public void update() {
        double t = (double)System.nanoTime() / 1.0E9;
        double dt = t - this.lastTime;
        this.lastTime = t;
        this.lastQuaternion.slerp((Quaternionfc)this.rotationProvider.getRotation(), (float)dt * this.mult);
        Vector3f e = MemoryPool.newVector3f();
        this.lastQuaternion.getEulerAnglesXYZ(e);
        this.values[0] = e.x;
        this.values[1] = e.y;
        this.values[2] = e.z;
        MemoryPool.releaseSafe(e);
    }

    @Override
    public float[] getValues() {
        return this.values;
    }
}

