/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.base_providers;

import com.beatcraft.client.animation.base_providers.UpdatableValue;

class ValueOperator
extends UpdatableValue {
    private final float[] src0;
    private final float[] src1;
    private final float[] values;
    private final String operation;

    public ValueOperator(float[] left, float[] right, String op) {
        this.src0 = left;
        this.src1 = right;
        this.values = new float[left.length];
        this.operation = op;
    }

    @Override
    public void update() {
        switch (this.operation) {
            case "opAdd": {
                for (int i = 0; i < this.src0.length; ++i) {
                    this.values[i] = this.src0[i] + this.src1[i];
                }
                break;
            }
            case "opSub": {
                for (int i = 0; i < this.src0.length; ++i) {
                    this.values[i] = this.src0[i] - this.src1[i];
                }
                break;
            }
            case "opMul": {
                for (int i = 0; i < this.src0.length; ++i) {
                    this.values[i] = this.src0[i] * this.src1[i];
                }
                break;
            }
            case "opDiv": {
                for (int i = 0; i < this.src0.length; ++i) {
                    this.values[i] = this.src0[i] / this.src1[i];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid operation: '" + this.operation + "'");
            }
        }
    }

    @Override
    public float[] getValues() {
        return this.values;
    }
}

