/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.pointdefinition;

import com.beatcraft.client.animation.base_providers.ColorReader;
import com.beatcraft.client.animation.base_providers.ValueProvider;
import com.beatcraft.client.animation.pointdefinition.Point;
import com.beatcraft.client.animation.pointdefinition.PointDefinition;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.utils.JsonUtil;
import com.beatcraft.common.utils.MathUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ColorPointDefinition
extends PointDefinition<Color> {
    public ColorPointDefinition(BeatmapController map, JsonArray json) throws RuntimeException {
        super(map, json);
    }

    @Override
    protected Color interpolatePoints(int a, int b, float time) {
        Color left = (Color)((Point)this.points.get(a)).getValue();
        Color right = (Color)((Point)this.points.get(b)).getValue();
        return MathUtil.lerpColor(left, right, time);
    }

    @Override
    protected int getValueLength(JsonArray inner) {
        JsonPrimitive prim;
        if (inner.get(0).isJsonPrimitive() && (prim = inner.get(0).getAsJsonPrimitive()).isString()) {
            return 1;
        }
        return 4;
    }

    @Override
    protected void loadValue(JsonArray json, Point<Color> point, boolean isSimple) {
        if (isSimple && json.size() == 3) {
            Vector3f v = JsonUtil.getVector3(json);
            point.setValue(new Color(v.x, v.y, v.z, 1.0f));
        } else if (ColorPointDefinition.isModifier((JsonElement)json)) {
            ValueProvider v = this.map.baseProvider.parseFromJson(json, 4);
            point.setValue(new ColorReader(v.getValues()));
        } else {
            Vector4f v = JsonUtil.getVector4(json);
            point.setValue(new Color(v.x, v.y, v.z, v.w));
        }
    }
}

