/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.pointdefinition;

import com.beatcraft.client.animation.base_providers.FloatReader;
import com.beatcraft.client.animation.base_providers.ValueProvider;
import com.beatcraft.client.animation.pointdefinition.Point;
import com.beatcraft.client.animation.pointdefinition.PointDefinition;
import com.beatcraft.client.beatmap.BeatmapController;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import org.joml.Math;

public class FloatPointDefinition
extends PointDefinition<Float> {
    public FloatPointDefinition(BeatmapController map, JsonArray json) throws RuntimeException {
        super(map, json);
    }

    @Override
    protected Float interpolatePoints(int a, int b, float time) {
        float left = ((Float)((Point)this.points.get(a)).getValue()).floatValue();
        float right = ((Float)((Point)this.points.get(b)).getValue()).floatValue();
        return Float.valueOf(Math.lerp((float)left, (float)right, (float)time));
    }

    @Override
    protected int getValueLength(JsonArray ignored) {
        return 1;
    }

    @Override
    protected void loadValue(JsonArray json, Point<Float> point, boolean isSimple) {
        if (FloatPointDefinition.isModifier((JsonElement)json)) {
            ValueProvider p = this.map.baseProvider.parseFromJson(json, 1);
            point.setValue(new FloatReader(p.getValues()));
        } else {
            float value = json.get(0).getAsFloat();
            point.setValue(Float.valueOf(value));
        }
    }
}

