/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.pointdefinition;

import com.beatcraft.client.animation.base_providers.QuaternionReader;
import com.beatcraft.client.animation.base_providers.ValueProvider;
import com.beatcraft.client.animation.pointdefinition.Point;
import com.beatcraft.client.animation.pointdefinition.PointDefinition;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.common.utils.JsonUtil;
import com.beatcraft.common.utils.MathUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import org.joml.Quaternionf;

public class QuaternionPointDefinition
extends PointDefinition<Quaternionf> {
    public QuaternionPointDefinition(BeatmapController map, JsonArray json) throws RuntimeException {
        super(map, json);
    }

    @Override
    protected Quaternionf interpolatePoints(int a, int b, float time) {
        Quaternionf left = (Quaternionf)((Point)this.points.get(a)).getValue();
        Quaternionf right = (Quaternionf)((Point)this.points.get(b)).getValue();
        return MathUtil.lerpQuaternion(left, right, time);
    }

    @Override
    protected int getValueLength(JsonArray ignored) {
        return 3;
    }

    @Override
    protected void loadValue(JsonArray json, Point<Quaternionf> point, boolean isSimple) {
        if (QuaternionPointDefinition.isModifier((JsonElement)json)) {
            ValueProvider p = this.map.baseProvider.parseFromJson(json, 4);
            point.setValue(new QuaternionReader(p.getValues()));
        } else {
            Quaternionf quaternion = JsonUtil.getQuaternion(json);
            point.setValue(quaternion);
        }
    }
}

