/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.track;

import com.beatcraft.client.animation.track.Track;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class TrackLibrary {
    private final HashMap<String, Track> trackMap = new HashMap();

    public Track getOrCreateTrack(String name) {
        if (this.trackMap.containsKey(name)) {
            return this.trackMap.get(name);
        }
        Track track = new Track();
        this.trackMap.put(name, track);
        return track;
    }

    public HashMap<String, Track> getTrackMap() {
        return this.trackMap;
    }

    public Collection<Track> getTracks() {
        return this.trackMap.values();
    }

    public Set<String> getTrackNames() {
        return this.trackMap.keySet();
    }

    public void seek(float beat) {
        this.getTracks().forEach(track -> {
            track.getAnimatedProperties().seek(beat);
            track.getAnimatedPath().seek(beat);
        });
    }

    public void update(float beat) {
        this.getTracks().forEach(track -> {
            track.getAnimatedProperties().update(beat);
            track.getAnimatedPath().update(beat);
        });
    }
}

