/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.audio;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.beatmap.BeatmapController;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sounds.JOrbisAudioStream;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.EXTEfx;

public class Audio {
    public final int[] buffer;
    public final int source;
    public int fullBuffer = 0;
    public boolean loaded;
    public Mode mode;
    public boolean closed = false;
    public Path filePath;
    public int formatId;
    public int sampleRate;
    public int channels;
    public int sampleSizeInBits;
    private boolean playing;
    private boolean paused;
    private final int wallFilter;
    private static final int STREAM_BUFFER_SIZE = 65536;
    private boolean wasInWall = false;
    private double lastSeconds = 0.0;

    public Audio(int[] buffer, int source, Mode mode) {
        this(buffer, source, true, mode);
    }

    public Audio(int[] buffer, int source, boolean loaded, Mode mode) {
        this.buffer = buffer;
        this.source = source;
        this.loaded = loaded;
        this.mode = mode;
        this.wallFilter = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)this.wallFilter, (int)32769, (int)1);
        EXTEfx.alFilterf((int)this.wallFilter, (int)1, (float)1.0f);
        EXTEfx.alFilterf((int)this.wallFilter, (int)2, (float)0.1f);
    }

    private static Audio erroredAudio(String path) {
        Audio a = new Audio(new int[0], 0, false, Mode.ERROR);
        a.closed = true;
        Beatcraft.LOGGER.error("\n///\n/// Song Failed to load: {}\n/// This is most likely due to the song's encoding.\n/// Check here for how to fix: https://github.com/Swifter1243/BeatCraft/wiki/Troubleshooting#encoding-issues\n///\n", (Object)path);
        return a;
    }

    private static int getFormatID(AudioFormat format) {
        AudioFormat.Encoding encoding = format.getEncoding();
        int channels = format.getChannels();
        int sampleSizeInBits = format.getSampleSizeInBits();
        if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) || encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (channels == 1) {
                if (sampleSizeInBits == 8) {
                    return 4352;
                }
                if (sampleSizeInBits == 16) {
                    return 4353;
                }
            } else if (channels == 2) {
                if (sampleSizeInBits == 8) {
                    return 4354;
                }
                if (sampleSizeInBits == 16) {
                    return 4355;
                }
            }
        }
        throw new IllegalArgumentException("Invalid audio format: " + String.valueOf(format));
    }

    public static Audio loadFromFile(String path, Mode mode) {
        int sampleRate;
        int formatId;
        AudioFormat format;
        Path filePath = Path.of(path, new String[0]);
        try (InputStream probeIn = Files.newInputStream(filePath, new OpenOption[0]);
             JOrbisAudioStream probeStream = new JOrbisAudioStream(probeIn);){
            format = probeStream.getFormat();
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to probe audio {}: {}", (Object)path, (Object)e.getMessage());
            return Audio.erroredAudio(path);
        }
        try {
            formatId = Audio.getFormatID(format);
            sampleRate = (int)format.getSampleRate();
        }
        catch (IllegalArgumentException ex) {
            Beatcraft.LOGGER.error("Unsupported audio format in {}: {}", (Object)path, (Object)ex.getMessage());
            return Audio.erroredAudio(path);
        }
        int source = AL10.alGenSources();
        int[] streamBuffers = new int[]{0, 0, 0, 0};
        AL10.alGenBuffers((int[])streamBuffers);
        Audio audio = new Audio(streamBuffers, source, false, mode);
        audio.filePath = filePath;
        audio.formatId = formatId;
        audio.sampleRate = sampleRate;
        audio.channels = format.getChannels();
        audio.sampleSizeInBits = format.getSampleSizeInBits();
        audio.loadFull();
        return audio;
    }

    /*
     * Exception decompiling
     */
    private byte[] decodeFile() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadFull() {
        try {
            byte[] pcm = this.decodeFile();
            if (this.closed) {
                return;
            }
            this.buffer[0] = AL10.alGenBuffers();
            ByteBuffer b = BufferUtils.createByteBuffer((int)pcm.length).put(pcm);
            b.flip();
            AL10.alBufferData((int)this.buffer[0], (int)this.formatId, (ByteBuffer)b, (int)this.sampleRate);
            AL10.alSourcei((int)this.source, (int)4105, (int)this.buffer[0]);
            this.loaded = true;
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to fully load audio", (Throwable)e);
        }
    }

    public void play() {
        if (this.closed || !this.loaded) {
            return;
        }
        this.playing = true;
        this.paused = false;
        AL10.alSourcePlay((int)this.source);
    }

    public void pause() {
        if (this.closed || !this.playing || !this.loaded) {
            return;
        }
        AL10.alSourcePause((int)this.source);
        this.paused = true;
    }

    public void stop() {
        if (this.closed) {
            return;
        }
        AL10.alSourceStop((int)this.source);
        this.playing = false;
        this.paused = false;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.fullBuffer != 0) {
            AL10.alDeleteBuffers((int)this.fullBuffer);
        }
        if (this.buffer.length > 0) {
            AL10.alDeleteBuffers((int[])this.buffer);
        }
        EXTEfx.alDeleteFilters((int)this.wallFilter);
        AL10.alSourceStop((int)this.source);
        AL10.alDeleteSources((int)this.source);
    }

    public void seek(float seconds) {
        if (this.closed) {
            return;
        }
        if (this.buffer[0] != 0) {
            AL10.alSourcef((int)this.source, (int)4132, (float)seconds);
            return;
        }
    }

    public void setSpeed(float speed) {
        AL10.alSourcef((int)this.source, (int)4099, (float)speed);
    }

    public void setVolume(float volume) {
        AL10.alSourcef((int)this.source, (int)4106, (float)volume);
    }

    public void update(float beat, double dt, BeatmapController controller) {
        if (!this.isLoaded()) {
            return;
        }
        if (Minecraft.getInstance().isPaused() || !controller.isPlaying()) {
            this.pause();
        } else {
            if (Math.abs((double)controller.currentSeconds - this.lastSeconds) > 0.2) {
                this.seek(controller.currentSeconds);
            }
            this.lastSeconds = controller.currentSeconds;
            if (!this.isPlaying()) {
                this.play();
            }
            if (controller.isInWall && !this.wasInWall) {
                this.applyFx();
            } else if (this.wasInWall && !controller.isInWall) {
                this.clearFx();
            }
            this.wasInWall = controller.isInWall;
        }
    }

    private void applyFx() {
        AL10.alSourcei((int)this.source, (int)131077, (int)this.wallFilter);
    }

    private void clearFx() {
        AL10.alSourcei((int)this.source, (int)131077, (int)0);
    }

    public boolean isOk() {
        return this.mode != Mode.ERROR;
    }

    public boolean isLoaded() {
        return this.loaded && !this.closed;
    }

    public boolean isPlaying() {
        return this.playing && !this.paused && !this.closed;
    }

    public boolean isPaused() {
        return this.paused && !this.closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static enum Mode {
        STREAM,
        INSTANT,
        FULL,
        ERROR;

    }
}

