/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.audio;

import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.audio.Audio;
import java.util.ArrayList;
import java.util.HashMap;

public class AudioController {
    private static final ArrayList<Audio> tracks = new ArrayList();
    private static final HashMap<Integer, Audio> channels = new HashMap();

    public static Audio playAudio(String path, Audio.Mode mode) {
        Audio audio = Audio.loadFromFile(path, mode);
        audio.play();
        return audio;
    }

    public static Audio playAudioForChannel(int channel, String path, Audio.Mode mode) {
        Audio audio;
        if (channels.containsKey(channel)) {
            Audio old = channels.remove(channel);
            old.close();
        }
        if ((audio = Audio.loadFromFile(path, mode)).isOk()) {
            channels.put(channel, audio);
            audio.play();
        }
        return audio;
    }

    public static void playMapPreview(String path, float startTime) {
        Audio audio = AudioController.playAudioForChannel(0, path, Audio.Mode.STREAM);
        audio.seek(startTime);
        audio.play();
    }

    public static void setVolume(float percent) {
        for (Audio track : tracks) {
            track.setVolume(percent);
        }
    }

    public static Audio playMapSong(String path) {
        if (channels.containsKey(0)) {
            Audio preview = channels.remove(0);
            preview.close();
        }
        Audio audio = AudioController.playAudio(path, Audio.Mode.INSTANT);
        audio.setVolume(BeatcraftClient.playerConfig.audio.volume());
        tracks.add(audio);
        return audio;
    }

    public static void remove(Audio audio) {
        tracks.remove(audio);
    }

    public static void stopPreview() {
        if (channels.containsKey(0)) {
            Audio preview = channels.remove(0);
            preview.close();
        }
    }
}

