/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.audio;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.audio.AudioInfo;
import com.google.gson.JsonObject;

public class BpmRegion {
    private final int startIndex;
    private final int endIndex;
    private final float startBeat;
    private final float endBeat;
    public final float bpm;
    private final AudioInfo info;

    public BpmRegion(AudioInfo parent, float bpm) {
        this.startIndex = -1;
        this.endIndex = -1;
        this.startBeat = -1.0f;
        this.endBeat = -1.0f;
        this.bpm = bpm;
        this.info = parent;
    }

    BpmRegion(AudioInfo parent, int startIndex, int endIndex, float startBeat, float endBeat) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.startBeat = startBeat;
        this.endBeat = endBeat;
        this.info = parent;
        float beats = endBeat - startBeat;
        int samples = endIndex - startIndex;
        int dt = samples / this.info.frequency;
        this.bpm = beats / (float)dt * 60.0f;
    }

    public float getBeat(float time) {
        if (this.endBeat == -1.0f) {
            return time / (60.0f / this.bpm);
        }
        float startTime = (float)this.startIndex / (float)this.info.frequency;
        if (time < startTime) {
            return 0.0f;
        }
        float duration = (float)this.endIndex / (float)this.info.frequency - startTime;
        float progress = Math.clamp((time - startTime) / duration, 0.0f, 1.0f);
        return this.startBeat + progress * (this.endBeat - this.startBeat);
    }

    public float getTime(float beat) {
        if (this.endBeat == -1.0f) {
            return beat * (60.0f / this.bpm);
        }
        if (beat < this.startBeat) {
            return 0.0f;
        }
        float progress = Math.clamp((beat - this.startBeat) / (this.endBeat - this.startBeat), 0.0f, 1.0f);
        float samples = (float)(this.endIndex - this.startIndex) * progress;
        float t = samples / (float)this.info.frequency;
        return t;
    }

    public boolean containsBeat(float currentBeat) {
        return this.endBeat == -1.0f || this.startBeat <= currentBeat && currentBeat < this.endBeat;
    }

    public static BpmRegion loadV2(JsonObject json, AudioInfo parent) {
        BpmRegion region = new BpmRegion(parent, json.get("_startSampleIndex").getAsInt(), json.get("_endSampleIndex").getAsInt(), json.get("_startBeat").getAsFloat(), json.get("_endBeat").getAsFloat());
        Beatcraft.LOGGER.info("BPM Region made V2: {}, {}, {}, {}", new Object[]{region.startIndex, region.endIndex, Float.valueOf(region.startBeat), Float.valueOf(region.endBeat)});
        return region;
    }

    public static BpmRegion loadV4(JsonObject json, AudioInfo parent) {
        BpmRegion region = new BpmRegion(parent, json.get("si").getAsInt(), json.get("ei").getAsInt(), json.get("sb").getAsFloat(), json.get("eb").getAsFloat());
        Beatcraft.LOGGER.info("BPM Region made V4: {}, {}, {}, {}", new Object[]{region.startIndex, region.endIndex, Float.valueOf(region.startBeat), Float.valueOf(region.endBeat)});
        return region;
    }
}

