/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.data;

import com.beatcraft.common.data.types.Color;

public class ColorScheme {
    private Color noteLeftColor = new Color(0.75294f, 0.188f, 0.188f);
    private Color noteRightColor = new Color(0.1254f, 0.3921f, 0.6588f);
    private Color obstacleColor = new Color(1.0f, 0.1882f, 0.1882f);
    private Color environmentLeftColor = new Color(0.7529f, 0.188f, 0.188f);
    private Color environmentLeftColorBoost = new Color(0.7529f, 0.188f, 0.188f);
    private Color environmentRightColor = new Color(0.18823f, 0.596f, 1.0f);
    private Color environmentRightColorBoost = new Color(0.18823f, 0.596f, 1.0f);
    private Color environmentWhiteColor = new Color(1.0f, 1.0f, 1.0f);
    private Color environmentWhiteColorBoost = new Color(1.0f, 1.0f, 1.0f);

    public static ColorScheme getEnvironmentColorScheme(String environmentName) {
        return switch (environmentName) {
            case "DefaultEnvironment" -> ColorScheme.getDefaultEnvironment();
            case "TriangleEnvironment" -> ColorScheme.getTriangleEnvironment();
            case "NiceEnvironment" -> ColorScheme.getNiceEnvironment();
            case "BigMirrorEnvironment" -> ColorScheme.getBigMirrorEnvironment();
            case "DragonsEnvironment" -> ColorScheme.getDragonsEnvironment();
            case "MonstercatEnvironment" -> ColorScheme.getMonstercatEnvironment();
            case "PanicEnvironment" -> ColorScheme.getPanicEnvironment();
            case "OriginsEnvironment" -> ColorScheme.getOriginsEnvironment();
            case "KDAEnvironment" -> ColorScheme.getKDAEnvironment();
            case "CrabRaveEnvironment" -> ColorScheme.getCrabRaveEnvironment();
            case "RocketEnvironment" -> ColorScheme.getRocketEnvironment();
            case "GreenDayEnvironment" -> ColorScheme.getGreenDayEnvironment();
            case "TimbalandEnvironment" -> ColorScheme.getTimbalandEnvironment();
            case "FitBeatEnvironment" -> ColorScheme.getFitBeatEnvironment();
            case "LinkinParkEnvironment" -> ColorScheme.getLinkinParkEnvironment();
            case "BTSEnvironment" -> ColorScheme.getBTSEnvironment();
            case "KaleidoscopeEnvironment" -> ColorScheme.getKaleidoscopeEnvironment();
            case "InterscopeEnvironment" -> ColorScheme.getInterscopeEnvironment();
            case "SkrillexEnvironment" -> ColorScheme.getSkrillexEnvironment();
            case "BillieEnvironment" -> ColorScheme.getBillieEnvironment();
            case "HalloweenEnvironment" -> ColorScheme.getHalloweenEnvironment();
            case "GagaEnvironment" -> ColorScheme.getGagaEnvironment();
            case "WeaveEnvironment" -> ColorScheme.getWeaveEnvironment();
            case "PyroEnvironment" -> ColorScheme.getPyroEnvironment();
            case "EDMEnvironment" -> ColorScheme.getEdmEnvironment();
            case "TheSecondEnvironment" -> ColorScheme.getTheSecondEnvironment();
            case "LizzoEnvironment" -> ColorScheme.getLizzoEnvironment();
            case "TheWeekndEnvironment" -> ColorScheme.getTheWeekndEnvironment();
            case "RockMixtapeEnvironment" -> ColorScheme.getRockMixtapeEnvironment();
            case "Dragons2Environment" -> ColorScheme.getDragons2Environment();
            case "Panic2Environment" -> ColorScheme.getPanic2Environment();
            case "QueenEnvironment" -> ColorScheme.getQueenEnvironment();
            case "LinkinPark2Environment" -> ColorScheme.getLinkinPark2Environment();
            case "TheRollingStonesEnvironment" -> ColorScheme.getTheRollingStonesEnvironment();
            case "LatticeEnvironment" -> ColorScheme.getLatticeEnvironment();
            case "DaftPunkEnvironment" -> ColorScheme.getDaftPunkEnvironment();
            case "HipHopEnvironment" -> ColorScheme.getHipHopEnvironment();
            case "ColliderEnvironment" -> ColorScheme.getColliderEnvironment();
            case "BritneyEnvironment" -> ColorScheme.getBritneyEnvironment();
            case "Monstercat2Environment" -> ColorScheme.getMonstercat2Environment();
            case "MetallicaEnvironment" -> ColorScheme.getMetallicaEnvironment();
            default -> new ColorScheme();
        };
    }

    public static ColorScheme getDefaultEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.7843137f, 0.07843138f, 0.07843138f));
        colorScheme.setNoteRightColor(new Color(0.1568627f, 0.5568627f, 0.8235294f));
        colorScheme.setEnvironmentLeftColor(new Color(0.85f, 0.08499997f, 0.08499997f));
        colorScheme.setEnvironmentRightColor(new Color(0.1882353f, 0.675294f, 1.0f));
        colorScheme.setObstacleColor(new Color(1.0f, 0.1882353f, 0.1882353f));
        return colorScheme;
    }

    public static ColorScheme getTriangleEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.7843137f, 0.07843138f, 0.07843138f));
        colorScheme.setNoteRightColor(new Color(0.1568627f, 0.5568627f, 0.8235294f));
        colorScheme.setEnvironmentLeftColor(new Color(0.85f, 0.08499997f, 0.08499997f));
        colorScheme.setEnvironmentRightColor(new Color(0.1882353f, 0.675294f, 1.0f));
        colorScheme.setObstacleColor(new Color(1.0f, 0.1882353f, 0.1882353f));
        return colorScheme;
    }

    public static ColorScheme getNiceEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.7843137f, 0.07843138f, 0.07843138f));
        colorScheme.setNoteRightColor(new Color(0.1568627f, 0.5568627f, 0.8235294f));
        colorScheme.setEnvironmentLeftColor(new Color(0.85f, 0.08499997f, 0.08499997f));
        colorScheme.setEnvironmentRightColor(new Color(0.1882353f, 0.675294f, 1.0f));
        colorScheme.setObstacleColor(new Color(1.0f, 0.1882353f, 0.1882353f));
        return colorScheme;
    }

    public static ColorScheme getBigMirrorEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.7843137f, 0.07843138f, 0.07843138f));
        colorScheme.setNoteRightColor(new Color(0.1568627f, 0.5568627f, 0.8235294f));
        colorScheme.setEnvironmentLeftColor(new Color(0.85f, 0.08499997f, 0.08499997f));
        colorScheme.setEnvironmentRightColor(new Color(0.1882353f, 0.675294f, 1.0f));
        colorScheme.setObstacleColor(new Color(1.0f, 0.1882353f, 0.1882353f));
        return colorScheme;
    }

    public static ColorScheme getDragonsEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.7843137f, 0.07843138f, 0.07843138f));
        colorScheme.setNoteRightColor(new Color(0.1568627f, 0.5568627f, 0.8235294f));
        colorScheme.setEnvironmentLeftColor(new Color(0.85f, 0.08499997f, 0.08499997f));
        colorScheme.setEnvironmentRightColor(new Color(0.1882353f, 0.675294f, 1.0f));
        colorScheme.setObstacleColor(new Color(1.0f, 0.1882353f, 0.1882353f));
        return colorScheme;
    }

    public static ColorScheme getMonstercatEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.7843137f, 0.07843138f, 0.07843138f));
        colorScheme.setNoteRightColor(new Color(0.1568627f, 0.5568627f, 0.8235294f));
        colorScheme.setEnvironmentLeftColor(new Color(0.85f, 0.08499997f, 0.08499997f));
        colorScheme.setEnvironmentRightColor(new Color(0.1882353f, 0.675294f, 1.0f));
        colorScheme.setObstacleColor(new Color(1.0f, 0.1882353f, 0.1882353f));
        return colorScheme;
    }

    public static ColorScheme getPanicEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.7843137f, 0.07843138f, 0.07843138f));
        colorScheme.setNoteRightColor(new Color(0.1568627f, 0.5568627f, 0.8235294f));
        colorScheme.setEnvironmentLeftColor(new Color(0.85f, 0.08499997f, 0.08499997f));
        colorScheme.setEnvironmentRightColor(new Color(0.1882353f, 0.675294f, 1.0f));
        colorScheme.setObstacleColor(new Color(1.0f, 0.1882353f, 0.1882353f));
        return colorScheme;
    }

    public static ColorScheme getOriginsEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.6792453f, 0.5712628f, 0.0f));
        colorScheme.setNoteRightColor(new Color(0.7075472f, 0.0f, 0.5364411f));
        colorScheme.setEnvironmentLeftColor(new Color(0.4910995f, 0.6862745f, 0.7f));
        colorScheme.setEnvironmentRightColor(new Color(0.03844783f, 0.6862745f, 0.9056604f));
        colorScheme.setObstacleColor(new Color(0.06167676f, 0.2869513f, 0.3962264f));
        return colorScheme;
    }

    public static ColorScheme getKDAEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.6588235f, 0.2627451f, 0.1607843f));
        colorScheme.setNoteRightColor(new Color(0.5019608f, 0.08235294f, 0.572549f));
        colorScheme.setEnvironmentLeftColor(new Color(1.0f, 0.3960785f, 0.2431373f));
        colorScheme.setEnvironmentRightColor(new Color(0.7607844f, 0.1254902f, 0.8666667f));
        colorScheme.setObstacleColor(new Color(1.0f, 0.3960785f, 0.2431373f));
        return colorScheme;
    }

    public static ColorScheme getCrabRaveEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.0f, 0.7130001f, 0.07806564f));
        colorScheme.setNoteRightColor(new Color(0.04805952f, 0.5068096f, 0.734f));
        colorScheme.setEnvironmentLeftColor(new Color(0.134568f, 0.756f, 0.1557533f));
        colorScheme.setEnvironmentRightColor(new Color(0.05647058f, 0.6211764f, 0.9f));
        colorScheme.setObstacleColor(new Color(0.0f, 0.8117648f, 0.09019608f));
        return colorScheme;
    }

    public static ColorScheme getRocketEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(1.0f, 0.4980392f, 0.0f));
        colorScheme.setNoteRightColor(new Color(0.0f, 0.5294118f, 1.0f));
        colorScheme.setEnvironmentLeftColor(new Color(0.9f, 0.4866279f, 0.3244186f));
        colorScheme.setEnvironmentRightColor(new Color(0.4f, 0.7180724f, 1.0f));
        colorScheme.setObstacleColor(new Color(0.3176471f, 0.6117647f, 0.7254902f));
        return colorScheme;
    }

    public static ColorScheme getGreenDayEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.2588235f, 0.7843138f, 0.01960784f));
        colorScheme.setNoteRightColor(new Color(0.0f, 0.7137255f, 0.6705883f));
        colorScheme.setEnvironmentLeftColor(new Color(0.0f, 0.7137255f, 0.6705883f));
        colorScheme.setEnvironmentRightColor(new Color(0.2588235f, 0.7843137f, 0.01960784f));
        colorScheme.setObstacleColor(new Color(0.0f, 0.8117648f, 0.09019608f));
        return colorScheme;
    }

    public static ColorScheme getTimbalandEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.5019608f, 0.5019608f, 0.5019608f));
        colorScheme.setNoteRightColor(new Color(0.1f, 0.5517647f, 1.0f));
        colorScheme.setEnvironmentLeftColor(new Color(0.1f, 0.5517647f, 1.0f));
        colorScheme.setEnvironmentRightColor(new Color(0.1f, 0.5517647f, 1.0f));
        colorScheme.setObstacleColor(new Color(0.5f, 0.5f, 0.5f));
        return colorScheme;
    }

    public static ColorScheme getFitBeatEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.8000001f, 0.6078432f, 0.1568628f));
        colorScheme.setNoteRightColor(new Color(0.7921569f, 0.1607843f, 0.682353f));
        colorScheme.setEnvironmentLeftColor(new Color(0.8f, 0.5594772f, 0.5594772f));
        colorScheme.setEnvironmentRightColor(new Color(0.5594772f, 0.5594772f, 0.8f));
        colorScheme.setObstacleColor(new Color(0.2784314f, 0.2784314f, 0.4f));
        return colorScheme;
    }

    public static ColorScheme getLinkinParkEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.6627451f, 0.1643608f, 0.1690187f));
        colorScheme.setNoteRightColor(new Color(0.3870196f, 0.5168997f, 0.5568628f));
        colorScheme.setEnvironmentLeftColor(new Color(0.7529412f, 0.672753f, 0.5925647f));
        colorScheme.setEnvironmentRightColor(new Color(0.6241197f, 0.6890281f, 0.709f));
        colorScheme.setObstacleColor(new Color(0.6627451f, 0.1647059f, 0.172549f));
        colorScheme.setEnvironmentLeftColorBoost(new Color(0.922f, 0.5957885f, 0.255394f));
        colorScheme.setEnvironmentRightColorBoost(new Color(0.282353f, 0.4586275f, 0.6235294f));
        return colorScheme;
    }

    public static ColorScheme getBTSEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(1.0f, 0.09019607f, 0.4059771f));
        colorScheme.setNoteRightColor(new Color(0.8018868f, 0.0f, 0.7517689f));
        colorScheme.setEnvironmentLeftColor(new Color(0.7843137f, 0.1254902f, 0.5010797f));
        colorScheme.setEnvironmentRightColor(new Color(0.6941177f, 0.1254902f, 0.8666667f));
        colorScheme.setObstacleColor(new Color(0.6698113f, 0.1800908f, 0.5528399f));
        colorScheme.setEnvironmentLeftColorBoost(new Color(0.9019608f, 0.5411765f, 1.0f));
        colorScheme.setEnvironmentRightColorBoost(new Color(0.3490196f, 0.8078431f, 1.0f));
        return colorScheme;
    }

    public static ColorScheme getKaleidoscopeEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.65882355f, 0.1254902f, 0.1254902f));
        colorScheme.setNoteRightColor(new Color(0.28235295f, 0.28235295f, 0.28235295f));
        colorScheme.setEnvironmentLeftColor(new Color(0.65882355f, 0.1254902f, 0.1254902f));
        colorScheme.setEnvironmentRightColor(new Color(0.47058824f, 0.47058824f, 0.47058824f));
        colorScheme.setObstacleColor(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        colorScheme.setEnvironmentLeftColorBoost(new Color(0.5019608f, 0.0f, 0.0f));
        colorScheme.setEnvironmentRightColorBoost(new Color(0.49244517f, 0.0f, 0.5372549f));
        return colorScheme;
    }

    public static ColorScheme getInterscopeEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.726415f, 0.62691f, 0.31181f));
        colorScheme.setNoteRightColor(new Color(0.589571f, 0.297888f, 0.723f));
        colorScheme.setEnvironmentLeftColor(new Color(0.724254f, 0.319804f, 0.913725f));
        colorScheme.setEnvironmentRightColor(new Color(0.764706f, 0.758971f, 0.913725f));
        colorScheme.setObstacleColor(new Color(0.588235f, 0.298039f, 0.721569f));
        colorScheme.setEnvironmentLeftColorBoost(new Color(0.792453f, 0.429686f, 0.429868f));
        colorScheme.setEnvironmentRightColorBoost(new Color(0.7038f, 0.715745f, 0.765f));
        return colorScheme;
    }

    public static ColorScheme getSkrillexEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.69803923f, 0.14117648f, 0.36862746f));
        colorScheme.setNoteRightColor(new Color(0.32933334f, 0.32299998f, 0.38f));
        colorScheme.setEnvironmentLeftColor(new Color(0.8f, 0.28000003f, 0.5859449f));
        colorScheme.setEnvironmentRightColor(new Color(0.06525807f, 0.578f, 0.5686774f));
        colorScheme.setObstacleColor(new Color(0.15686275f, 0.6039216f, 0.6039216f));
        colorScheme.setEnvironmentLeftColorBoost(new Color(0.8117648f, 0.30588236f, 0.30588236f));
        colorScheme.setEnvironmentRightColorBoost(new Color(0.2784314f, 0.8f, 0.44597632f));
        return colorScheme;
    }

    public static ColorScheme getBillieEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.8f, 0.6448193f, 0.432f));
        colorScheme.setNoteRightColor(new Color(0.5480851f, 0.6127659f, 0.64f));
        colorScheme.setEnvironmentLeftColor(new Color(0.81960785f, 0.442f, 0.184f));
        colorScheme.setEnvironmentRightColor(new Color(0.9411765f, 0.70677096f, 0.5647059f));
        colorScheme.setObstacleColor(new Color(0.71325314f, 0.5614098f, 0.7830189f));
        colorScheme.setEnvironmentLeftColorBoost(new Color(0.8f, 0.0f, 0.0f));
        colorScheme.setEnvironmentRightColorBoost(new Color(0.5568628f, 0.7019608f, 0.77647066f));
        return colorScheme;
    }

    public static ColorScheme getHalloweenEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.81960785f, 0.49807876f, 0.27702752f));
        colorScheme.setNoteRightColor(new Color(0.37894738f, 0.35789475f, 0.4f));
        colorScheme.setEnvironmentLeftColor(new Color(0.9019608f, 0.23009226f, 0.0f));
        colorScheme.setEnvironmentRightColor(new Color(0.46005884f, 0.56889427f, 0.92941177f));
        colorScheme.setObstacleColor(new Color(0.8196079f, 0.4431373f, 0.18431373f));
        colorScheme.setEnvironmentLeftColorBoost(new Color(0.33768433f, 0.6320754f, 0.33690813f));
        colorScheme.setEnvironmentRightColorBoost(new Color(0.60209066f, 0.3280082f, 0.8584906f));
        return colorScheme;
    }

    public static ColorScheme getGagaEnvironment() {
        ColorScheme colorScheme = new ColorScheme();
        colorScheme.setNoteLeftColor(new Color(0.85f, 0.4333333f, 0.7833334f));
        colorScheme.setNoteRightColor(new Color(0.4705882f, 0.8f, 0.4078431f));
        colorScheme.setEnvironmentLeftColor(new Color(0.706f, 0.649f, 0.2394706f));
        colorScheme.setEnvironmentRightColor(new Color(0.894f, 0.1625455f, 0.7485644f));
        colorScheme.setObstacleColor(new Color(0.9921569f, 0.0f, 0.7719755f));
        colorScheme.setEnvironmentLeftColorBoost(new Color(0.754717f, 0.3610244f, 0.2207192f));
        colorScheme.setEnvironmentRightColorBoost(new Color(0.0f, 0.7058824f, 1.0f));
        return colorScheme;
    }

    public static ColorScheme getWeaveEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-3664876, -14119214, -2550250, -13587201, -53200, -3008807, -6184543);
        return cs;
    }

    public static ColorScheme getPyroEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-7143414, -21760, -58316, -1917885, -2509971, -65491, -3947581);
        return cs;
    }

    public static ColorScheme getEdmEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-6184543, -13782304, -15354112, -16752969, -13782304, -4456403, -9633600);
        return cs;
    }

    public static ColorScheme getTheSecondEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-3664876, -14119214, -2550250, -13587201, -53200, -3008807, -16711771);
        return cs;
    }

    public static ColorScheme getLizzoEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-12448, -5553691, -2710217, -3064352, -32720, -39283, -10564609);
        return cs;
    }

    public static ColorScheme getTheWeekndEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-7003871, -13022636, -46044, -13934412, -1422334, -746977, -7941123);
        cs.setEnvironmentWhiteColor(new Color(-2039584));
        cs.setEnvironmentWhiteColorBoost(new Color(-332324));
        return cs;
    }

    public static ColorScheme getRockMixtapeEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-6722549, -6701369, -4251863, -879575, -1, -711958, -10432538);
        return cs;
    }

    public static ColorScheme getDragons2Environment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-4609976, -12532889, -16384495, -16773377, -7520257, -456699, -11462);
        return cs;
    }

    public static ColorScheme getPanic2Environment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-1682031, -14184836, -5104289, -13590881, -564922, -1674735, -6131493);
        cs.setEnvironmentWhiteColor(new Color(-2824468));
        cs.setEnvironmentWhiteColorBoost(new Color(-2042644));
        return cs;
    }

    public static ColorScheme getQueenEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-7040626, -7986515, -1137889, -16009243, -1137889, -3922669, -10091847);
        return cs;
    }

    public static ColorScheme getLinkinPark2Environment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-5690837, -10255218, -5690836, -6311755, -5690836, -1337279, -12028513);
        cs.setEnvironmentWhiteColor(new Color(-4150121));
        return cs;
    }

    public static ColorScheme getTheRollingStonesEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-1769443, -7986515, -851097, -8755201, -851097, -7309824, -16669781);
        return cs;
    }

    public static ColorScheme getLatticeEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-2741109, -16733190, -1824321, -13462069, -8931841, -7658800, -9966870);
        return cs;
    }

    public static ColorScheme getDaftPunkEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-4703698, -14699856, -19648, -8039215, -6618881, -2424710, -16723507);
        cs.setEnvironmentWhiteColor(new Color(-8728577));
        cs.setEnvironmentWhiteColorBoost(new Color(-10884));
        return cs;
    }

    public static ColorScheme getHipHopEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-27312, -16474986, -1475072, -15741649, -44915, -14352393, -12957953);
        cs.setEnvironmentWhiteColor(new Color(-3358284));
        cs.setEnvironmentWhiteColorBoost(new Color(-2039584));
        return cs;
    }

    public static ColorScheme getColliderEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-623066, -13919781, -628736, -13933349, -2746112, -1767162, -2463240);
        return cs;
    }

    public static ColorScheme getBritneyEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-1497959, -12610305, -195588, -13532697, -2746112, -35454, -8655413);
        return cs;
    }

    public static ColorScheme getMonstercat2Environment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-2140027, -10269284, -6418989, -11094500, -12900701, -4842468, -15299419);
        return cs;
    }

    public static ColorScheme getMetallicaEnvironment() {
        ColorScheme cs = new ColorScheme();
        cs.setColors(-12036761, -7096366, -2261407, -12487459, -2746112, -2399207, -16728159);
        cs.setEnvironmentWhiteColor(new Color(-8152147));
        cs.setEnvironmentWhiteColorBoost(new Color(-8152147));
        return cs;
    }

    public Color getNoteLeftColor() {
        return this.noteLeftColor;
    }

    public void setNoteLeftColor(Color noteLeftColor) {
        this.noteLeftColor = noteLeftColor;
    }

    public Color getNoteRightColor() {
        return this.noteRightColor;
    }

    public void setNoteRightColor(Color noteRightColor) {
        this.noteRightColor = noteRightColor;
    }

    public Color getObstacleColor() {
        return this.obstacleColor;
    }

    public void setObstacleColor(Color obstacleColor) {
        this.obstacleColor = obstacleColor;
    }

    public Color getEnvironmentLeftColor() {
        return this.environmentLeftColor;
    }

    public void setEnvironmentLeftColor(Color environmentLeftColor) {
        this.environmentLeftColor = environmentLeftColor;
    }

    public Color getEnvironmentLeftColorBoost() {
        return this.environmentLeftColorBoost;
    }

    public void setEnvironmentLeftColorBoost(Color environmentLeftColorBoost) {
        this.environmentLeftColorBoost = environmentLeftColorBoost;
    }

    public Color getEnvironmentRightColor() {
        return this.environmentRightColor;
    }

    public void setEnvironmentRightColor(Color environmentRightColor) {
        this.environmentRightColor = environmentRightColor;
    }

    public Color getEnvironmentRightColorBoost() {
        return this.environmentRightColorBoost;
    }

    public void setEnvironmentRightColorBoost(Color environmentRightColorBoost) {
        this.environmentRightColorBoost = environmentRightColorBoost;
    }

    public Color getEnvironmentWhiteColor() {
        return this.environmentWhiteColor;
    }

    public void setEnvironmentWhiteColor(Color environmentWhiteColor) {
        this.environmentWhiteColor = environmentWhiteColor;
    }

    public Color getEnvironmentWhiteColorBoost() {
        return this.environmentWhiteColorBoost;
    }

    public void setEnvironmentWhiteColorBoost(Color environmentWhiteColorBoost) {
        this.environmentWhiteColorBoost = environmentWhiteColorBoost;
    }

    public void setColors(int leftNote, int rightNote, int leftEnv, int rightEnv, int obstacleColor, int leftBoost, int rightBoost) {
        this.setNoteLeftColor(new Color(leftNote));
        this.setNoteRightColor(new Color(rightNote));
        this.setEnvironmentLeftColor(new Color(leftEnv));
        this.setEnvironmentRightColor(new Color(rightEnv));
        this.setObstacleColor(new Color(obstacleColor));
        this.setEnvironmentLeftColorBoost(new Color(leftBoost));
        this.setEnvironmentRightColorBoost(new Color(rightBoost));
    }
}

