/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.data.event;

import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.object.data.BeatmapObject;
import com.beatcraft.common.event.IEvent;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class RotationEvent
extends BeatmapObject
implements IEvent {
    private float rotation;
    private final boolean early;

    public RotationEvent(boolean early) {
        this.early = early;
    }

    public float getRotation() {
        return this.rotation;
    }

    public boolean isEarly() {
        return this.early;
    }

    @Override
    public float getEventBeat() {
        return this.getBeat();
    }

    @Override
    public float getEventDuration() {
        return 0.0f;
    }

    private static float getRotationAsFloat(JsonElement element) {
        if (element.getAsInt() >= 8 || element.getAsInt() < 0) {
            return 0.0f;
        }
        V2ROTATION rotation = V2ROTATION.values()[element.getAsInt()];
        return switch (rotation.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> -60.0f;
            case 1 -> -45.0f;
            case 2 -> -30.0f;
            case 3 -> -15.0f;
            case 4 -> 15.0f;
            case 5 -> 30.0f;
            case 6 -> 45.0f;
            case 7 -> 60.0f;
        };
    }

    @Override
    public RotationEvent loadV2(JsonObject json, Difficulty difficulty) {
        JsonObject customData;
        super.loadV2(json, difficulty);
        this.rotation = RotationEvent.getRotationAsFloat(json.get("_value"));
        if (json.has("_customData") && (customData = json.getAsJsonObject("_customData")).has("_rotation")) {
            this.rotation = customData.get("_rotation").getAsFloat();
        }
        return this;
    }

    @Override
    public RotationEvent loadV3(JsonObject json, Difficulty difficulty) {
        super.loadV3(json, difficulty);
        this.rotation = json.get("r").getAsFloat();
        return this;
    }

    public RotationEvent fromBasicEventV3(JsonObject json, Difficulty difficulty) {
        JsonObject customData;
        super.loadV3(json, difficulty);
        this.rotation = RotationEvent.getRotationAsFloat(json.get("i"));
        if (json.has("customData") && (customData = json.getAsJsonObject("customData")).has("rotation")) {
            this.rotation = customData.get("rotation").getAsFloat();
        }
        return this;
    }

    private static enum V2ROTATION {
        CCW_60,
        CCW_45,
        CCW_30,
        CCW_15,
        CW_15,
        CW_30,
        CW_45,
        CW_60;

    }
}

