/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.object.physical;

import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.animation.AnimationState;
import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.NoteType;
import com.beatcraft.client.beatmap.object.data.BeatmapObject;
import com.beatcraft.client.beatmap.object.data.GameplayObject;
import com.beatcraft.client.beatmap.object.data.ScoreState;
import com.beatcraft.client.beatmap.object.data.SpawnQuaternionPool;
import com.beatcraft.client.beatmap.object.physical.PhysicalColorNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalScorableObject;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.WorldRenderer;
import com.beatcraft.client.render.instancing.ColorNoteInstanceData;
import com.beatcraft.client.render.instancing.InstancedMesh;
import com.beatcraft.client.render.particle.BeatcraftParticleRenderer;
import com.beatcraft.client.render.particle.Debris;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.utils.MathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public abstract class PhysicalGameplayObject<T extends GameplayObject>
extends WorldRenderer {
    public final BeatmapController mapController;
    private static final float JUMP_FAR_Z = 500.0f;
    private static final float JUMP_SECONDS = 0.4f;
    protected static final float SIZE_SCALAR = 0.5f;
    protected static final Vector3f WORLD_OFFSET = new Vector3f(0.0f, 0.8f, 1.0f);
    protected final Quaternionf spawnQuaternion = SpawnQuaternionPool.getRandomQuaternion();
    protected Quaternionf baseRotation = new Quaternionf();
    private Quaternionf laneRotation = new Quaternionf();
    private Quaternionf lookRotation = new Quaternionf();
    private Matrix4f worldTransform = new Matrix4f();
    private Matrix4f matrix = new Matrix4f();
    private AnimationState animationState = new AnimationState();
    protected T data;
    protected boolean despawned = false;
    protected ScoreState scoreState = ScoreState.unChecked();
    private NoteType contactColor = null;
    public Vector3f worldVelocity = new Vector3f();
    private Matrix4f previousTransform = new Matrix4f();
    private static final Vector3f DEFAULT_MODEL_OFFSET = new Vector3f(-0.5f);

    public PhysicalGameplayObject(BeatmapController beatmap, T data) {
        this.mapController = beatmap;
        this.data = data;
    }

    private Vector3f getPlayerHeadPosition() {
        return new Vector3f(0.0f, 1.62f, 0.0f);
    }

    public float getSpawnBeat() {
        return ((BeatmapObject)this.getData()).getBeat() - ((GameplayObject)this.data).getJumps().halfDuration();
    }

    public float getJumpInBeat() {
        return ((BeatmapObject)this.getData()).getBeat() - ((GameplayObject)this.data).getJumps().halfDuration() * 0.5f;
    }

    public float getDisappearBeat() {
        return ((BeatmapObject)this.getData()).getBeat() - ((GameplayObject)this.data).getJumps().halfDuration() * 0.4f;
    }

    public float getJumpOutBeat() {
        return ((BeatmapObject)this.getData()).getBeat() + ((GameplayObject)this.data).getJumps().halfDuration() * 0.5f;
    }

    public float getDespawnBeat() {
        return ((BeatmapObject)this.getData()).getBeat() + ((GameplayObject)this.data).getJumps().halfDuration();
    }

    public float getSpawnPosition() {
        return ((GameplayObject)this.data).getJumps().jumpDistance() / 2.0f;
    }

    public float getJumpOutPosition() {
        return ((GameplayObject)this.data).getJumps().jumpDistance() * -0.25f;
    }

    private void despawn() {
        this.despawned = true;
    }

    public boolean isDespawned() {
        return this.despawned;
    }

    public void seek(float beat) {
        this.despawned = false;
        PhysicalGameplayObject physicalGameplayObject = this;
        if (physicalGameplayObject instanceof PhysicalScorableObject) {
            PhysicalScorableObject scorable = (PhysicalScorableObject)((Object)physicalGameplayObject);
            this.scoreState = ScoreState.unChecked();
        }
        this.update(beat);
    }

    public void update(float beat) {
        PhysicalScorableObject scorable;
        PhysicalGameplayObject physicalGameplayObject;
        if (!this.isInWorld()) {
            return;
        }
        AnimationState animatedPropertyState = ((GameplayObject)this.data).getTrackContainer().getAnimatedPropertyState();
        if (this.jumpEnded(beat = this.applyTimeRemapping(beat, animatedPropertyState))) {
            this.despawn();
            return;
        }
        if (this.pastBeat(beat) && (physicalGameplayObject = this) instanceof PhysicalScorableObject && (scorable = (PhysicalScorableObject)((Object)physicalGameplayObject)).score$getScoreState().isUnchecked()) {
            scorable.score$setScoreState(ScoreState.missed());
            this.mapController.logic.processNoCut(scorable.score$getMaxFollowThroughScore() + scorable.score$getMaxSwingInScore() + 15);
        }
        float lifetime = this.getLifetime(beat);
        this.animationState = animatedPropertyState;
        this.animationState = AnimationState.combine(this.animationState, this.getObjectPathAnimationState(lifetime));
        this.animationState = AnimationState.combine(this.animationState, this.getTrackPathAnimationState(lifetime));
        this.matrix = this.getMatrix(beat, this.animationState);
    }

    public boolean hasAppeared() {
        float margin = MathUtil.secondsToBeats(0.4f, this.mapController.getBpm(((BeatmapObject)this.data).getBeat()));
        return this.mapController.currentBeat >= this.getSpawnBeat() - margin;
    }

    public boolean isInWorld() {
        return this.hasAppeared() && !this.isDespawned();
    }

    protected boolean isBaseDissolved() {
        Float dissolve = (Float)this.animationState.getDissolve();
        if (dissolve == null) {
            return false;
        }
        return dissolve.floatValue() == 0.0f;
    }

    public float getBaseDissolve() {
        Float dissolve = (Float)this.animationState.getDissolve();
        if (dissolve == null) {
            return 0.0f;
        }
        return 1.0f - dissolve.floatValue();
    }

    protected boolean isArrowDissolved() {
        Float dissolveArrow = (Float)this.animationState.getDissolveArrow();
        if (dissolveArrow == null) {
            return false;
        }
        return dissolveArrow.floatValue() == 0.0f;
    }

    public float getArrowDissolve() {
        Float dissolve = (Float)this.animationState.getDissolveArrow();
        if (dissolve == null) {
            return 0.0f;
        }
        return 1.0f - dissolve.floatValue();
    }

    @Override
    public boolean shouldRender() {
        return this.isInWorld();
    }

    protected Vector3f getJumpsPosition(float lifetime, float time) {
        Vector2f xy = this.getJumpsXY(lifetime);
        return new Vector3f(xy.x, xy.y, this.getJumpsZ(time));
    }

    protected Vector2f getJumpsXY(float lifetime) {
        float reverseSpawnTime = 1.0f - Math.abs((float)(lifetime - 0.5f)) * 2.0f;
        float jumpTime = Easing.easeOutQuad(reverseSpawnTime);
        Vector2f grid = this.get2DPosition();
        grid.y = Math.lerp((float)(this.doNoteGravity() ? -0.3f : grid.y - 0.3f), (float)grid.y, (float)jumpTime);
        return grid;
    }

    protected float getJumpsZ(float time) {
        float spawnPosition = this.getSpawnPosition();
        float jumpOutPosition = this.getJumpOutPosition();
        float spawnBeat = this.getSpawnBeat();
        float jumpOutBeat = this.getJumpOutBeat();
        if (time <= spawnBeat) {
            float percent = (spawnBeat - time) / 2.0f;
            return Math.lerp((float)spawnPosition, (float)500.0f, (float)percent);
        }
        if (time < jumpOutBeat) {
            float percent = MathUtil.inverseLerp(spawnBeat, jumpOutBeat, time);
            return Math.lerp((float)spawnPosition, (float)jumpOutPosition, (float)percent);
        }
        float percent = MathUtil.inverseLerp(jumpOutBeat, this.getDespawnBeat(), time);
        percent *= percent;
        return Math.lerp((float)jumpOutPosition, (float)-500.0f, (float)percent);
    }

    protected Vector2f get2DPosition() {
        float x = (((GameplayObject)this.getData()).getX() - 1.5f) * 0.6f;
        float y = ((GameplayObject)this.getData()).getY() * 0.6f;
        return new Vector2f(x, y);
    }

    protected float getLifetime(float beat) {
        float lifetime = MathUtil.inverseLerp(this.getSpawnBeat(), this.getDespawnBeat(), beat);
        return MathUtil.clamp01(lifetime);
    }

    protected float getSpawnLifetime(float lifetime) {
        return MathUtil.clamp01(lifetime * 2.0f);
    }

    protected Matrix4f getMatrix(float time, AnimationState animationState) {
        Matrix4f m = new Matrix4f();
        Matrix4f parentMatrix = ((GameplayObject)this.data).getTrackContainer().tryGetParentMatrix();
        if (parentMatrix != null) {
            m.mul((Matrix4fc)parentMatrix);
        }
        m.translate(this.getPlayerHeadPosition().x, 0.0f, this.getPlayerHeadPosition().z);
        if (((GameplayObject)this.data).getWorldRotation() != null) {
            m.rotate((Quaternionfc)((GameplayObject)this.data).getWorldRotation());
        }
        if (animationState.getOffsetWorldRotation() != null) {
            m.rotate((Quaternionfc)animationState.getOffsetWorldRotation());
        }
        if (animationState.getOffsetPosition() != null) {
            m.translate((Vector3fc)animationState.getOffsetPosition());
        }
        if (this.getLaneRotation() != null) {
            m.rotate((Quaternionfc)this.getLaneRotation());
        }
        this.applySpawnMatrix(time, m, animationState);
        MathUtil.reflectMatrixAcrossX(m);
        return m;
    }

    protected boolean doNoteLook() {
        return false;
    }

    protected boolean doNoteGravity() {
        return true;
    }

    protected void applySpawnMatrix(float time, Matrix4f m, AnimationState animationState) {
        float lifetime = this.getLifetime(time);
        float spawnLifetime = this.getSpawnLifetime(lifetime);
        Matrix4f jumpMatrix = new Matrix4f();
        Vector3f v = this.getJumpsPosition(lifetime, time);
        if (animationState.getDefinitePosition() != null) {
            v.mul(1.0f, 1.0f, 0.0f);
            Vector3f v2 = (Vector3f)animationState.getDefinitePosition();
            v.add((Vector3fc)v2);
        }
        jumpMatrix.translate((Vector3fc)v);
        m.translate((Vector3fc)WORLD_OFFSET);
        if (this.doNoteLook()) {
            if ((double)lifetime < 0.5) {
                Vector3f headPosition = this.getPlayerHeadPosition();
                headPosition = MathUtil.matrixTransformPoint3D(new Matrix4f((Matrix4fc)m).invert(), headPosition);
                headPosition = MathUtil.matrixTransformPoint3D(jumpMatrix, headPosition.mul(-1.0f));
                Vector3f up = new Vector3f(0.0f, 0.0f, 1.0f);
                Quaternionf targetLookRotation = new Quaternionf().rotateTo((Vector3fc)up, (Vector3fc)headPosition);
                this.lookRotation = new Quaternionf().slerp((Quaternionfc)targetLookRotation, spawnLifetime);
            }
            m.mul((Matrix4fc)jumpMatrix).rotate((Quaternionfc)this.lookRotation);
        } else {
            m.mul((Matrix4fc)jumpMatrix);
        }
        Vector3f animatedScale = (Vector3f)animationState.getScale();
        if (animatedScale != null) {
            m.scale((Vector3fc)animatedScale);
        }
        if (((GameplayObject)this.data).getLocalRotation() != null) {
            m.rotate((Quaternionfc)((GameplayObject)this.data).getLocalRotation());
        }
        if (animationState.getLocalRotation() != null) {
            m.rotate((Quaternionfc)animationState.getLocalRotation());
        }
        if ((double)lifetime < 0.5) {
            m.rotate((Quaternionfc)this.getJumpsRotation(spawnLifetime));
        } else {
            m.rotate((Quaternionfc)this.baseRotation);
        }
    }

    protected Quaternionf getJumpsRotation(float spawnLifetime) {
        float rotationLifetime = MathUtil.clamp01(spawnLifetime / 0.3f);
        if (spawnLifetime == 0.0f) {
            return this.baseRotation;
        }
        float rotationTime = Easing.easeOutQuad(rotationLifetime);
        return new Quaternionf().set((Quaternionfc)this.spawnQuaternion).slerp((Quaternionfc)this.baseRotation, rotationTime);
    }

    protected boolean jumpEnded(float beat) {
        return beat >= this.getDespawnBeat();
    }

    protected boolean pastBeat(float beat) {
        return beat > ((BeatmapObject)this.getData()).getBeat() + 0.25f;
    }

    private void applyMatrixToRender(Matrix4f matrix, PoseStack matrices) {
        Matrix3f normalMatrix = new Matrix3f();
        matrix.get3x3(normalMatrix);
        matrices.mulPose(matrix);
        matrices.last().normal().mul((Matrix3fc)normalMatrix);
    }

    private float applyTimeRemapping(float beat, AnimationState animatedPropertyState) {
        float spawnBeat = this.getSpawnBeat();
        float despawnBeat = this.getDespawnBeat();
        Float animationTime = (Float)animatedPropertyState.getTime();
        if (beat >= spawnBeat && animationTime != null) {
            return Math.lerp((float)spawnBeat, (float)despawnBeat, (float)animationTime.floatValue());
        }
        return beat;
    }

    private AnimationState getObjectPathAnimationState(float lifetime) {
        return ((GameplayObject)this.data).getPathAnimation().toState(lifetime);
    }

    private AnimationState getTrackPathAnimationState(float lifetime) {
        return ((GameplayObject)this.data).getTrackContainer().getAnimatedPathState(lifetime);
    }

    protected Vector3f getModelOffset() {
        return DEFAULT_MODEL_OFFSET;
    }

    @Override
    protected void worldRender(PoseStack matrices, Camera camera, float alpha) {
        matrices.pushPose();
        this.applyMatrixToRender(this.matrix, matrices);
        this.previousTransform.set((Matrix4fc)this.worldTransform);
        this.worldTransform.set((Matrix4fc)matrices.last().pose());
        this.mapController.checkNote(this);
        matrices.scale(0.5f, 0.5f, 0.5f);
        Vector3f v = this.getModelOffset();
        matrices.translate(v.x, v.y, v.z);
        this.worldTransform = matrices.last().pose();
        this.objectRender(matrices, camera, this.animationState, alpha);
        matrices.popPose();
    }

    protected abstract void objectRender(PoseStack var1, Camera var2, AnimationState var3, float var4);

    public T getData() {
        return this.data;
    }

    public Quaternionf getLaneRotation() {
        return this.laneRotation;
    }

    public void setLaneRotation(Quaternionf laneRotation) {
        this.laneRotation = laneRotation;
    }

    public float getCollisionDistance() {
        return 0.0f;
    }

    public Matrix4f getWorldTransform() {
        return this.worldTransform;
    }

    public Vector3f getWorldPos(Vector3f dest) {
        return this.worldTransform.transformPosition(dest.zero());
    }

    public Hitbox getGoodCutBounds() {
        return new Hitbox(new Vector3f(), new Vector3f());
    }

    public Hitbox getBadCutBounds() {
        return new Hitbox(new Vector3f(), new Vector3f());
    }

    public Hitbox getAccurateHitbox() {
        return new Hitbox(new Vector3f(), new Vector3f());
    }

    public void cutNote() {
        this.despawn();
    }

    public ScoreState getScoreState() {
        return this.scoreState;
    }

    public void setScoreState(ScoreState state) {
        this.scoreState = state;
    }

    @Nullable
    public NoteType getContactColor() {
        return this.contactColor;
    }

    public void setContactColor(NoteType color) {
        this.contactColor = color;
    }

    public InstancedMesh<ColorNoteInstanceData> getMesh() {
        return null;
    }

    public void spawnDebris(Vector3f planeIncident, Vector3f planeNormal) {
        if (BeatcraftClient.playerConfig.preferences.reducedDebris()) {
            return;
        }
        InstancedMesh<ColorNoteInstanceData> m = this.getMesh();
        if (m == null) {
            return;
        }
        Vector3f notePos = this.getWorldPos(new Vector3f()).add(-0.25f, -0.25f, -0.25f);
        Quaternionf noteOrientation = this.getWorldTransform().getUnnormalizedRotation(new Quaternionf());
        if (!(this instanceof PhysicalColorNote)) {
            return;
        }
        Color color = ((PhysicalColorNote)this).getData().getColor();
        float d = planeNormal.normalize(new Vector3f()).dot((Vector3fc)planeIncident);
        Vector4f slice = new Vector4f((Vector3fc)planeNormal, d);
        Vector4f slice2 = new Vector4f((Vector3fc)planeNormal.negate(), d);
        float velocity = -this.mapController.difficulty.getSetDifficulty().getNjs(this.mapController.currentBeat);
        Debris left = new Debris(this.mapController, new Vector3f((Vector3fc)notePos), new Quaternionf((Quaternionfc)noteOrientation), new Vector3f(0.0f, 0.0f, velocity).add((Vector3fc)planeNormal.mul(2.0f, new Vector3f())).rotateY(this.mapController.worldAngle).rotate((Quaternionfc)this.laneRotation.invert(new Quaternionf())), new Quaternionf().rotateY(-0.02f).rotateX(-0.03f), slice, color, m);
        Debris right = new Debris(this.mapController, new Vector3f((Vector3fc)notePos), new Quaternionf((Quaternionfc)noteOrientation), new Vector3f(0.0f, 0.0f, velocity).add((Vector3fc)planeNormal.mul(-2.0f, new Vector3f())).rotateY(this.mapController.worldAngle).rotate((Quaternionfc)this.laneRotation.invert(new Quaternionf())), new Quaternionf().rotateY(0.02f).rotateX(-0.03f), slice2, color, m);
        BeatcraftParticleRenderer.addParticle(left);
        BeatcraftParticleRenderer.addParticle(right);
    }
}

