/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.commands;

import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.BeatmapManager;
import com.beatcraft.client.beatmap.BeatmapRenderer;
import com.beatcraft.client.commands.CommandCallback;
import com.beatcraft.client.commands.CommandTree;
import com.beatcraft.client.services.CommandManager;
import com.beatcraft.common.data.map.SongData;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.chat.Component;
import org.joml.Vector3f;

public class ClientCommands {
    private static CommandResult listBeatmaps(CommandCallback callback) {
        return CommandResult.ok((Component)Component.literal((String)BeatmapManager.getMapsInfo()));
    }

    private static CommandResult createBeatmap(CommandCallback callback) {
        Vector3f pos = callback.getVec3fArg("position");
        float rot = callback.getFloatArg("rotation");
        BeatmapController map = BeatmapManager.place(callback.getLevel(), pos, rot * ((float)Math.PI / 180), BeatmapRenderer.RenderStyle.DISTANCE);
        return CommandResult.ok((Component)Component.literal((String)String.format("Placed beatmap: %s", map.getDisplayInfo())));
    }

    private static CompletableFuture<Suggestions> beatmapUuidSuggester(CommandCallback callback, SuggestionsBuilder builder) {
        String current = builder.getRemaining();
        for (BeatmapController map : BeatmapManager.beatmaps) {
            String id = map.mapId.toString();
            if (!id.contains(current)) continue;
            builder.suggest(id);
        }
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> playerUuidSuggester(CommandCallback callback, SuggestionsBuilder builder) {
        String current = builder.getRemaining();
        assert (Minecraft.getInstance().level != null);
        for (AbstractClientPlayer player : Minecraft.getInstance().level.players()) {
            UUID uuid = player.getUUID();
            if (!uuid.toString().startsWith(current)) continue;
            builder.suggest(uuid.toString());
        }
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> mapSuggester(CommandCallback callback, SuggestionsBuilder builder) {
        String song_name = builder.getRemaining();
        ArrayList<SongData> matches = new ArrayList<SongData>();
        for (SongData song : BeatmapManager.songs) {
            if (!song.getTitle().contains(song_name)) continue;
            matches.add(song);
        }
        if (matches.isEmpty()) {
            return builder.buildFuture();
        }
        for (SongData m : matches) {
            builder.suggest("\"" + m.getTitle() + "\"");
        }
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> mapSetSuggester(CommandCallback callback, SuggestionsBuilder builder) {
        String song_name = callback.getStringArg("map");
        String set_name = builder.getRemaining();
        ArrayList<SongData> matches = new ArrayList<SongData>();
        for (SongData song : BeatmapManager.songs) {
            if (!song.getTitle().contains(song_name)) continue;
            matches.add(song);
        }
        if (matches.isEmpty()) {
            return builder.buildFuture();
        }
        SongData song = (SongData)matches.getFirst();
        ArrayList<String> setMatches = new ArrayList<String>();
        for (String set : song.getDifficultySets()) {
            if (!set.contains(set_name)) continue;
            setMatches.add(set);
        }
        if (setMatches.isEmpty()) {
            return builder.buildFuture();
        }
        for (String s : setMatches) {
            builder.suggest("\"" + s + "\"");
        }
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> mapDifficultySuggester(CommandCallback callback, SuggestionsBuilder builder) {
        String song_name = callback.getStringArg("map");
        String set_name = callback.getStringArg("set");
        String diff_name = builder.getRemaining();
        ArrayList<SongData> matches = new ArrayList<SongData>();
        for (SongData song : BeatmapManager.songs) {
            if (!song.getTitle().contains(song_name)) continue;
            matches.add(song);
        }
        if (matches.isEmpty()) {
            return builder.buildFuture();
        }
        SongData song = (SongData)matches.getFirst();
        ArrayList<String> setMatches = new ArrayList<String>();
        for (String set : song.getDifficultySets()) {
            if (!set.contains(set_name)) continue;
            setMatches.add(set);
        }
        if (setMatches.isEmpty()) {
            return builder.buildFuture();
        }
        List<String> diffs = song.getDifficulties((String)setMatches.getFirst());
        ArrayList<String> diffMatches = new ArrayList<String>();
        for (String diff : diffs) {
            if (!diff.contains(diff_name)) continue;
            diffMatches.add(diff);
        }
        if (diffMatches.isEmpty()) {
            return builder.buildFuture();
        }
        for (String diff : diffMatches) {
            builder.suggest("\"" + diff + "\"");
        }
        return builder.buildFuture();
    }

    private static CommandResult playSongForMap(CommandCallback callback) {
        UUID uuid = callback.getUuidArg("uuid");
        String map = callback.getStringArg("map");
        String set = callback.getStringArg("set");
        String diff = callback.getStringArg("difficulty");
        callback.sendFeedback((Component)Component.literal((String)String.format("Trying to play map: %s %s %s", map, set, diff)));
        BeatmapController controller = BeatmapManager.getByUuid(uuid);
        if (controller == null) {
            return CommandResult.err((Component)Component.translatable((String)"command.beatcraft.error.map_controller_not_found"));
        }
        Optional<SongData> selectedBeatmap = BeatmapManager.songs.stream().filter(m -> m.getTitle().equals(map)).findFirst();
        if (selectedBeatmap.isEmpty()) {
            return CommandResult.err((Component)Component.translatable((String)"command.beatcraft.error.song_not_found"));
        }
        SongData song = selectedBeatmap.get();
        if (!song.getDifficultySets().contains(set)) {
            return CommandResult.err((Component)Component.translatable((String)"command.beatcraft.error.difficulty_set_not_found"));
        }
        if (!song.getDifficulties(set).contains(diff)) {
            return CommandResult.err((Component)Component.translatable((String)"command.beatcraft.error.difficulty_not_found"));
        }
        SongData.BeatmapInfo mapInfo = song.getBeatMapInfo(set, diff);
        controller.playSong(mapInfo);
        return CommandResult.ok();
    }

    private static CommandResult setMapSpeed(CommandCallback callback) {
        UUID uuid = callback.getUuidArg("uuid");
        BeatmapController controller = BeatmapManager.getByUuid(uuid);
        if (controller == null) {
            return CommandResult.err((Component)Component.translatable((String)"command.beatcraft.error.map_controller_not_found"));
        }
        float speed = callback.getFloatArg("value");
        if (0.0f >= speed || speed > 7.0f) {
            return CommandResult.err((Component)Component.translatable((String)"command.beatcraft.error.invalid_speed", (Object[])new Object[]{0, 7}));
        }
        controller.setSpeed(speed);
        return CommandResult.ok((Component)Component.translatable((String)"command.beatcraft.feedback.set_speed", (Object[])new Object[]{Float.valueOf(speed * 100.0f)}));
    }

    private static CommandResult mapSeek(CommandCallback callback) {
        UUID uuid = callback.getUuidArg("uuid");
        BeatmapController controller = BeatmapManager.getByUuid(uuid);
        if (controller == null) {
            return CommandResult.err((Component)Component.translatable((String)"command.beatcraft.error.map_controller_not_found"));
        }
        float beat = callback.getFloatArg("beat");
        controller.seek(beat);
        return CommandResult.ok();
    }

    private static CommandResult resumeMap(CommandCallback callback) {
        UUID uuid = callback.getUuidArg("uuid");
        BeatmapController controller = BeatmapManager.getByUuid(uuid);
        if (controller == null) {
            return CommandResult.err((Component)Component.translatable((String)"command.beatcraft.error.map_controller_not_found"));
        }
        controller.resume();
        return CommandResult.ok();
    }

    private static CommandResult pauseMap(CommandCallback callback) {
        UUID uuid = callback.getUuidArg("uuid");
        BeatmapController controller = BeatmapManager.getByUuid(uuid);
        if (controller == null) {
            return CommandResult.err((Component)Component.translatable((String)"command.beatcraft.error.map_controller_not_found"));
        }
        controller.pause();
        return CommandResult.ok();
    }

    private static CommandResult trackPlayer(CommandCallback callback) {
        UUID uuid = callback.getUuidArg("uuid");
        UUID playerUuid = callback.getUuidArg("player");
        BeatmapController controller = BeatmapManager.getByUuid(uuid);
        if (controller == null) {
            return CommandResult.err((Component)Component.translatable((String)"command.beatcraft.error.map_controller_not_found"));
        }
        controller.trackPlayer(playerUuid);
        return CommandResult.ok();
    }

    private static CommandResult enableFPFC(CommandCallback callback) {
        BeatcraftClient.FPFC = true;
        return CommandResult.ok();
    }

    private static CommandResult disableFPFC(CommandCallback callback) {
        BeatcraftClient.FPFC = false;
        return CommandResult.ok();
    }

    private static CommandResult toggleFPFC(CommandCallback callback) {
        BeatcraftClient.FPFC = !BeatcraftClient.FPFC;
        return CommandResult.ok();
    }

    public static void init() {
        CommandManager.register(CommandTree.literal("beatmap").then(CommandTree.literal("list").executes(ClientCommands::listBeatmaps)).then(CommandTree.literal("place").then(CommandTree.argument("position", CommandTree.ArgumentType.Vec3i).then(CommandTree.argument("rotation", CommandTree.ArgumentType.Float).executes(ClientCommands::createBeatmap)))).then(CommandTree.argument("uuid", CommandTree.ArgumentType.Uuid).suggests(ClientCommands::beatmapUuidSuggester).then(CommandTree.literal("play").then(CommandTree.argument("map", CommandTree.ArgumentType.String).suggests(ClientCommands::mapSuggester).then(CommandTree.argument("set", CommandTree.ArgumentType.String).suggests(ClientCommands::mapSetSuggester).then(CommandTree.argument("difficulty", CommandTree.ArgumentType.String).suggests(ClientCommands::mapDifficultySuggester).executes(ClientCommands::playSongForMap)))).executes(ClientCommands::resumeMap)).then(CommandTree.literal("speed").then(CommandTree.argument("value", CommandTree.ArgumentType.Float).executes(ClientCommands::setMapSpeed))).then(CommandTree.literal("seek").then(CommandTree.argument("beat", CommandTree.ArgumentType.Float).executes(ClientCommands::mapSeek))).then(CommandTree.literal("pause").executes(ClientCommands::pauseMap)).then(CommandTree.literal("resume").executes(ClientCommands::resumeMap)).then(CommandTree.literal("track").then(CommandTree.argument("player", CommandTree.ArgumentType.Uuid).suggests(ClientCommands::playerUuidSuggester).executes(ClientCommands::trackPlayer)))).build(), CommandTree.literal("fpfc").then(CommandTree.literal("true").executes(ClientCommands::enableFPFC)).then(CommandTree.literal("false").executes(ClientCommands::disableFPFC)).executes(ClientCommands::toggleFPFC));
    }

    public static class CommandResult {
        public final Component msg;
        public final int state;

        private CommandResult(int state, Component msg) {
            this.state = state;
            this.msg = msg;
        }

        public static CommandResult ok() {
            return new CommandResult(1, null);
        }

        public static CommandResult ok(Component msg) {
            return new CommandResult(1, msg);
        }

        public static CommandResult err() {
            return new CommandResult(-1, null);
        }

        public static CommandResult err(Component msg) {
            return new CommandResult(-1, msg);
        }
    }
}

