/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment.kaleidoscope;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.lightshow.lights.LightObject;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.instancing.lightshow.light_object.LightMeshInstance;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.beatcraft.common.data.types.Color;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RingSpike
extends LightObject {
    private final LightState[] states = new LightState[7];
    private LightMeshInstance mesh;
    private static ArrayList<RingSpike> spikes = new ArrayList();

    public RingSpike(BeatmapController map) {
        super(map);
    }

    public LightObject[] getControllers() {
        SubLightController rightTip = new SubLightController(this.mapController, 0);
        SubLightController leftRing = new SubLightController(this.mapController, 1);
        SubLightController rightRing = new SubLightController(this.mapController, 2);
        SubLightController left = new SubLightController(this.mapController, 3);
        SubLightController right = new SubLightController(this.mapController, 4);
        SubLightController leftBack = new SubLightController(this.mapController, 5);
        SubLightController rightBack = new SubLightController(this.mapController, 6);
        return new LightObject[]{rightTip, leftRing, rightRing, left, right, leftBack, rightBack};
    }

    public static void clearInstances() {
        spikes.clear();
    }

    public static void reload() {
        for (RingSpike spike : spikes) {
            spike.mesh = new LightMeshInstance(MeshLoader.KALEIDOSCOPE_SPIKE);
        }
    }

    public RingSpike(BeatmapController map, Vector3f pos, Quaternionf ori) {
        super(map);
        spikes.add(this);
        this.position = pos;
        this.orientation = ori;
        this.mesh = new LightMeshInstance(MeshLoader.KALEIDOSCOPE_SPIKE);
        for (int i = 0; i < 7; ++i) {
            this.states[i] = new LightState(new Color(), 0.0f);
        }
        this.lightState = new LightState(new Color(), 0.0f);
    }

    @Override
    public LightObject cloneOffset(Vector3f offset) {
        return new RingSpike(this.mapController, this.position.add((Vector3fc)offset, new Vector3f()), new Quaternionf((Quaternionfc)this.orientation));
    }

    @Override
    public void render(PoseStack matrices, Camera camera, float alpha, Bloomfog bloomfog) {
        Vector3f cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        Matrix4f mat = this.createTransformMatrix(matrices.last().pose(), false, this.orientation, this.rotation, this.transformState, this.position, this.worldRotation, this.offset, cameraPos);
        this.mesh.transform.set((Matrix4fc)mat);
        this.mesh.setColor(0, this.lightState);
        for (int i = 0; i < 7; ++i) {
            this.mesh.setColor(i + 1, this.states[i]);
        }
        this.mesh.draw();
    }

    @Override
    public void setBrightness(float value) {
        this.lightState.setBrightness(value);
    }

    @Override
    public void setColor(int color) {
        this.lightState.setColor(new Color(color));
    }

    @Override
    public void setLightState(LightState state) {
        this.lightState.set(state);
    }

    public class SubLightController
    extends LightObject {
        private final int target;

        public SubLightController(BeatmapController map, int target) {
            super(map);
            this.target = target;
        }

        @Override
        public LightObject cloneOffset(Vector3f offset) {
            throw new IllegalStateException("SubLightController was cloned.");
        }

        @Override
        public void render(PoseStack matrices, Camera camera, float alpha, Bloomfog bloomfog) {
        }

        @Override
        public void setBrightness(float value) {
            RingSpike.this.states[this.target].setBrightness(value);
        }

        @Override
        public void setColor(int color) {
            RingSpike.this.states[this.target].setColor(new Color(color));
        }

        @Override
        public void setLightState(LightState state) {
            RingSpike.this.states[this.target].set(state);
        }
    }
}

