/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment.lightgroup;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.lightshow.environment.lightgroup.LightGroup;
import com.beatcraft.client.lightshow.lights.LightObject;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.client.lightshow.lights.TransformState;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import net.minecraft.client.Camera;

public abstract class LightGroupV3
extends LightGroup {
    public final HashMap<Integer, LightObject> lights;

    public LightGroupV3(BeatmapController map, HashMap<Integer, LightObject> lights) {
        super(map);
        this.lights = lights;
    }

    public int getLightCount() {
        return this.lights.size();
    }

    public void reset() {
        this.lights.forEach((id, light) -> light.resetState());
    }

    public void setLightState(int id, LightState state) {
        if (this.lights.containsKey(id)) {
            this.lights.get(id).setLightState(state);
        } else {
            Beatcraft.LOGGER.error("LightGroupV3 setLightState: No LightObject with id {} found", (Object)id);
        }
    }

    public void setTransform(int id, TransformState state) {
        if (this.lights.containsKey(id)) {
            this.lights.get(id).setTransformState(state);
        } else {
            Beatcraft.LOGGER.error("LightGroupV setTransform3: No LightObject with id {} found", (Object)id);
        }
    }

    @Override
    public void render(PoseStack matrices, Camera camera, float alpha) {
        this.lights.forEach((key, light) -> light.render(matrices, camera, alpha, BeatcraftRenderer.bloomfog));
    }
}

