/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment.lightgroup;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.EventGroup;
import com.beatcraft.client.lightshow.environment.lightgroup.ActionLightGroupV2;
import com.beatcraft.client.lightshow.event.events.ValueEvent;
import com.beatcraft.client.lightshow.lights.LightObject;
import com.beatcraft.client.lightshow.ring_lights.RingLightHandler;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.function.Function;
import net.minecraft.client.Camera;
import org.apache.commons.lang3.function.TriFunction;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class RingLightGroup
extends ActionLightGroupV2 {
    private BeatmapController mapController;
    private final RingLightHandler innerRing;
    private final RingLightHandler outerRing;
    private int linkIndex = 1;

    private static HashMap<Integer, LightObject> buildRingLights(Callable<LightObject> lightFactory) {
        HashMap<Integer, LightObject> map = new HashMap<Integer, LightObject>();
        for (int i = 1; i <= 120; ++i) {
            try {
                map.put(i, lightFactory.call());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    }

    private LightObject linkLight(BeatmapController map, Vector3f position, Quaternionf orientation) {
        LightObject light = (LightObject)this.lights.get(this.linkIndex++);
        light.setPosition(position);
        light.setRotation(orientation);
        return light;
    }

    public void reset() {
        this.innerRing.reset();
        this.outerRing.reset();
    }

    public RingLightGroup(BeatmapController map, Function<TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject>, LightObject> innerRingFactory, Function<TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject>, LightObject> outerRingFactory, Callable<LightObject> outerLightFactory) {
        this(map, innerRingFactory, outerRingFactory, outerLightFactory, 2.0f, 15, 7.0f, 8.75f);
    }

    public RingLightGroup(BeatmapController map, Function<TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject>, LightObject> innerRingFactory, Function<TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject>, LightObject> outerRingFactory, Callable<LightObject> outerLightFactory, float height, int outerRingCount, float outerRingZ, float outerRingSpacing) {
        super(map, RingLightGroup.buildRingLights(outerLightFactory));
        this.mapController = map;
        this.innerRing = new RingLightHandler(map, innerRingFactory, (TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject>)((TriFunction)(m, v, q) -> null), 30, new Vector3f(0.0f, height, 14.0f), 5.0f);
        this.outerRing = new RingLightHandler(map, outerRingFactory, (TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject>)((TriFunction)this::linkLight), outerRingCount, new Vector3f(0.0f, height, outerRingZ), outerRingSpacing);
        float rpd = (float)Math.PI / 180;
        this.innerRing.jumpOffsets = new float[]{-90.0f * rpd, 90.0f * rpd};
        this.outerRing.jumpOffsets = new float[]{-90.0f * rpd, 90.0f * rpd};
        this.innerRing.rotationOffsets = new float[]{0.0f, 3.0f * rpd, -3.0f * rpd, 7.0f * rpd, -7.0f * rpd, 11.0f * rpd, -11.0f * rpd};
        this.outerRing.rotationOffsets = new float[]{0.0f, 1.0f * rpd, 2.0f * rpd, 3.0f * rpd, 4.0f * rpd, 5.0f * rpd, -1.0f * rpd, -2.0f * rpd, -3.0f * rpd, -4.0f * rpd, -5.0f * rpd};
    }

    @Override
    public void handleEvent(ValueEvent event, EventGroup eventGroup) {
        switch (eventGroup) {
            case RING_SPIN: {
                this.handleRingSpin();
                break;
            }
            case RING_ZOOM: {
                this.handleRingZoom();
            }
        }
    }

    private void handleRingSpin() {
        this.innerRing.spinRandom();
        this.outerRing.spinRandom();
    }

    private void handleRingZoom() {
        this.innerRing.setZoom((double)this.innerRing.getZoom() >= 0.99 ? 0.3f : 1.0f);
    }

    @Override
    public void update(float beat, double deltaTime) {
        float t = this.mapController.currentSeconds;
        this.innerRing.update(t);
        this.outerRing.update(t);
    }

    @Override
    public void render(PoseStack matrices, Camera camera, float alpha) {
        this.innerRing.render(matrices, camera, alpha, BeatcraftRenderer.bloomfog);
        this.outerRing.render(matrices, camera, alpha, BeatcraftRenderer.bloomfog);
    }
}

