/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment.lightgroup;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.EventGroup;
import com.beatcraft.client.lightshow.environment.lightgroup.ActionLightGroupV2;
import com.beatcraft.client.lightshow.event.events.ValueEvent;
import com.beatcraft.client.lightshow.lights.LightObject;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.util.RandomSource;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class RotatingLightsGroup
extends ActionLightGroupV2 {
    RandomSource random = RandomSource.create();
    private final List<Quaternionf> rotations;
    private final List<LightObject> rotatingLights;
    private final List<LightObject> staticLights;

    public RotatingLightsGroup(BeatmapController map, HashMap<Integer, LightObject> rotatingLights, HashMap<Integer, LightObject> staticLights) {
        super(map, RotatingLightsGroup.collectLights(rotatingLights, staticLights));
        this.rotatingLights = rotatingLights.values().stream().toList();
        this.staticLights = staticLights.values().stream().toList();
        this.rotations = rotatingLights.values().stream().map(o -> new Quaternionf()).toList();
    }

    private static HashMap<Integer, LightObject> collectLights(HashMap<Integer, LightObject> rotatingLights, HashMap<Integer, LightObject> staticLights) {
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        lights.putAll(rotatingLights);
        lights.putAll(staticLights);
        return lights;
    }

    public static Quaternionf getYRotation(int v) {
        return new Quaternionf().rotationY((float)v);
    }

    @Override
    public void handleEvent(ValueEvent event, EventGroup eventGroup) {
        int v = event.getValue();
        this.rotations.forEach(rot -> rot.set((Quaternionfc)RotatingLightsGroup.getYRotation(v)));
        this.rotatingLights.forEach(light -> light.setRotation(v == 0 ? new Quaternionf() : new Quaternionf().rotationY((float)this.random.nextIntBetweenInclusive(-180, 180) * ((float)Math.PI / 180))));
    }

    @Override
    public void update(float beat, double deltaTime) {
        for (int i = 0; i < this.rotatingLights.size(); ++i) {
            LightObject light = this.rotatingLights.get(i);
            Quaternionf rotation = this.rotations.get(i);
            light.addRotation(new Quaternionf().slerp((Quaternionfc)rotation, (float)deltaTime));
        }
    }

    @Override
    public void render(PoseStack matrices, Camera camera, float alpha) {
        super.render(matrices, camera, alpha);
        this.staticLights.forEach(light -> light.render(matrices, camera, alpha, BeatcraftRenderer.bloomfog));
    }
}

