/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment.origins;

import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.lightshow.environment.EnvironmentV2;
import com.beatcraft.client.lightshow.environment.lightgroup.LightGroupV2;
import com.beatcraft.client.lightshow.environment.lightgroup.RingLightGroup;
import com.beatcraft.client.lightshow.environment.lightgroup.RotatingLightsGroup;
import com.beatcraft.client.lightshow.environment.lightgroup.StaticLightsGroup;
import com.beatcraft.client.lightshow.environment.origins.OriginsParticleSpawner;
import com.beatcraft.client.lightshow.environment.thefirst.OuterRing;
import com.beatcraft.client.lightshow.lights.LightObject;
import com.beatcraft.client.lightshow.spectrogram.SpectrogramTowers;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.lights.GlowingCuboid;
import com.beatcraft.client.render.lights.ParticleCloudLight;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.util.HashMap;
import net.minecraft.client.Camera;
import org.apache.commons.lang3.function.TriFunction;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import oshi.util.tuples.Pair;

public class OriginsEnvironment
extends EnvironmentV2 {
    private RingLightGroup ringLights;
    private SpectrogramTowers leftSpectrogramTowers;
    private SpectrogramTowers rightSpectrogramTowers;
    private static final float ROTATING_LIGHT_X = 20.5f;
    private static final float ROTATING_LIGHT_Z = 35.0f;
    private static final float MIDDLE_LIGHT_Z = 60.0f;
    private static final Pair<Vector3f, Quaternionf>[] bottomLights = new Pair[]{new Pair((Object)new Vector3f(1.5f, -0.25f, 20.0f), (Object)new Quaternionf().rotationZ(-0.21816616f)), new Pair((Object)new Vector3f(-1.5f, -0.25f, 20.0f), (Object)new Quaternionf().rotationZ(0.21816616f)), new Pair((Object)new Vector3f(1.5f, -0.25f, 28.0f), (Object)new Quaternionf().rotationZ(-0.21816616f)), new Pair((Object)new Vector3f(-1.5f, -0.25f, 28.0f), (Object)new Quaternionf().rotationZ(0.21816616f))};
    private static final float ringRadius = 30.0f;
    private static final float lightLength = 12.0f;
    private static final float lightSize = 0.2f;

    @Override
    public String getID() {
        return "OriginsEnvironment";
    }

    public OriginsEnvironment(BeatmapController map) {
        super(map);
    }

    @Override
    public void loadLightshow(Difficulty difficulty, JsonObject json) {
        super.loadLightshow(difficulty, json);
        File f = new File(difficulty.getInfo().getSongFilename());
        this.leftSpectrogramTowers = new SpectrogramTowers(this.mapController, new Vector3f(114.0f, -71.0f, -80.5f), new Quaternionf().rotateZ(0.7853982f).rotateLocalY(-0.21816616f), new Vector3f(0.0f, 0.0f, 2.0f), 127, f, SpectrogramTowers.TowerStyle.Cuboid, true);
        this.rightSpectrogramTowers = this.leftSpectrogramTowers.copyTo(new Vector3f(-114.0f, -71.0f, -80.5f), new Quaternionf().rotateZ(-0.7853982f).rotateLocalY(0.21816616f));
        this.leftSpectrogramTowers.levelModifier = 0.75f;
        this.rightSpectrogramTowers.levelModifier = 0.75f;
        this.leftSpectrogramTowers.baseHeight = 100.0f;
        this.rightSpectrogramTowers.baseHeight = 100.0f;
        this.leftSpectrogramTowers.levelEasing = Easing::easeOutExpo;
        this.rightSpectrogramTowers.levelEasing = Easing::easeOutExpo;
    }

    private static GlowingCuboid getRunway(BeatmapController map, boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        return new GlowingCuboid(map, new Hitbox(new Vector3f(-0.03f, -0.03f, 0.0f), new Vector3f(0.03f, 0.03f, 500.0f)), new Vector3f(2.5f * (float)sign, 0.0f, 8.0f), new Quaternionf());
    }

    private static ParticleCloudLight getParticles(BeatmapController map, boolean isLeft) {
        int sign = isLeft ? 1 : -1;
        Quaternionf rotation = new Quaternionf().rotationY(0.21816616f * (float)(-sign));
        ParticleCloudLight cl = new ParticleCloudLight(map, new Vector3f((float)(12 * sign), -5.0f, 20.0f), rotation, new Hitbox(new Vector3f(-4.0f, -5.0f, -35.0f), new Vector3f(4.0f, 3.0f, 40.0f)), 0.01f, 4.0f, 4.0f, new Vector3f(0.0f, 0.0f, 2.0f));
        cl.addParticleSpawners(new OriginsParticleSpawner(map));
        return cl;
    }

    @Override
    protected LightGroupV2 setupLeftLasers() {
        HashMap<Integer, LightObject> rotatingLights = new HashMap<Integer, LightObject>();
        HashMap<Integer, LightObject> staticLights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        Vector3f offset = new Vector3f(0.0f, 0.0f, 2.25f);
        GlowingCuboid left1 = new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-0.03f, 0.0f, -0.03f), new Vector3f(0.03f, 800.0f, 0.03f)), new Vector3f(20.5f, -5.0f, 35.0f), new Quaternionf().rotationZ(0.9599311f));
        GlowingCuboid left2 = left1.cloneOffset(offset);
        GlowingCuboid left3 = left2.cloneOffset(offset);
        GlowingCuboid left4 = left3.cloneOffset(offset);
        GlowingCuboid left5 = left4.cloneOffset(offset);
        rotatingLights.put(lightID++, left1);
        rotatingLights.put(lightID++, left2);
        rotatingLights.put(lightID++, left3);
        rotatingLights.put(lightID++, left4);
        rotatingLights.put(lightID++, left5);
        GlowingCuboid leftRunway = OriginsEnvironment.getRunway(this.mapController, true);
        ParticleCloudLight leftParticles = OriginsEnvironment.getParticles(this.mapController, true);
        staticLights.put(lightID++, leftRunway);
        staticLights.put(lightID, leftParticles);
        return new RotatingLightsGroup(this.mapController, rotatingLights, staticLights);
    }

    @Override
    protected LightGroupV2 setupRightLasers() {
        HashMap<Integer, LightObject> rotatingLights = new HashMap<Integer, LightObject>();
        HashMap<Integer, LightObject> staticLights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        Vector3f offset = new Vector3f(0.0f, 0.0f, 2.25f);
        GlowingCuboid left1 = new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-0.03f, 0.0f, -0.03f), new Vector3f(0.03f, 800.0f, 0.03f)), new Vector3f(-20.5f, -5.0f, 35.0f), new Quaternionf().rotationZ(-0.9599311f));
        GlowingCuboid left2 = left1.cloneOffset(offset);
        GlowingCuboid left3 = left2.cloneOffset(offset);
        GlowingCuboid left4 = left3.cloneOffset(offset);
        GlowingCuboid left5 = left4.cloneOffset(offset);
        rotatingLights.put(lightID++, left1);
        rotatingLights.put(lightID++, left2);
        rotatingLights.put(lightID++, left3);
        rotatingLights.put(lightID++, left4);
        rotatingLights.put(lightID++, left5);
        GlowingCuboid leftRunway = OriginsEnvironment.getRunway(this.mapController, false);
        ParticleCloudLight leftParticles = OriginsEnvironment.getParticles(this.mapController, false);
        staticLights.put(lightID++, leftRunway);
        staticLights.put(lightID, leftParticles);
        return new RotatingLightsGroup(this.mapController, rotatingLights, staticLights);
    }

    @Override
    protected LightGroupV2 setupBackLasers() {
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        int lightID = 1;
        for (Pair<Vector3f, Quaternionf> pair : bottomLights) {
            lights.put(lightID++, new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-0.03f, -100.0f, -0.03f), new Vector3f(0.03f, 0.0f, 0.03f)), (Vector3f)pair.getA(), (Quaternionf)pair.getB()));
        }
        return new StaticLightsGroup(this.mapController, lights);
    }

    @Override
    protected LightGroupV2 setupCenterLasers() {
        int lightID = 1;
        HashMap<Integer, LightObject> lights = new HashMap<Integer, LightObject>();
        GlowingCuboid chevronLeft = new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-0.1f, -1.6f, -0.1f), new Vector3f(0.1f, 0.035f, 0.1f)), new Vector3f(0.0f, 4.0f, 75.0f), new Quaternionf().rotationZ(0.9599311f));
        lights.put(lightID++, chevronLeft);
        GlowingCuboid chevronRight = new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-0.1f, -1.6f, -0.1f), new Vector3f(0.1f, 0.035f, 0.1f)), new Vector3f(0.0f, 4.0f, 75.0f), new Quaternionf().rotationZ(-0.9599311f));
        lights.put(lightID++, chevronRight);
        return new StaticLightsGroup(this.mapController, lights);
    }

    @Override
    protected LightGroupV2 setupRingLights() {
        this.ringLights = new RingLightGroup(this.mapController, b -> null, m -> OuterRing.getLightsOnly(this.mapController, (TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject>)m), () -> new GlowingCuboid(this.mapController, new Hitbox(new Vector3f(-6.0f, -0.2f, -0.2f), new Vector3f(6.0f, 0.2f, 0.2f)), new Vector3f(0.0f, 29.79f, 0.2f), new Quaternionf()));
        return this.ringLights;
    }

    @Override
    public void render(PoseStack matrices, Camera camera, float alpha) {
        super.render(matrices, camera, alpha);
        float t = this.mapController.currentSeconds;
        this.leftSpectrogramTowers.render(t);
        this.rightSpectrogramTowers.render(t);
    }

    @Override
    public OriginsEnvironment reset() {
        super.reset();
        this.ringLights.reset();
        return this;
    }
}

