/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment.triangle;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.lightshow.lights.LightObject;
import com.beatcraft.client.render.effect.Bloomfog;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class InnerRing
extends LightObject {
    private static final float ringRadius = 11.0f;
    private static final float ringWidth = 1.0f;
    private static final float ringDepth = 0.1f;
    private static final int color = -16777216;
    private static final float rotationOffsetRad = 1.8325957f;
    private static final Vector3f[] dirs = new Vector3f[]{InnerRing.dir(1.8325957f), InnerRing.dir(3.926991f), InnerRing.dir(6.021386f)};
    private static Vector3f[] vertices = new Vector3f[]{InnerRing.offset(dirs[0], 12.0f, -0.1f), InnerRing.offset(dirs[1], 12.0f, -0.1f), InnerRing.offset(dirs[2], 12.0f, -0.1f), InnerRing.offset(dirs[0], 11.0f, 0.0f), InnerRing.offset(dirs[1], 11.0f, 0.0f), InnerRing.offset(dirs[2], 11.0f, 0.0f), InnerRing.offset(dirs[0], 11.0f, 0.1f), InnerRing.offset(dirs[1], 11.0f, 0.1f), InnerRing.offset(dirs[2], 11.0f, 0.1f)};
    private static final Integer[] quads = new Integer[]{0, 1, 4, 3, 1, 2, 5, 4, 2, 0, 3, 5, 3, 4, 7, 6, 4, 5, 8, 7, 5, 3, 6, 8};

    public InnerRing(BeatmapController map) {
        super(map);
        this.orientation = new Quaternionf().rotationZ(0.7853982f);
    }

    @Override
    public InnerRing cloneOffset(Vector3f offset) {
        return this;
    }

    @Override
    public void render(PoseStack matrices, Camera camera, float alpha, Bloomfog bloomfog) {
        InnerRing.resetVertices();
        Vector3f pos = new Vector3f((Vector3fc)this.position);
        Vector3f off = new Vector3f((Vector3fc)this.offset);
        Quaternionf ori = new Quaternionf((Quaternionfc)this.orientation);
        Quaternionf rot = new Quaternionf((Quaternionfc)this.rotation);
        this.mapController.recordBloomfogPosColCall((TriConsumer<Matrix4f, BufferBuilder, Vector3f>)((TriConsumer)(t, b, c) -> this._render((Matrix4f)t, (BufferBuilder)b, (Vector3f)c, pos, off, ori, rot, bloomfog)));
    }

    private Vector3f processVertex(Vector3f base, Vector3f pos, Vector3f off, Quaternionf ori, Quaternionf rot) {
        return new Vector3f((Vector3fc)base).rotate((Quaternionfc)ori).add((Vector3fc)pos).rotate((Quaternionfc)rot).add((Vector3fc)off);
    }

    private static Vector3f dir(float angleRad) {
        return new Vector3f((float)Math.cos(angleRad), (float)Math.sin(angleRad), 0.0f);
    }

    private static Vector3f offset(Vector3f dir, float dist, float z) {
        return new Vector3f(dir.x * dist, dir.y * dist, z).rotateZ(0.7853982f).add((Vector3fc)new Vector3f((float)(Math.cos(1.832595705986023) * 11.0), (float)(-(Math.sin(-0.2617993950843811) * 11.0)), 0.0f).rotateZ(-0.7853982f));
    }

    public static void resetVertices() {
        vertices = new Vector3f[]{InnerRing.offset(dirs[0], 12.0f, -0.1f), InnerRing.offset(dirs[1], 12.0f, -0.1f), InnerRing.offset(dirs[2], 12.0f, -0.1f), InnerRing.offset(dirs[0], 11.0f, 0.0f), InnerRing.offset(dirs[1], 11.0f, 0.0f), InnerRing.offset(dirs[2], 11.0f, 0.0f), InnerRing.offset(dirs[0], 11.0f, 0.1f), InnerRing.offset(dirs[1], 11.0f, 0.1f), InnerRing.offset(dirs[2], 11.0f, 0.1f)};
    }

    private void _render(Matrix4f transform, BufferBuilder buffer, Vector3f cameraPos, Vector3f position, Vector3f offset, Quaternionf orientation, Quaternionf rotation, Bloomfog bloomfog) {
        for (Integer vertex : quads) {
            buffer.addVertex(cameraPos.negate(new Vector3f()).add((Vector3fc)transform.transformPosition(this.processVertex(vertices[vertex], position, offset, orientation, rotation)))).setColor(-16777216);
        }
    }

    @Override
    public void setBrightness(float value) {
    }

    @Override
    public void setColor(int color) {
    }
}

