/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.event;

import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.lightshow.event.Filter;
import com.beatcraft.client.lightshow.event.events.LightEventV3;
import com.beatcraft.client.lightshow.event.events.RotationEventV3;
import com.beatcraft.client.lightshow.event.events.TranslationEvent;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.client.lightshow.lights.TransformState;
import com.beatcraft.common.data.types.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import oshi.util.tuples.Triplet;

public class EventBuilder {
    private final ArrayList<RawLightEventV3> rawLightEvents = new ArrayList();
    private final ArrayList<RawRotationEventV3> rawRotationEvents = new ArrayList();
    private final ArrayList<RawTranslationEvent> rawTranslationEvents = new ArrayList();
    private HashMap<GroupKey, ArrayList<LightEventV3>> lightEvents = new HashMap();
    private HashMap<GroupKey, HashMap<TransformState.Axis, ArrayList<RotationEventV3>>> rotationEvents = new HashMap();
    private HashMap<GroupKey, HashMap<TransformState.Axis, ArrayList<TranslationEvent>>> translationEvents = new HashMap();

    public void addRawLightEvents(List<RawLightEventV3> events) {
        this.rawLightEvents.addAll(events);
    }

    public void addRawRotationEvents(List<RawRotationEventV3> events) {
        this.rawRotationEvents.addAll(events);
    }

    public void addRawTranslationEvents(List<RawTranslationEvent> events) {
        this.rawTranslationEvents.addAll(events);
    }

    public List<LightEventV3> getLightEvents(int group, int lightID) {
        return this.lightEvents.computeIfAbsent(new GroupKey(group, lightID), k -> new ArrayList());
    }

    public HashMap<TransformState.Axis, ArrayList<RotationEventV3>> getRotationEvents(int group, int lightID) {
        return this.rotationEvents.computeIfAbsent(new GroupKey(group, lightID), k -> new HashMap());
    }

    public HashMap<TransformState.Axis, ArrayList<TranslationEvent>> getTranslationEvents(int group, int lightID) {
        return this.translationEvents.computeIfAbsent(new GroupKey(group, lightID), k -> new HashMap());
    }

    public List<RawLightEventV3> getRawLightEvents(int group, int lightID) {
        return this.rawLightEvents.stream().filter(e -> e.group == group && e.lightID == lightID).toList();
    }

    public List<RawRotationEventV3> getRawRotationEvents(int group, int lightID, TransformState.Axis axis) {
        return this.rawRotationEvents.stream().filter(e -> e.group == group && e.lightID == lightID && e.axis == axis).toList();
    }

    public List<RawTranslationEvent> getRawTranslationEvents(int group, int lightID, TransformState.Axis axis) {
        return this.rawTranslationEvents.stream().filter(e -> e.group == group && e.lightID == lightID && e.axis == axis).toList();
    }

    private static int rawEventComparator(RawEvent a, RawEvent b) {
        return Float.compare(a.getBeat(), b.getBeat());
    }

    public void sortEvents() {
        this.rawLightEvents.sort(EventBuilder::rawEventComparator);
        this.rawRotationEvents.sort(EventBuilder::rawEventComparator);
        this.rawTranslationEvents.sort(EventBuilder::rawEventComparator);
    }

    public void putEvent(int group, int lightID, LightEventV3 event) {
        ArrayList<LightEventV3> ls;
        GroupKey key = new GroupKey(group, lightID);
        if (!this.lightEvents.containsKey(key)) {
            this.lightEvents.put(key, new ArrayList());
        }
        if ((ls = this.lightEvents.get(key)).isEmpty()) {
            ls.add(new LightEventV3(0.0f, new LightState(new Color(0), 0.0f), new LightState(new Color(0), 0.0f), 0.0f, lightID, Easing::easeLinear));
        }
        ls.add(event);
    }

    public void putEvent(int group, int lightID, TransformState.Axis axis, RotationEventV3 event) {
        ArrayList<RotationEventV3> ls;
        HashMap<TransformState.Axis, ArrayList<RotationEventV3>> axesMap;
        GroupKey key = new GroupKey(group, lightID);
        if (!this.rotationEvents.containsKey(key)) {
            this.rotationEvents.put(key, new HashMap());
        }
        if (!(axesMap = this.rotationEvents.get(key)).containsKey((Object)axis)) {
            axesMap.put(axis, new ArrayList());
        }
        if ((ls = axesMap.get((Object)axis)).isEmpty()) {
            ls.add(new RotationEventV3(0.0f, new TransformState(axis, 0.0f), new TransformState(axis, 0.0f), 0.0f, lightID, Easing::easeStep, 0, 0));
        }
        ls.add(event);
    }

    public void putEvent(int group, int lightID, TransformState.Axis axis, TranslationEvent event) {
        ArrayList<TranslationEvent> ls;
        HashMap<TransformState.Axis, ArrayList<TranslationEvent>> axesMap;
        GroupKey key = new GroupKey(group, lightID);
        if (!this.translationEvents.containsKey(key)) {
            this.translationEvents.put(key, new HashMap());
        }
        if (!(axesMap = this.translationEvents.get(key)).containsKey((Object)axis)) {
            axesMap.put(axis, new ArrayList());
        }
        if ((ls = axesMap.get((Object)axis)).isEmpty()) {
            ls.add(new TranslationEvent(0.0f, new TransformState(axis, 0.0f), new TransformState(axis, 0.0f), 0.0f, lightID, Easing::easeStep));
        }
        ls.add(event);
    }

    public LightEventV3 getLatestLightEvent(int group, int lightID) {
        ArrayList<LightEventV3> ls;
        GroupKey key = new GroupKey(group, lightID);
        if (!this.lightEvents.containsKey(key)) {
            this.lightEvents.put(key, new ArrayList());
        }
        if ((ls = this.lightEvents.get(key)).isEmpty()) {
            ls.add(new LightEventV3(0.0f, new LightState(new Color(0), 0.0f), new LightState(new Color(0), 0.0f), 0.0f, lightID, Easing::easeLinear));
        }
        return ls.getLast();
    }

    public RotationEventV3 getLatestRotationEvent(int group, int lightID, TransformState.Axis axis) {
        ArrayList<RotationEventV3> ls;
        HashMap<TransformState.Axis, ArrayList<RotationEventV3>> axesMap;
        GroupKey key = new GroupKey(group, lightID);
        if (!this.rotationEvents.containsKey(key)) {
            this.rotationEvents.put(key, new HashMap());
        }
        if (!(axesMap = this.rotationEvents.get(key)).containsKey((Object)axis)) {
            axesMap.put(axis, new ArrayList());
        }
        if ((ls = axesMap.get((Object)axis)).isEmpty()) {
            ls.add(new RotationEventV3(0.0f, new TransformState(axis, 0.0f), new TransformState(axis, 0.0f), 0.0f, lightID, Easing::easeStep, 0, 0));
        }
        return ls.getLast();
    }

    public TranslationEvent getLatestTranslationEvent(int group, int lightID, TransformState.Axis axis) {
        ArrayList<TranslationEvent> ls;
        HashMap<TransformState.Axis, ArrayList<TranslationEvent>> axesMap;
        GroupKey key = new GroupKey(group, lightID);
        if (!this.translationEvents.containsKey(key)) {
            this.translationEvents.put(key, new HashMap());
        }
        if (!(axesMap = this.translationEvents.get(key)).containsKey((Object)axis)) {
            axesMap.put(axis, new ArrayList());
        }
        if ((ls = axesMap.get((Object)axis)).isEmpty()) {
            ls.add(new TranslationEvent(0.0f, new TransformState(axis, 0.0f), new TransformState(axis, 0.0f), 0.0f, lightID, Easing::easeStep));
        }
        return ls.getLast();
    }

    public static class GroupKey {
        private int group;
        private int id;

        public int getLightId() {
            return this.id;
        }

        public int getGroup() {
            return this.group;
        }

        public GroupKey(int group, int id) {
            this.group = group;
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GroupKey)) {
                return false;
            }
            GroupKey other = (GroupKey)obj;
            return this.group == other.group && this.id == other.id;
        }

        public int hashCode() {
            return Objects.hash(this.group, this.id);
        }
    }

    private static interface RawEvent {
        public float getBeat();
    }

    public record RawTranslationEvent(float eventBeat, float beatOffset, int group, int lightID, TransformState.Axis axis, float endOffset, float delta, Function<Float, Float> easing, int eventType) implements RawEvent
    {
        @Override
        public float getBeat() {
            return this.eventBeat;
        }
    }

    public record RawRotationEventV3(float eventBeat, float beatOffset, int group, int lightID, TransformState.Axis axis, float endOffset, float rotation, int direction, Function<Float, Float> easing, int loopCount, int eventType) implements RawEvent
    {
        @Override
        public float getBeat() {
            return this.eventBeat;
        }
    }

    public record RawLightEventV3(float eventBeat, float beatOffset, int group, int lightID, float endOffset, float brightness, float strobeFrequency, float strobeBrightness, boolean strobeFade, int eventType, int color, Function<Float, Float> easing) implements RawEvent
    {
        @Override
        public float getBeat() {
            return this.eventBeat;
        }
    }

    public record BaseTranslationData(float beat, int group, int groupLightCount, Filter filter, int beatDistributionType, float beatDistributionValue, int gapDistributionType, float gapDistributionValue, Function<Float, Float> gapEasing, TransformState.Axis axis, boolean invertAxis, boolean distributionAffectsFirst) {
        public List<RawTranslationEvent> buildEvents(boolean isFirst, float beatOffset, int eventType, float magnitude, Function<Float, Float> easing) {
            ArrayList<RawTranslationEvent> out = new ArrayList<RawTranslationEvent>();
            for (Triplet<Integer[], Float, Float> targetSet : this.filter) {
                Integer[] targets = (Integer[])targetSet.getA();
                Float durationMod = (Float)targetSet.getB();
                Float distributionMod = this.gapEasing.apply((Float)targetSet.getC());
                durationMod = Float.valueOf(durationMod.floatValue() * this.beatDistributionValue);
                if (this.beatDistributionType == 0) {
                    durationMod = Float.valueOf(durationMod.floatValue() * (float)this.filter.chunkCount());
                }
                distributionMod = Float.valueOf(distributionMod.floatValue() * this.gapDistributionValue);
                if (this.gapDistributionType == 0) {
                    distributionMod = Float.valueOf(distributionMod.floatValue() * (float)this.filter.chunkCount());
                }
                for (Integer target : targets) {
                    out.add(new RawTranslationEvent(this.beat, beatOffset, this.group, target, this.axis, this.distributionAffectsFirst || !isFirst ? durationMod.floatValue() : 0.0f, (magnitude + distributionMod.floatValue()) * (float)(this.invertAxis ? -1 : 1), easing, eventType));
                }
            }
            return out;
        }
    }

    public record BaseRotationData(float beat, int group, int groupLightCount, Filter filter, int beatDistributionType, float beatDistributionValue, int rotationDistributionType, float rotationDistributionValue, Function<Float, Float> rotationEasing, TransformState.Axis axis, boolean invertAxis, boolean distributionAffectsFirst) {
        public List<RawRotationEventV3> buildEvents(boolean isFirst, float beatOffset, int eventType, float magnitude, int direction, int loopCount, Function<Float, Float> easing) {
            ArrayList<RawRotationEventV3> out = new ArrayList<RawRotationEventV3>();
            for (Triplet<Integer[], Float, Float> targetSet : this.filter) {
                Integer[] targets = (Integer[])targetSet.getA();
                Float durationMod = (Float)targetSet.getB();
                Float distributionMod = this.rotationEasing.apply((Float)targetSet.getC());
                durationMod = Float.valueOf(durationMod.floatValue() * this.beatDistributionValue);
                if (this.beatDistributionType == 0) {
                    durationMod = Float.valueOf(durationMod.floatValue() * (float)this.filter.chunkCount());
                }
                distributionMod = Float.valueOf(distributionMod.floatValue() * this.rotationDistributionValue);
                if (this.rotationDistributionType == 0) {
                    distributionMod = Float.valueOf(distributionMod.floatValue() * (float)this.filter.chunkCount());
                }
                for (Integer target : targets) {
                    out.add(new RawRotationEventV3(this.beat, beatOffset, this.group, target, this.axis, this.distributionAffectsFirst || !isFirst ? durationMod.floatValue() : 0.0f, (magnitude + distributionMod.floatValue()) * (float)(this.invertAxis ? -1 : 1), direction, easing, loopCount, eventType));
                }
            }
            return out;
        }
    }

    public record BaseLightData(float beat, int group, int groupLightCount, Filter filter, int beatDistributionType, float beatDistributionValue, int brightnessDistributionType, float brightnessDistributionValue, Function<Float, Float> brightnessDistributionEasing, boolean distributionAffectsFirst) {
        public List<RawLightEventV3> buildEventsV3(boolean isFirst, float beatOffset, int eventType, int color, float brightness, float strobeFrequency, float strobeBrightness, boolean strobeFade) {
            Function<Float, Float> easing = eventType == 1 ? Easing::easeLinear : Easing::easeStep;
            return this.buildEventsV4(isFirst, beatOffset, Math.max(0, eventType - 1), color, brightness, strobeFrequency, strobeBrightness, strobeFade, easing);
        }

        public List<RawLightEventV3> buildEventsV4(boolean isFirst, float beatOffset, int eventType, int color, float brightness, float strobeFrequency, float strobeBrightness, boolean strobeFade, Function<Float, Float> easing) {
            ArrayList<RawLightEventV3> out = new ArrayList<RawLightEventV3>();
            for (Triplet<Integer[], Float, Float> targetSet : this.filter) {
                Integer[] targets = (Integer[])targetSet.getA();
                Float durationMod = (Float)targetSet.getB();
                Float distributionMod = (Float)targetSet.getC();
                durationMod = Float.valueOf(durationMod.floatValue() * this.beatDistributionValue);
                if (this.beatDistributionType == 0) {
                    durationMod = Float.valueOf(durationMod.floatValue() * (float)this.filter.chunkCount());
                }
                distributionMod = Float.valueOf(distributionMod.floatValue() * this.brightnessDistributionValue);
                if (this.brightnessDistributionType == 0) {
                    distributionMod = Float.valueOf(distributionMod.floatValue() * (float)this.filter.chunkCount());
                }
                for (Integer target : targets) {
                    out.add(new RawLightEventV3(this.beat, beatOffset, this.group, target, this.distributionAffectsFirst || !isFirst ? durationMod.floatValue() : 0.0f, this.brightnessDistributionEasing.apply(Float.valueOf(1.0f + distributionMod.floatValue())).floatValue() * brightness, strobeFrequency, strobeBrightness, strobeFade, eventType, color, easing));
                }
            }
            return out;
        }
    }
}

