/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.event.events;

import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.object.data.BeatmapObject;
import com.beatcraft.common.event.IEvent;
import com.beatcraft.common.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class ColorBoostEvent
extends BeatmapObject
implements IEvent {
    public boolean boosted = false;

    public ColorBoostEvent() {
    }

    public ColorBoostEvent(float beat, boolean boosted) {
        this.beat = beat;
        this.boosted = boosted;
    }

    @Override
    public float getEventBeat() {
        return this.beat;
    }

    @Override
    public float getEventDuration() {
        return 0.0f;
    }

    @Override
    public ColorBoostEvent loadV2(JsonObject json, Difficulty difficulty) {
        this.beat = JsonUtil.getOrDefault(json, "_time", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.boosted = JsonUtil.getOrDefault(json, "_value", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
        return this;
    }

    @Override
    public ColorBoostEvent loadV3(JsonObject json, Difficulty difficulty) {
        this.beat = JsonUtil.getOrDefault(json, "b", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.boosted = JsonUtil.getOrDefault(json, "o", JsonElement::getAsBoolean, Boolean.valueOf(false));
        return this;
    }

    public ColorBoostEvent loadV4(JsonObject json, JsonArray rawMetaData, Difficulty difficulty) {
        this.beat = JsonUtil.getOrDefault(json, "b", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        Integer index = JsonUtil.getOrDefault(json, "i", JsonElement::getAsInt, Integer.valueOf(0));
        JsonObject metaData = rawMetaData.get(index.intValue()).getAsJsonObject();
        this.boosted = JsonUtil.getOrDefault(metaData, "b", JsonElement::getAsInt, Integer.valueOf(0)) > 0;
        return this;
    }
}

