/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.event.events;

import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.data.EnvironmentColor;
import com.beatcraft.client.lightshow.environment.BoostableColor;
import com.beatcraft.client.lightshow.event.events.LightEvent;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.event.IEvent;
import com.beatcraft.common.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class LightEventV2
extends LightEvent
implements IEvent {
    private static final float FADE_DURATION = 4.0f;
    private LightState lightState;
    private int lightEventType = 0;
    private float eventValue = 0.0f;
    private float duration = 0.0f;
    private int[] lightIDs;
    private Color chromaColor = null;
    private LightState fadeFrom = null;

    public void setFadeFrom(LightState from) {
        if (this.fadeFrom == null) {
            this.fadeFrom = from;
        }
    }

    public LightState getFaded(float t) {
        if (this.fadeFrom != null) {
            return this.fadeFrom.lerpFromTo(this.lightState, t);
        }
        return this.lightState;
    }

    @Override
    public float getEventBeat() {
        return this.getBeat();
    }

    @Override
    public float getEventDuration() {
        return this.duration;
    }

    public String toString() {
        return String.format("LightEvent[b:%s, v:%s, f:%s, d:%s]", Float.valueOf(this.getBeat()), this.lightEventType, Float.valueOf(this.eventValue), Float.valueOf(this.duration));
    }

    public boolean isFlashType() {
        return this.lightEventType == 2 || this.lightEventType == 6 || this.lightEventType == 10;
    }

    public boolean isFadeType() {
        return this.lightEventType == 3 || this.lightEventType == 7 || this.lightEventType == 11;
    }

    public boolean isTransitionType() {
        return this.lightEventType == 4 || this.lightEventType == 8 || this.lightEventType == 12;
    }

    @Override
    public LightEventV2 loadV2(JsonObject json, Difficulty difficulty) {
        super.loadV2(json, difficulty);
        this.lightEventType = JsonUtil.getOrDefault(json, "_value", JsonElement::getAsInt, Integer.valueOf(0));
        this.eventValue = JsonUtil.getOrDefault(json, "_floatValue", JsonElement::getAsFloat, Float.valueOf(1.0f)).floatValue();
        this.lightState = new LightState(new Color(0), 0.0f);
        JsonObject customData = JsonUtil.getOrDefault(json, "_customData", JsonElement::getAsJsonObject, null);
        if (customData != null) {
            JsonArray chromaColor;
            JsonElement lightIDs = JsonUtil.getOrDefault(customData, "_lightID", e -> e, null);
            if (lightIDs != null) {
                if (lightIDs.isJsonArray()) {
                    JsonArray lightIDsArray = lightIDs.getAsJsonArray();
                    this.lightIDs = new int[lightIDsArray.size()];
                    for (int i = 0; i < lightIDsArray.size(); ++i) {
                        int lightID;
                        this.lightIDs[i] = lightID = lightIDsArray.get(i).getAsInt();
                    }
                } else {
                    this.lightIDs = new int[1];
                    this.lightIDs[0] = lightIDs.getAsInt();
                }
            }
            if ((chromaColor = (JsonArray)JsonUtil.getOrDefault(customData, "_color", JsonElement::getAsJsonArray, null)) != null) {
                this.chromaColor = Color.fromJsonArray(chromaColor);
            }
        }
        this.process(difficulty, this.lightState);
        return this;
    }

    @Override
    public LightEventV2 loadV3(JsonObject json, Difficulty difficulty) {
        super.loadV3(json, difficulty);
        this.lightEventType = JsonUtil.getOrDefault(json, "i", JsonElement::getAsInt, Integer.valueOf(0));
        this.eventValue = JsonUtil.getOrDefault(json, "f", JsonElement::getAsFloat, Float.valueOf(1.0f)).floatValue();
        this.lightState = new LightState(new Color(0), 0.0f);
        this.process(difficulty, this.lightState);
        return this;
    }

    public LightEventV2 loadV4(JsonObject json, JsonObject data, Difficulty difficulty) {
        super.loadV3(json, difficulty);
        this.lightEventType = JsonUtil.getOrDefault(data, "i", JsonElement::getAsInt, Integer.valueOf(0));
        this.eventValue = JsonUtil.getOrDefault(data, "f", JsonElement::getAsFloat, Float.valueOf(1.0f)).floatValue();
        this.lightState = new LightState(new Color(0), 0.0f);
        this.process(difficulty, this.lightState);
        return this;
    }

    private Color getColor(EnvironmentColor environmentColor) {
        if (this.chromaColor != null) {
            return this.chromaColor;
        }
        return switch (environmentColor) {
            default -> throw new MatchException(null, null);
            case EnvironmentColor.LEFT -> new BoostableColor(0);
            case EnvironmentColor.RIGHT -> new BoostableColor(1);
            case EnvironmentColor.WHITE -> new BoostableColor(2);
        };
    }

    @Override
    public boolean containsLightID(int lightID) {
        if (this.lightIDs == null) {
            return true;
        }
        for (int id : this.lightIDs) {
            if (id != lightID) continue;
            return true;
        }
        return false;
    }

    public LightState getLightState() {
        return this.lightState;
    }

    public void process(Difficulty difficulty, LightState lightState) {
        switch (this.lightEventType) {
            case 0: {
                lightState.setBrightness(0.0f);
                lightState.setColor(new Color(0));
                break;
            }
            case 1: {
                lightState.setColor(this.getColor(EnvironmentColor.RIGHT));
                lightState.setBrightness(this.eventValue);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                lightState.setColor(this.getColor(EnvironmentColor.RIGHT));
                lightState.setBrightness(this.eventValue);
                this.duration = 4.0f;
                break;
            }
            case 5: {
                lightState.setColor(this.getColor(EnvironmentColor.LEFT));
                lightState.setBrightness(this.eventValue);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                lightState.setColor(this.getColor(EnvironmentColor.LEFT));
                lightState.setBrightness(this.eventValue);
                this.duration = 4.0f;
                break;
            }
            case 9: {
                lightState.setColor(this.getColor(EnvironmentColor.WHITE));
                lightState.setBrightness(this.eventValue);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                lightState.setColor(this.getColor(EnvironmentColor.WHITE));
                lightState.setBrightness(this.eventValue);
                this.duration = 4.0f;
                break;
            }
        }
    }
}

