/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.event.handlers;

import com.beatcraft.client.lightshow.environment.lightgroup.LightGroupV3;
import com.beatcraft.client.lightshow.event.events.LightEventV3;
import com.beatcraft.client.lightshow.event.events.RotationEventV3;
import com.beatcraft.client.lightshow.event.events.TranslationEvent;
import com.beatcraft.client.lightshow.event.handlers.LightEventHandlerV3;
import com.beatcraft.client.lightshow.event.handlers.RotationEventHandlerV3;
import com.beatcraft.client.lightshow.event.handlers.TranslationEventHandler;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.client.lightshow.lights.TransformState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GroupEventHandlerV3 {
    private final LightGroupV3 lightGroupV3;
    public final HashMap<Integer, LightEventHandlerV3> lightHandlers = new HashMap();
    public final HashMap<Integer, HashMap<TransformState.Axis, RotationEventHandlerV3>> rotationHandlers = new HashMap();
    public final HashMap<Integer, HashMap<TransformState.Axis, TranslationEventHandler>> translationHandlers = new HashMap();

    public GroupEventHandlerV3(LightGroupV3 group) {
        this.lightGroupV3 = group;
    }

    public void linkLightEvents(List<LightEventV3> lightEvents) {
        this.lightGroupV3.lights.forEach((lightID, light) -> {
            List<LightEventV3> relevantEvents = lightEvents.stream().filter(o -> o.containsLightID((int)lightID)).toList();
            if (this.lightHandlers.containsKey(lightID)) {
                this.lightHandlers.get(lightID).addEvents(relevantEvents);
            } else {
                this.lightHandlers.put((Integer)lightID, new LightEventHandlerV3(relevantEvents));
            }
        });
    }

    public void linkRotationEvents(int lightID, HashMap<TransformState.Axis, ArrayList<RotationEventV3>> rotationEvents) {
        if (!this.lightGroupV3.lights.containsKey(lightID)) {
            return;
        }
        if (!this.rotationHandlers.containsKey(lightID)) {
            this.rotationHandlers.put(lightID, new HashMap());
        }
        if (rotationEvents != null) {
            rotationEvents.forEach((axis, events) -> {
                HashMap<TransformState.Axis, RotationEventHandlerV3> axes = this.rotationHandlers.get(lightID);
                if (axes.containsKey(axis)) {
                    axes.get(axis).addEvents((List<RotationEventV3>)events);
                } else {
                    axes.put((TransformState.Axis)((Object)axis), new RotationEventHandlerV3((List<RotationEventV3>)events, (TransformState.Axis)((Object)axis)));
                }
            });
        }
    }

    public void linkTranslationEvents(int lightID, HashMap<TransformState.Axis, ArrayList<TranslationEvent>> translationEvents) {
        if (!this.lightGroupV3.lights.containsKey(lightID)) {
            return;
        }
        if (!this.translationHandlers.containsKey(lightID)) {
            this.translationHandlers.put(lightID, new HashMap());
        }
        if (translationEvents != null) {
            translationEvents.forEach((axis, events) -> {
                HashMap<TransformState.Axis, TranslationEventHandler> axes = this.translationHandlers.get(lightID);
                if (axes.containsKey(axis)) {
                    axes.get(axis).addEvents((List<TranslationEvent>)events);
                } else {
                    axes.put((TransformState.Axis)((Object)axis), new TranslationEventHandler((List<TranslationEvent>)events, (TransformState.Axis)((Object)axis)));
                }
            });
        }
    }

    public void seek(float beat) {
        this.lightHandlers.forEach((id, handler) -> handler.seek(beat));
        this.rotationHandlers.forEach((id, axisHandlers) -> axisHandlers.forEach((axis, handler) -> handler.seek(beat)));
        this.translationHandlers.forEach((id, axisHandlers) -> axisHandlers.forEach((axis, handler) -> handler.seek(beat)));
    }

    public void update(float beat) {
        this.lightHandlers.forEach((id, handler) -> {
            LightState state = (LightState)handler.update(beat);
            this.lightGroupV3.setLightState((int)id, state);
        });
        this.rotationHandlers.forEach((id, axisHandlers) -> axisHandlers.forEach((axis, handler) -> {
            TransformState state = (TransformState)handler.update(beat);
            this.lightGroupV3.setTransform((int)id, state);
        }));
        this.translationHandlers.forEach((id, axisHandlers) -> axisHandlers.forEach((axis, handler) -> {
            TransformState state = (TransformState)handler.update(beat);
            this.lightGroupV3.setTransform((int)id, state);
        }));
    }

    public void reset() {
        this.lightHandlers.forEach((k, v) -> v.reset());
        this.rotationHandlers.forEach((k, v) -> v.forEach((k2, v2) -> v2.reset()));
        this.translationHandlers.forEach((k, v) -> v.forEach((k2, v2) -> v2.reset()));
    }

    public void clear() {
        this.lightHandlers.clear();
        this.rotationHandlers.clear();
        this.translationHandlers.clear();
    }
}

