/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.event.handlers;

import com.beatcraft.client.lightshow.event.events.LightEventV2;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.event.EventHandler;
import java.util.List;
import net.minecraft.util.Mth;

public class LightEventHandlerV2
extends EventHandler<LightState, LightEventV2> {
    public LightEventHandlerV2(List<LightEventV2> events) {
        super(events, new LightState(new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f));
    }

    @Override
    public void onEventInterrupted(LightEventV2 event, float normalTime) {
    }

    @Override
    public void onInsideEvent(LightEventV2 event, float normalTime) {
        LightState ls = event.getLightState();
        float fadeTime = 1.0f - (float)Math.pow(1.0f - normalTime, 3.0);
        if (event.isFlashType()) {
            float brightness = Mth.lerp((float)fadeTime, (float)1.2f, (float)1.0f);
            LightState s = ls.copy();
            s.setBrightness(brightness);
            this.state = s;
        } else if (event.isFadeType()) {
            float brightness = Mth.lerp((float)fadeTime, (float)1.2f, (float)0.0f);
            LightState s = ls.copy();
            s.setBrightness(brightness);
            this.state = s;
        } else if (event.isTransitionType()) {
            event.setFadeFrom((LightState)this.state);
            this.state = event.getFaded(normalTime);
        }
    }

    @Override
    public void onEventPassed(LightEventV2 event) {
        this.state = event.isFadeType() ? new LightState(new Color(0), 0.0f) : event.getLightState();
    }
}

