/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.event.handlers;

import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.lightshow.event.events.RotationEventV3;
import com.beatcraft.client.lightshow.lights.TransformState;
import com.beatcraft.common.event.EventHandler;
import java.util.List;
import java.util.function.Function;

public class RotationEventHandlerV3
extends EventHandler<TransformState, RotationEventV3> {
    public RotationEventHandlerV3(List<RotationEventV3> events, TransformState.Axis initialAxis) {
        super(events, new TransformState(initialAxis, 0.0f));
    }

    public void addEvents(List<RotationEventV3> events) {
        this.events.addAll(events);
        this.events.sort(Difficulty::compareObjects);
    }

    @Override
    public void onEventInterrupted(RotationEventV3 event, float normalTime) {
    }

    @Override
    public void onInsideEvent(RotationEventV3 event, float normalTime) {
        float counterClockwiseDiff;
        float clockwiseDiff;
        TransformState start = event.startState;
        TransformState end = event.transformState;
        int loops = event.loops;
        int direction = event.direction;
        Function<Float, Float> easing = event.easing;
        float easedTime = easing.apply(Float.valueOf(normalTime)).floatValue();
        float startRotation = start.value;
        float endRotation = end.value;
        float rotationDiff = direction == 0 ? ((clockwiseDiff = (endRotation - startRotation + 360.0f) % 360.0f) <= (counterClockwiseDiff = (startRotation - endRotation + 360.0f) % 360.0f) ? clockwiseDiff : -counterClockwiseDiff) : (direction == 1 ? (endRotation - startRotation + 360.0f) % 360.0f : -((startRotation - endRotation + 360.0f) % 360.0f));
        float interpolatedRotation = startRotation + (rotationDiff += (float)(loops * 360 * (rotationDiff >= 0.0f ? 1 : -1))) * easedTime;
        ((TransformState)this.state).set(start.axis, interpolatedRotation);
    }

    @Override
    public void onEventPassed(RotationEventV3 event) {
        ((TransformState)this.state).set(event.transformState);
    }
}

