/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.logic;

import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Hitbox {
    public Vector3f min;
    public Vector3f max;

    public Hitbox(Vector3f min, Vector3f max) {
        this.min = min;
        this.max = max;
    }

    public float getVolume() {
        float x = this.max.x - this.min.x;
        float y = this.max.y - this.min.y;
        float z = this.max.z - this.min.z;
        int zeroCount = 0;
        if (x == 0.0f) {
            ++zeroCount;
        }
        if (y == 0.0f) {
            ++zeroCount;
        }
        if (z == 0.0f) {
            ++zeroCount;
        }
        if (zeroCount == 0) {
            return x * y * z;
        }
        if (zeroCount == 1) {
            return x == 0.0f ? y * z : (y == 0.0f ? x * z : x * y);
        }
        if (zeroCount == 2) {
            return x != 0.0f ? x : (y != 0.0f ? y : z);
        }
        return 0.0f;
    }

    public void getVisualCenter(Vector3f dest) {
        dest.set((double)(this.min.x + this.max.x) / 2.0, (double)(this.min.y + this.max.y) / 2.0, (double)(this.min.z + this.max.z) / 2.0);
    }

    public void getVisualExtents(Vector3f dest) {
        dest.set((double)(this.max.x - this.min.x) / 2.0, (double)(this.max.y - this.min.y) / 2.0, (double)(this.max.z - this.min.z) / 2.0);
    }

    public boolean checkCollision(Vector3f pointA, Vector3f pointB) {
        if (this.isPointInHitbox(pointA) || this.isPointInHitbox(pointB)) {
            return true;
        }
        Vector3f direction = new Vector3f((Vector3fc)pointB).sub((Vector3fc)pointA);
        Vector3f inverted = new Vector3f(1.0f / direction.x, 1.0f / direction.y, 1.0f / direction.z);
        float t1 = (this.min.x - pointA.x) * inverted.x;
        float t2 = (this.max.x - pointA.x) * inverted.x;
        float t3 = (this.min.y - pointA.y) * inverted.y;
        float t4 = (this.max.y - pointA.y) * inverted.y;
        float t5 = (this.min.z - pointA.z) * inverted.z;
        float t6 = (this.max.z - pointA.z) * inverted.z;
        float tMin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)), Math.min(t5, t6));
        float tMax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)), Math.max(t5, t6));
        return 0.0f <= tMax && tMin <= tMax && tMax <= 1.0f;
    }

    public Vector3f raycast(Vector3f pointA, Vector3f pointB) {
        if (this.isPointInHitbox(pointA)) {
            return new Vector3f((Vector3fc)pointA);
        }
        Vector3f direction = new Vector3f((Vector3fc)pointB).sub((Vector3fc)pointA);
        Vector3f inverted = new Vector3f(1.0f / direction.x, 1.0f / direction.y, 1.0f / direction.z);
        float t1 = (this.min.x - pointA.x) * inverted.x;
        float t2 = (this.max.x - pointA.x) * inverted.x;
        float t3 = (this.min.y - pointA.y) * inverted.y;
        float t4 = (this.max.y - pointA.y) * inverted.y;
        float t5 = (this.min.z - pointA.z) * inverted.z;
        float t6 = (this.max.z - pointA.z) * inverted.z;
        float tMin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)), Math.min(t5, t6));
        float tMax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)), Math.max(t5, t6));
        if (0.0f <= tMax && tMin <= tMax && tMax <= 1.0f) {
            return new Vector3f((Vector3fc)pointA).add((Vector3fc)new Vector3f((Vector3fc)direction).mul(tMin));
        }
        return null;
    }

    public boolean isPointInHitbox(Vector3f point) {
        return this.min.x <= point.x && point.x <= this.max.x && this.min.y <= point.y && point.y <= this.max.y && this.min.z <= point.z && point.z <= this.max.z;
    }
}

