/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.RenderUtil;
import com.beatcraft.client.render.dynamic_loader.DynamicTexture;
import com.beatcraft.common.data.types.ISplinePath;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DebugRenderer {
    private static final ArrayList<Runnable> renderCalls = new ArrayList();
    public static final ParticleOptions RED_DUST = new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 0.5f);
    public static final ParticleOptions ORANGE_DUST = new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.0f), 0.5f);
    public static final ParticleOptions YELLOW_DUST = new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f);
    public static final ParticleOptions GREEN_DUST = new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 0.5f);
    public static final ParticleOptions BLUE_DUST = new DustParticleOptions(new Vector3f(0.0f, 0.0f, 1.0f), 0.5f);
    public static final ParticleOptions MAGENTA_DUST = new DustParticleOptions(new Vector3f(1.0f, 0.0f, 1.0f), 0.5f);
    public static DynamicTexture dynamicTexture;
    public static boolean doDebugRendering;
    public static boolean debugSaberRendering;
    public static boolean renderHitboxes;
    public static boolean renderArcDebugLines;

    public static void renderLine(Vector3f origin, Vector3f end, int colorA, int colorB) {
        renderCalls.add(() -> DebugRenderer._renderLine(origin, end, colorA, colorB));
    }

    public static void renderParticle(Vector3f point, ParticleOptions particle) {
        Minecraft.getInstance().level.addParticle(particle, (double)point.x, (double)point.y, (double)point.z, 0.0, 0.0, 0.0);
    }

    public static void renderHitbox(Hitbox hitbox, Vector3f position, Quaternionf orientation, int color, boolean doDepthTest) {
        renderCalls.add(() -> DebugRenderer._renderHitbox(hitbox, position, orientation, color, doDepthTest, 2));
    }

    public static void renderHitbox(Hitbox hitbox, Vector3f position, Quaternionf orientation, int color, boolean doDepthTest, int lineWidth) {
        renderCalls.add(() -> DebugRenderer._renderHitbox(hitbox, position, orientation, color, doDepthTest, lineWidth));
    }

    public static void renderPath(ISplinePath path, int segments, int color) {
        renderCalls.add(() -> DebugRenderer._renderPath(path, segments, color));
    }

    public static void _renderLine(Vector3f origin, Vector3f endPoint, int colorA, int colorB) {
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        Vector3f cam = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        Vector3f normal = endPoint.sub((Vector3fc)origin, new Vector3f());
        origin = origin.sub((Vector3fc)cam, new Vector3f());
        endPoint = endPoint.sub((Vector3fc)cam, new Vector3f());
        buffer.addVertex(origin.x, origin.y, origin.z).setColor(colorA).setNormal(normal.x, normal.y, normal.z);
        buffer.addVertex(endPoint.x, endPoint.y, endPoint.z).setColor(colorB).setNormal(normal.x, normal.y, normal.z);
        MeshData buff = buffer.build();
        if (buff == null) {
            return;
        }
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        float oldLineWidth = RenderSystem.getShaderLineWidth();
        RenderSystem.lineWidth((float)2.0f);
        BufferUploader.drawWithShader((MeshData)buff);
        RenderSystem.disableDepthTest();
        RenderSystem.lineWidth((float)oldLineWidth);
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    public static void _renderPath(ISplinePath path, int segments, int color) {
        MeshData buff;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        Vector3f cam = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        for (int i = 0; i < segments; ++i) {
            float f = (float)i / (float)segments;
            float f2 = (float)(i + 1) / (float)segments;
            Vector3f p = path.evaluate(f).sub((Vector3fc)cam);
            Vector3f p2 = path.evaluate(f2).sub((Vector3fc)cam);
            Vector3f normal = p2.sub((Vector3fc)p, new Vector3f()).normalize();
            buffer.addVertex(p.x, p.y, p.z).setColor(color).setNormal(normal.x, normal.y, normal.z);
            buffer.addVertex(p2.x, p2.y, p2.z).setColor(color).setNormal(normal.x, normal.y, normal.z);
        }
        List<Vector3f> controlPoints = path.getControlPoints();
        if (controlPoints.size() >= 2) {
            for (int i = 0; i < controlPoints.size() - 1; ++i) {
                Vector3f p = controlPoints.get(i).sub((Vector3fc)cam);
                Vector3f p2 = controlPoints.get(i + 1).sub((Vector3fc)cam);
                Vector3f normal = p2.sub((Vector3fc)p, new Vector3f()).normalize();
                buffer.addVertex(p.x, p.y, p.z).setColor(0xFF0000).setNormal(normal.x, normal.y, normal.z);
                buffer.addVertex(p2.x, p2.y, p2.z).setColor(0xFF0000).setNormal(normal.x, normal.y, normal.z);
            }
        }
        if ((buff = buffer.build()) == null) {
            return;
        }
        ShaderInstance oldShader = RenderSystem.getShader();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        float oldLineWidth = RenderSystem.getShaderLineWidth();
        RenderSystem.lineWidth((float)2.0f);
        BufferUploader.drawWithShader((MeshData)buff);
        RenderSystem.lineWidth((float)oldLineWidth);
        RenderSystem.setShader(() -> oldShader);
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
    }

    public static void renderHitbox(Hitbox hitbox, Vector3f position, Quaternionf orientation, int color) {
        DebugRenderer.renderHitbox(hitbox, position, orientation, color, false);
    }

    private static void _renderHitbox(Hitbox hitbox, Vector3f position, Quaternionf orientation, int color, boolean doDepthTest, int lineWidth) {
        List<Vector3f[]> edges = BeatcraftRenderer.getCubeEdges(hitbox.min, hitbox.max);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        Vec3 cam = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        ShaderInstance oldShader = RenderSystem.getShader();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)doDepthTest);
        if (doDepthTest) {
            RenderSystem.enableDepthTest();
        }
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        float oldLineWidth = RenderSystem.getShaderLineWidth();
        RenderSystem.lineWidth((float)lineWidth);
        for (Vector3f[] edge : edges) {
            Vector3f c1 = edge[0].rotate((Quaternionfc)orientation, new Vector3f());
            Vector3f c2 = edge[1].rotate((Quaternionfc)orientation, new Vector3f());
            c1.add((Vector3fc)position);
            c2.add((Vector3fc)position);
            Vector3f normal = c2.sub((Vector3fc)c1, new Vector3f()).normalize();
            for (Vector3f[] segments : RenderUtil.chopEdge(c1, c2)) {
                buffer.addVertex((float)((double)segments[0].x - cam.x), (float)((double)segments[0].y - cam.y), (float)((double)segments[0].z - cam.z)).setColor(color).setNormal(normal.x, normal.y, normal.z);
                buffer.addVertex((float)((double)segments[1].x - cam.x), (float)((double)segments[1].y - cam.y), (float)((double)segments[1].z - cam.z)).setColor(color).setNormal(normal.x, normal.y, normal.z);
            }
        }
        MeshData buff = buffer.build();
        if (buff == null) {
            return;
        }
        BufferUploader.drawWithShader((MeshData)buff);
        RenderSystem.disableDepthTest();
        RenderSystem.lineWidth((float)oldLineWidth);
        RenderSystem.setShader(() -> oldShader);
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    public static void render() {
        for (Runnable renderCall : renderCalls) {
            try {
                renderCall.run();
            }
            catch (Exception e) {
                Beatcraft.LOGGER.error("Render call failed! ", (Throwable)e);
            }
        }
        renderCalls.clear();
    }

    static {
        doDebugRendering = false;
        debugSaberRendering = false;
        renderHitboxes = false;
        renderArcDebugLines = false;
    }
}

