/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.NoteType;
import com.beatcraft.client.logic.Rank;
import com.beatcraft.client.menu.EndScreenData;
import com.beatcraft.client.menu.ErrorMessageMenu;
import com.beatcraft.client.menu.KeyboardMenu;
import com.beatcraft.client.menu.ModifierMenu;
import com.beatcraft.client.menu.SongSelectMenu;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.menu.ConfirmSongDeleteMenuPanel;
import com.beatcraft.client.render.menu.CreditsPanel;
import com.beatcraft.client.render.menu.EndScreenPanel;
import com.beatcraft.client.render.menu.ErrorMessagePanel;
import com.beatcraft.client.render.menu.KeyboardPanel;
import com.beatcraft.client.render.menu.ModifierMenuPanel;
import com.beatcraft.client.render.menu.PauseScreenPanel;
import com.beatcraft.client.render.menu.SettingsMenuPanel;
import com.beatcraft.client.render.menu.SongDownloaderMenuPanel;
import com.beatcraft.client.render.menu.SongSelectMenuPanel;
import com.beatcraft.client.render.menu.TextInput;
import com.beatcraft.client.render.particle.BeatcraftParticleRenderer;
import com.beatcraft.client.render.particle.MenuPointerParticle;
import com.beatcraft.client.render.particle.ScoreDisplay;
import com.beatcraft.common.utils.MathUtil;
import com.beatcraft.mixin_utils.BufferBuilderAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import oshi.util.tuples.Pair;

public class HUDRenderer {
    public static MultiBufferSource.BufferSource buffers;
    private static final Font.DisplayMode TEXT_LAYER;
    public static final int TEXT_COLOR = -1;
    public static final int TEXT_LIGHT = 255;
    public final BeatmapController controller;
    public final Matrix4f leftPanelTransform = new Matrix4f().translate(3.0f, 1.0f, 0.0f).rotateZ((float)Math.PI);
    public final Matrix4f rightPanelTransform = new Matrix4f().translate(-3.0f, 1.0f, 0.0f).rotateZ((float)Math.PI);
    public final Matrix4f healthBarTransform = new Matrix4f().translate(0.0f, -1.5f, 0.0f).rotateZ((float)Math.PI);
    public NoteType pointerSaber = NoteType.BLUE;
    public boolean triggerPressed = false;
    public boolean triggerWasPressed = false;
    public boolean showHUD = true;
    public boolean advancedHUD = true;
    public final SongSelectMenu songSelectMenu;
    public SongSelectMenuPanel songSelectMenuPanel;
    public ErrorMessagePanel errorMessagePanel;
    public final PauseScreenPanel pauseScreenPanel;
    public final ModifierMenu modifierMenu;
    public final ModifierMenuPanel modifierMenuPanel;
    public final EndScreenPanel endScreenPanel;
    public ConfirmSongDeleteMenuPanel confirmSongDeleteMenuPanel = null;
    private final SongDownloaderMenuPanel songDownloaderMenuPanel;
    private final SettingsMenuPanel settingsMenuPanel;
    private final CreditsPanel creditsPanel;
    public boolean showKeyboard = false;
    private final KeyboardMenu keyboardData;
    public final KeyboardPanel keyboard;
    private final Vector2f HEART_SIZE = new Vector2f(0.25f);
    private final ResourceLocation heartsTexture = Beatcraft.id("textures/gui/hearts.png");
    private final Vector2f emptyHeartUV = new Vector2f(0.5f, 0.0f);

    public HUDRenderer(BeatmapController controller) {
        this.controller = controller;
        this.pauseScreenPanel = new PauseScreenPanel(this);
        this.modifierMenu = new ModifierMenu(this);
        this.modifierMenuPanel = new ModifierMenuPanel(this.modifierMenu);
        this.songSelectMenu = new SongSelectMenu(this);
        this.errorMessagePanel = new ErrorMessagePanel(new ErrorMessageMenu(this));
        this.endScreenPanel = new EndScreenPanel(new EndScreenData(this, 0, Rank.A, 0, 0, 0.0f, 0));
        this.songDownloaderMenuPanel = new SongDownloaderMenuPanel(this);
        this.settingsMenuPanel = new SettingsMenuPanel(this);
        this.creditsPanel = new CreditsPanel(this);
        this.keyboardData = new KeyboardMenu(this, null);
        this.keyboard = new KeyboardPanel(this.keyboardData);
        this.songSelectMenuPanel = new SongSelectMenuPanel(this.songSelectMenu);
    }

    public void hookToKeyboard(TextInput input) {
        this.keyboardData.input = input;
        this.showKeyboard = true;
        this.errorMessagePanel.close();
    }

    public void hideKeyboard() {
        this.showKeyboard = false;
    }

    public void postScore(int score, Vector3f position, Vector3f endpoint, Quaternionf orientation) {
        if (!this.showHUD) {
            return;
        }
        BeatcraftParticleRenderer.addParticle(new ScoreDisplay(score, position, endpoint, orientation));
    }

    public void render(MultiBufferSource imm) {
        buffers = (MultiBufferSource.BufferSource)imm;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)true);
        switch (this.controller.scene.ordinal()) {
            case 0: {
                this.renderGameHud();
                break;
            }
            case 1: {
                this.renderSongSelectHud();
                break;
            }
            case 3: {
                this.renderSettings();
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.renderDownloader();
                break;
            }
            case 5: {
                this.renderEndScreen();
                break;
            }
            case 6: {
                this.renderConfirmSongDelete();
                break;
            }
            case 7: {
                this.renderPauseScreen();
                break;
            }
            case 8: {
                this.renderSaberPreviewScreen();
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }

    public boolean isTriggerPressed() {
        boolean res = this.triggerPressed && !this.triggerWasPressed;
        this.triggerWasPressed = this.triggerPressed;
        return res;
    }

    public void renderGameHud() {
        if (!this.showHUD || this.controller.isModifierActive("Zen Mode")) {
            this.renderTime(null, null, null, null);
            return;
        }
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Font textRenderer = Minecraft.getInstance().font;
        Vector3f cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        PoseStack matrices = new PoseStack();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        Vector3f wp = this.controller.worldPosition;
        float wr = this.controller.worldAngle;
        matrices.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        matrices.translate(wp.x, wp.y, wp.z);
        matrices.mulPose(new Quaternionf().rotationY(wr));
        matrices.translate(0.0, 0.0, 7.99);
        matrices.pushPose();
        matrices.mulPose(this.leftPanelTransform);
        matrices.scale(0.03125f, 0.03125f, 0.03125f);
        this.renderRank(matrices, textRenderer, buffer, cameraPos);
        this.renderCombo(matrices, textRenderer, buffer, cameraPos);
        this.renderScore(matrices, textRenderer, buffer, cameraPos);
        this.renderAccuracy(matrices, textRenderer, buffer, cameraPos);
        matrices.popPose();
        matrices.pushPose();
        matrices.mulPose(this.rightPanelTransform);
        matrices.scale(0.03125f, 0.03125f, 0.03125f);
        this.renderModifier(matrices, textRenderer, buffer, cameraPos);
        this.renderTime(matrices, textRenderer, buffer, cameraPos);
        matrices.popPose();
        MeshData buff = buffer.build();
        if (buff == null) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        buff.sortQuads(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), VertexSorting.DISTANCE_TO_ORIGIN);
        BufferUploader.drawWithShader((MeshData)buff);
        RenderSystem.disableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        matrices.pushPose();
        matrices.mulPose(this.healthBarTransform);
        matrices.scale(0.03125f, 0.03125f, 0.03125f);
        this.renderPlayerHealth(matrices, textRenderer, cameraPos);
        matrices.popPose();
    }

    private void renderSongSelectHud() {
        if (this.songSelectMenuPanel == null) {
            return;
        }
        Vector3f saberPos = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberPos : this.controller.logic.leftSaberPos;
        Quaternionf saberRot = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberRotation : this.controller.logic.leftSaberRotation;
        boolean tp = this.isTriggerPressed();
        Pair<Vector3f, Vector2f> pair = this.songSelectMenuPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.songSelectMenuPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.songSelectMenuPanel.render(buffers, local, tp);
        pair = this.modifierMenuPanel.raycast(saberPos, saberRot);
        if (pair == null) {
            local = null;
        } else {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.modifierMenuPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.modifierMenuPanel.render(buffers, local, tp);
        pair = this.creditsPanel.raycast(saberPos, saberRot);
        if (pair == null) {
            local = null;
        } else {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.creditsPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.creditsPanel.render(buffers, local, tp);
        if (this.errorMessagePanel.shouldDisplay()) {
            pair = this.errorMessagePanel.raycast(saberPos, saberRot);
            local = null;
            if (pair != null) {
                this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.errorMessagePanel.getNormal());
                local = (Vector2f)pair.getB();
            }
            this.errorMessagePanel.render(buffers, local, tp);
        }
    }

    private void renderSettings() {
        Vector3f saberPos = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberPos : this.controller.logic.leftSaberPos;
        Quaternionf saberRot = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberRotation : this.controller.logic.leftSaberRotation;
        boolean tp = this.isTriggerPressed();
        Pair<Vector3f, Vector2f> pair = this.settingsMenuPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.settingsMenuPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.settingsMenuPanel.render(buffers, local, tp);
        if (this.errorMessagePanel.shouldDisplay()) {
            pair = this.errorMessagePanel.raycast(saberPos, saberRot);
            local = null;
            if (pair != null) {
                this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.errorMessagePanel.getNormal());
                local = (Vector2f)pair.getB();
            }
            this.errorMessagePanel.render(buffers, local, tp);
        }
        if ((pair = this.modifierMenuPanel.raycast(saberPos, saberRot)) == null) {
            local = null;
        } else {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.modifierMenuPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.modifierMenuPanel.render(buffers, local, tp);
        pair = this.creditsPanel.raycast(saberPos, saberRot);
        if (pair == null) {
            local = null;
        } else {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.creditsPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.creditsPanel.render(buffers, local, tp);
    }

    private void renderDownloader() {
        Vector3f saberPos = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberPos : this.controller.logic.leftSaberPos;
        Quaternionf saberRot = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberRotation : this.controller.logic.leftSaberRotation;
        boolean tp = this.isTriggerPressed();
        Pair<Vector3f, Vector2f> pair = this.songDownloaderMenuPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.songDownloaderMenuPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.songDownloaderMenuPanel.render(buffers, local, tp);
        pair = this.modifierMenuPanel.raycast(saberPos, saberRot);
        if (pair == null) {
            local = null;
        } else {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.modifierMenuPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.modifierMenuPanel.render(buffers, local, tp);
        pair = this.creditsPanel.raycast(saberPos, saberRot);
        if (pair == null) {
            local = null;
        } else {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.creditsPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.creditsPanel.render(buffers, local, tp);
        if (this.errorMessagePanel.shouldDisplay()) {
            pair = this.errorMessagePanel.raycast(saberPos, saberRot);
            local = null;
            if (pair != null) {
                this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.errorMessagePanel.getNormal());
                local = (Vector2f)pair.getB();
            }
            this.errorMessagePanel.render(buffers, local, tp);
        } else if (this.showKeyboard) {
            pair = this.keyboard.raycast(saberPos, saberRot);
            local = null;
            if (pair != null) {
                this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.keyboard.getNormal());
                local = (Vector2f)pair.getB();
            }
            this.keyboard.render(buffers, local, tp);
        }
    }

    private void renderEndScreen() {
        Vector3f saberPos = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberPos : this.controller.logic.leftSaberPos;
        Quaternionf saberRot = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberRotation : this.controller.logic.leftSaberRotation;
        Pair<Vector3f, Vector2f> pair = this.endScreenPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.endScreenPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.endScreenPanel.render(buffers, local, this.isTriggerPressed());
    }

    private void renderConfirmSongDelete() {
        if (this.confirmSongDeleteMenuPanel == null) {
            return;
        }
        Vector3f saberPos = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberPos : this.controller.logic.leftSaberPos;
        Quaternionf saberRot = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberRotation : this.controller.logic.leftSaberRotation;
        Pair<Vector3f, Vector2f> pair = this.confirmSongDeleteMenuPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.confirmSongDeleteMenuPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.confirmSongDeleteMenuPanel.render(buffers, local, this.isTriggerPressed());
    }

    private void renderPauseScreen() {
        Vector3f saberPos = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberPos : this.controller.logic.leftSaberPos;
        Quaternionf saberRot = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberRotation : this.controller.logic.leftSaberRotation;
        Pair<Vector3f, Vector2f> pair = this.pauseScreenPanel.raycast(saberPos, saberRot);
        Vector2f local = null;
        if (pair != null) {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.pauseScreenPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.pauseScreenPanel.render(buffers, local, this.isTriggerPressed());
    }

    private void renderSaberPreviewScreen() {
        Vector2f local;
        Quaternionf saberRot;
        Vector3f saberPos = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberPos : this.controller.logic.leftSaberPos;
        Pair<Vector3f, Vector2f> pair = this.modifierMenuPanel.raycast(saberPos, saberRot = this.pointerSaber == NoteType.BLUE ? this.controller.logic.rightSaberRotation : this.controller.logic.leftSaberRotation);
        if (pair == null) {
            local = null;
        } else {
            this.spawnMenuPointerParticle((Vector3f)pair.getA(), this.modifierMenuPanel.getNormal());
            local = (Vector2f)pair.getB();
        }
        this.modifierMenuPanel.render(buffers, local, this.isTriggerPressed());
    }

    private void spawnMenuPointerParticle(Vector3f position, Vector3f normal) {
        BeatcraftParticleRenderer.addParticle(new MenuPointerParticle(position.add((Vector3fc)normal.mul(0.01f, new Vector3f()), new Vector3f()), normal));
    }

    private void renderRank(PoseStack matrices, Font textRenderer, BufferBuilder buffer, Vector3f cameraPos) {
        String rank = this.controller.logic.getRank().toString();
        int w = textRenderer.width(rank);
        matrices.pushPose();
        matrices.scale(2.0f, 2.0f, 2.0f);
        textRenderer.drawInBatch((Component)Component.literal((String)rank), (float)(-w) / 2.0f, 12.0f, -1, false, matrices.last().pose(), (MultiBufferSource)buffers, TEXT_LAYER, 0, 255);
        matrices.popPose();
    }

    private void renderCombo(PoseStack matrices, Font textRenderer, BufferBuilder buffer, Vector3f cameraPos) {
        MutableComponent txt = Component.translatable((String)"hud.beatcraft.combo");
        int w = textRenderer.width(txt.getString());
        textRenderer.drawInBatch((Component)txt, (float)(-w) / 2.0f, -28.0f, -1, false, matrices.last().pose(), (MultiBufferSource)buffers, TEXT_LAYER, 0, 255);
        matrices.pushPose();
        matrices.translate(0.0f, -31.0f, 0.0f);
        Vector3f topLine = matrices.last().pose().getTranslation(new Vector3f());
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(0.0f, -4.0f, 0.0f);
        Vector3f bottomLine = matrices.last().pose().getTranslation(new Vector3f());
        matrices.popPose();
        float op = Easing.easeInExpo(this.controller.logic.getComboBarOpacity());
        if (op > 0.0f) {
            float width = 0.5f * (1.0f / op);
            float height = 0.05f;
            int color = 0xFFFFFF + ((int)(255.0f * op) << 24);
            Matrix4f pose = new Matrix4f((Matrix4fc)matrices.last().pose());
            pose.scale(-32.0f);
            Vector3f worldOrigin = new Vector3f(0.0f, 0.0f, 0.0f).mulPosition((Matrix4fc)pose, new Vector3f());
            Vector3f worldXPoint = new Vector3f(width, 0.0f, 0.0f).mulPosition((Matrix4fc)pose, new Vector3f());
            Vector3f worldYPoint = new Vector3f(0.0f, height, 0.0f).mulPosition((Matrix4fc)pose, new Vector3f());
            Vector3f worldXdir = worldXPoint.sub((Vector3fc)worldOrigin, new Vector3f());
            Vector3f worldYdir = worldYPoint.sub((Vector3fc)worldOrigin, new Vector3f());
            Vector3f tl0 = new Vector3f((Vector3fc)topLine).add((Vector3fc)worldXdir);
            Vector3f tl1 = new Vector3f((Vector3fc)topLine).add((Vector3fc)worldXdir).add((Vector3fc)worldYdir);
            Vector3f tl2 = new Vector3f((Vector3fc)topLine).add((Vector3fc)new Vector3f((Vector3fc)worldXdir).negate()).add((Vector3fc)worldYdir);
            Vector3f tl3 = new Vector3f((Vector3fc)topLine).add((Vector3fc)new Vector3f((Vector3fc)worldXdir).negate());
            buffer.addVertex(tl0.x, tl0.y, tl0.z).setColor(color);
            buffer.addVertex(tl1.x, tl1.y, tl1.z).setColor(color);
            buffer.addVertex(tl2.x, tl2.y, tl2.z).setColor(color);
            buffer.addVertex(tl3.x, tl3.y, tl3.z).setColor(color);
            Vector3f bl0 = new Vector3f((Vector3fc)bottomLine).add((Vector3fc)worldXdir);
            Vector3f bl1 = new Vector3f((Vector3fc)bottomLine).add((Vector3fc)worldXdir).add((Vector3fc)worldYdir);
            Vector3f bl2 = new Vector3f((Vector3fc)bottomLine).add((Vector3fc)new Vector3f((Vector3fc)worldXdir).negate()).add((Vector3fc)worldYdir);
            Vector3f bl3 = new Vector3f((Vector3fc)bottomLine).add((Vector3fc)new Vector3f((Vector3fc)worldXdir).negate());
            buffer.addVertex(bl0.x, bl0.y, bl0.z).setColor(color);
            buffer.addVertex(bl1.x, bl1.y, bl1.z).setColor(color);
            buffer.addVertex(bl2.x, bl2.y, bl2.z).setColor(color);
            buffer.addVertex(bl3.x, bl3.y, bl3.z).setColor(color);
        }
        matrices.pushPose();
        matrices.scale(1.5f, 1.5f, 1.5f);
        String combo = String.valueOf(this.controller.logic.getCombo());
        w = textRenderer.width(combo);
        textRenderer.drawInBatch((Component)Component.literal((String)combo), (float)(-w) / 2.0f, -12.0f, -1, false, matrices.last().pose(), (MultiBufferSource)buffers, TEXT_LAYER, 0, 255);
        matrices.popPose();
    }

    private void renderScore(PoseStack matrices, Font textRenderer, BufferBuilder buffer, Vector3f cameraPos) {
        String score = String.valueOf(this.controller.logic.getScore());
        int w = textRenderer.width(score);
        matrices.pushPose();
        matrices.scale(1.2f, 1.2f, 1.2f);
        textRenderer.drawInBatch((Component)Component.literal((String)score), (float)(-w) / 2.0f, 2.0f, -1, false, matrices.last().pose(), (MultiBufferSource)buffers, TEXT_LAYER, 0, 255);
        matrices.popPose();
    }

    private void renderAccuracy(PoseStack matrices, Font textRenderer, BufferBuilder buffer, Vector3f cameraPos) {
        String accuracy = String.format("%.1f", Float.valueOf(this.controller.logic.getAccuracy() * 100.0f)) + "%";
        int w = textRenderer.width(accuracy);
        matrices.pushPose();
        matrices.scale(0.8f, 0.8f, 0.8f);
        textRenderer.drawInBatch((Component)Component.literal((String)accuracy), (float)(-w) / 2.0f, 18.0f, -1, false, matrices.last().pose(), (MultiBufferSource)buffers, TEXT_LAYER, 0, 255);
        matrices.popPose();
    }

    public void drawArc(Matrix4f pose, Vector3f center, Vector3f[] innerArc, BufferBuilder buffer, int color) {
        for (int i = 0; i < innerArc.length - 1; ++i) {
            Vector3f a = new Vector3f((Vector3fc)innerArc[i]);
            Vector3f b = new Vector3f((Vector3fc)innerArc[i + 1]);
            Vector3f c = a.sub((Vector3fc)center, new Vector3f()).normalize().mul(0.05f).add((Vector3fc)a);
            Vector3f d = b.sub((Vector3fc)center, new Vector3f()).normalize().mul(0.05f).add((Vector3fc)b);
            a.mulPosition((Matrix4fc)pose);
            b.mulPosition((Matrix4fc)pose);
            c.mulPosition((Matrix4fc)pose);
            d.mulPosition((Matrix4fc)pose);
            buffer.addVertex(a.x, a.y, a.z).setColor(color);
            buffer.addVertex(b.x, b.y, b.z).setColor(color);
            buffer.addVertex(d.x, d.y, d.z).setColor(color);
            buffer.addVertex(c.x, c.y, c.z).setColor(color);
        }
    }

    private void renderModifier(PoseStack matrices, Font textRenderer, BufferBuilder buffer, Vector3f cameraPos) {
        Vector3f[] arcPoints;
        String mod = String.valueOf((int)this.controller.logic.getBonusModifier());
        textRenderer.drawInBatch((Component)Component.literal((String)"x"), -8.5f, -20.0f, -1, false, matrices.last().pose(), (MultiBufferSource)buffers, TEXT_LAYER, 0, 255);
        matrices.pushPose();
        matrices.scale(2.5f, 2.5f, 2.5f);
        textRenderer.drawInBatch((Component)Component.literal((String)mod), -1.0f, -8.0f, -1, false, matrices.last().pose(), (MultiBufferSource)buffers, TEXT_LAYER, 0, 255);
        matrices.popPose();
        Matrix4f pose = new Matrix4f((Matrix4fc)matrices.last().pose());
        pose.scale(-32.0f);
        Vector3f centerLocal = new Vector3f(0.0f, 0.375f, 0.0f);
        Vector3f normalLocal = new Vector3f(0.0f, 0.0f, 1.0f);
        float radius = 0.5f;
        float circleProgress = this.controller.logic.getModifierPercentage();
        if (circleProgress > 0.0f) {
            arcPoints = MathUtil.generateCircle(normalLocal, radius, 2 + (int)(circleProgress * 20.0f), centerLocal, 360.0f * circleProgress, 180.0f);
            this.drawArc(pose, centerLocal, arcPoints, buffer, -1);
        }
        if (circleProgress < 1.0f) {
            arcPoints = MathUtil.generateCircle(normalLocal, radius, 2 + (int)((1.0f - circleProgress) * 20.0f), centerLocal, 360.0f * (1.0f - circleProgress), 180.0f + 360.0f * circleProgress);
            this.drawArc(pose, centerLocal, arcPoints, buffer, 0x7F7F7F7F);
        }
    }

    private void renderTime(PoseStack matrices, Font textRenderer, BufferBuilder buffer, Vector3f cameraPos) {
        float songDuration = 0.0f;
        if (this.controller.info != null) {
            songDuration = this.controller.info.getSongDuration();
        }
        float t = this.controller.currentSeconds;
        String currentTime = MathUtil.timeToString((int)t);
        String length = MathUtil.timeToString((int)songDuration);
        float progress = MathUtil.inverseLerp(0.0f, songDuration, t);
        if (progress > 1.0f && this.controller.info != null) {
            this.controller.logic.triggerSongEnd();
        }
        if (!this.showHUD || this.controller.isModifierActive("Zen Mode")) {
            return;
        }
        String display = currentTime + " | " + length;
        int w = textRenderer.width(display);
        Vector3f leftLocal = new Vector3f(0.65f, -0.4f, 0.0f);
        Vector3f rightLocal = new Vector3f(-0.65f, -0.4f, 0.0f);
        Vector3f midLocal = MathUtil.lerpVector3(leftLocal, rightLocal, progress);
        float height = 0.05f;
        Matrix4f pose = new Matrix4f((Matrix4fc)matrices.last().pose());
        pose.scale(-32.0f);
        Vector3f leftPos = leftLocal.mulPosition((Matrix4fc)pose, new Vector3f());
        Vector3f rightPos = rightLocal.mulPosition((Matrix4fc)pose, new Vector3f());
        Vector3f midPos = midLocal.mulPosition((Matrix4fc)pose, new Vector3f());
        Vector3f worldOrigin = new Vector3f(0.0f, 0.0f, 0.0f).mulPosition((Matrix4fc)pose, new Vector3f());
        Vector3f worldYdir = new Vector3f(0.0f, height, 0.0f).mulPosition((Matrix4fc)pose, new Vector3f()).sub((Vector3fc)worldOrigin);
        buffer.addVertex(leftPos.x, leftPos.y, leftPos.z).setColor(-1);
        buffer.addVertex(leftPos.x + worldYdir.x, leftPos.y + worldYdir.y, leftPos.z + worldYdir.z).setColor(-1);
        buffer.addVertex(midPos.x + worldYdir.x, midPos.y + worldYdir.y, midPos.z + worldYdir.z).setColor(-1);
        buffer.addVertex(midPos.x, midPos.y, midPos.z).setColor(-1);
        buffer.addVertex(midPos.x, midPos.y, midPos.z).setColor(0x7F7F7F7F);
        buffer.addVertex(midPos.x + worldYdir.x, midPos.y + worldYdir.y, midPos.z + worldYdir.z).setColor(0x7F7F7F7F);
        buffer.addVertex(rightPos.x + worldYdir.x, rightPos.y + worldYdir.y, rightPos.z + worldYdir.z).setColor(0x7F7F7F7F);
        buffer.addVertex(rightPos.x, rightPos.y, rightPos.z).setColor(0x7F7F7F7F);
        matrices.pushPose();
        matrices.scale(0.5f, 0.5f, 0.5f);
        textRenderer.drawInBatch((Component)Component.literal((String)display), (float)(-w) / 2.0f, 32.0f, -1, false, matrices.last().pose(), (MultiBufferSource)buffers, TEXT_LAYER, 0, 255);
        matrices.popPose();
    }

    private void renderPlayerHealth(PoseStack matrices, Font textRenderer, Vector3f cameraPos) {
        float progress = this.controller.logic.getHealthPercentage();
        switch (BeatcraftClient.playerConfig.preferences.healthStyle()) {
            case Classic: {
                Tesselator tesselator = Tesselator.getInstance();
                BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
                Matrix4f pose = new Matrix4f((Matrix4fc)matrices.last().pose());
                pose.scale(-32.0f);
                Vector3f leftLocal = new Vector3f(1.35f, 0.0f, 0.0f);
                Vector3f rightLocal = new Vector3f(-1.35f, 0.0f, 0.0f);
                Vector3f leftPos = leftLocal.mulPosition((Matrix4fc)pose, new Vector3f());
                Vector3f rightPos = rightLocal.mulPosition((Matrix4fc)pose, new Vector3f());
                Vector3f midPos = MathUtil.lerpVector3(leftPos, rightPos, progress);
                buffer.addVertex(leftPos.x, leftPos.y, leftPos.z).setColor(-1);
                buffer.addVertex(leftPos.x, leftPos.y + 0.05f, leftPos.z).setColor(-1);
                buffer.addVertex(midPos.x, midPos.y + 0.05f, midPos.z).setColor(-1);
                buffer.addVertex(midPos.x, midPos.y, midPos.z).setColor(-1);
                buffer.addVertex(midPos.x, midPos.y, midPos.z).setColor(0x7F7F7F7F);
                buffer.addVertex(midPos.x, midPos.y + 0.05f, midPos.z).setColor(0x7F7F7F7F);
                buffer.addVertex(rightPos.x, rightPos.y + 0.05f, rightPos.z).setColor(0x7F7F7F7F);
                buffer.addVertex(rightPos.x, rightPos.y, rightPos.z).setColor(0x7F7F7F7F);
                MeshData buff = buffer.build();
                if (buff == null) {
                    return;
                }
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableCull();
                RenderSystem.enableDepthTest();
                buff.sortQuads(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), VertexSorting.DISTANCE_TO_ORIGIN);
                BufferUploader.drawWithShader((MeshData)buff);
                RenderSystem.disableDepthTest();
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
                break;
            }
            case Hearts: {
                MeshData buff;
                int maxHp = this.controller.logic.maxHealth;
                float hp = this.controller.logic.health;
                Matrix4f pose = new Matrix4f((Matrix4fc)matrices.last().pose());
                pose.scale(-32.0f);
                Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f).mulPosition((Matrix4fc)pose, new Vector3f());
                BufferBuilder heart_buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
                boolean doShaking = false;
                boolean inWall = this.controller.isInWall;
                switch (maxHp) {
                    case 1: {
                        doShaking = true;
                        if (hp != 1.0f) break;
                        this.drawHeart(heart_buffer, pose, 0, 1, 1.0f, inWall);
                        break;
                    }
                    case 4: {
                        int i;
                        if (hp <= 2.0f) {
                            doShaking = true;
                        }
                        for (i = 0; i < 4; ++i) {
                            this.drawHeart(heart_buffer, pose, i, 4, progress, inWall);
                        }
                        break;
                    }
                    default: {
                        int i;
                        if (progress <= 0.275f) {
                            doShaking = true;
                        }
                        for (i = 0; i < 10; ++i) {
                            this.drawHeart(heart_buffer, pose, i, 10, progress, inWall);
                        }
                    }
                }
                if ((buff = heart_buffer.build()) == null) break;
                RenderSystem.setShader(() -> BeatcraftRenderer.heartHealthShader);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.heartsTexture);
                BeatcraftRenderer.heartHealthShader.safeGetUniform("DoShaking").set(doShaking ? 1.0f : 0.0f);
                BeatcraftRenderer.heartHealthShader.safeGetUniform("GameTime").set((float)System.nanoTime() / 1.0E9f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableCull();
                RenderSystem.enableDepthTest();
                BufferUploader.drawWithShader((MeshData)buff);
                RenderSystem.disableDepthTest();
                RenderSystem.enableCull();
                RenderSystem.disableBlend();
            }
        }
    }

    private Vector2f getHeartUV(boolean hardcore, boolean halfHeart, boolean poisoned, boolean blinking) {
        float x = hardcore ? 9.0f : 0.0f;
        float y = halfHeart ? 27.0f : 9.0f;
        return new Vector2f((x += blinking ? 18.0f : 0.0f) / 36.0f, (y += poisoned ? 9.0f : 0.0f) / 45.0f);
    }

    private void drawHeart(BufferBuilder buffer, Matrix4f pose, int heartId, int heartCount, float hpPercent, boolean poisoned) {
        float x = (float)heartId * this.HEART_SIZE.x - (float)heartCount * this.HEART_SIZE.x * 0.5f;
        Vector3f v0 = new Vector3f(-x, this.HEART_SIZE.y / 2.0f, 0.0f);
        Vector3f v1 = new Vector3f(-x, -this.HEART_SIZE.y / 2.0f, 0.0f);
        Vector3f v2 = new Vector3f(-x - this.HEART_SIZE.x, -this.HEART_SIZE.y / 2.0f, 0.0f);
        Vector3f v3 = new Vector3f(-x - this.HEART_SIZE.x, this.HEART_SIZE.y / 2.0f, 0.0f);
        v0.mulPosition((Matrix4fc)pose);
        v1.mulPosition((Matrix4fc)pose);
        v2.mulPosition((Matrix4fc)pose);
        v3.mulPosition((Matrix4fc)pose);
        float filled = hpPercent * (float)heartCount * 2.0f - (float)heartId * 2.0f;
        Vector2f uv = filled <= 0.0f ? this.emptyHeartUV : this.getHeartUV(heartCount <= 4, filled <= 1.0f, poisoned, false);
        buffer.addVertex(v0).setUv(uv.x, uv.y).setColor(heartId, 0, 0, 0);
        buffer.addVertex(v1).setUv(uv.x, uv.y + 0.2f).setColor(heartId, 0, 0, 0);
        buffer.addVertex(v2).setUv(uv.x + 0.25f, uv.y + 0.2f).setColor(heartId, 0, 0, 0);
        buffer.addVertex(v3).setUv(uv.x + 0.25f, uv.y).setColor(heartId, 0, 0, 0);
    }

    static {
        TEXT_LAYER = Font.DisplayMode.NORMAL;
    }

    public static enum MenuScene {
        InGame,
        SongSelect,
        MainMenu,
        Settings,
        Downloader,
        EndScreen,
        ConfirmSongDelete,
        Paused,
        SaberPreview;

    }
}

