/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.effect;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapManager;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.effect.MirrorHandler;
import com.beatcraft.client.render.gl.GlUtil;
import com.beatcraft.client.render.instancing.lightshow.light_object.LightMesh;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL31;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.render.helpers.RenderHelper;

public class Bloomfog {
    public boolean overrideBuffer = false;
    public RenderTarget overrideFramebuffer = null;
    public TextureTarget framebuffer;
    private final ArrayList<QuadConsumer<BufferBuilder, Vector3f, Quaternionf, Boolean>> renderCalls = new ArrayList();
    private final ArrayList<QuadConsumer<BufferBuilder, Vector3f, Quaternionf, Boolean>> renderCalls2 = new ArrayList();
    private final ResourceLocation textureId = Beatcraft.id("bloomfog/main");
    private final BloomfogTex tex;
    public final TextureTarget extraBuffer;
    public final TextureTarget blurredBuffer;
    private final ResourceLocation blurredTexId = Beatcraft.id("bloomfog/blurred");
    private BloomfogTex blurredTex;
    public static ShaderInstance blurShaderUp;
    public static ShaderInstance blurShaderDown;
    public static ShaderInstance gaussianV;
    public static ShaderInstance gaussianH;
    public static ShaderInstance bloomfogLineShader;
    public static ShaderInstance bloomfogPositionColor;
    public static ShaderInstance bloomfogColorFix;
    public static ShaderInstance blueNoise;
    public static ShaderInstance backlightsPositionColorShader;
    public static ShaderInstance blitShader;
    public static ShaderInstance compositeShader;
    public static ShaderInstance bloomMaskLightShader;
    public static ShaderInstance bloomMaskLightTextureShader;
    private static final ResourceLocation blueNoiseTexture;
    public ArrayList<TriConsumer<BufferBuilder, Vector3f, Quaternionf>> bloomCalls = new ArrayList();
    public ArrayList<TriConsumer<BufferBuilder, Vector3f, Quaternionf>> noteBloomCalls = new ArrayList();
    public ArrayList<TriConsumer<BufferBuilder, Vector3f, Quaternionf>> arrowBloomCalls = new ArrayList();
    public ArrayList<TriConsumer<Vector3f, Quaternionf, Integer>> miscBloomCalls = new ArrayList();
    public static TextureTarget bloomInput;
    private static TextureTarget bloomSwap;
    public static TextureTarget bloomOutput;
    public static TextureTarget lightDepth;
    private static float radius;
    private static final int LAYERS = 10;
    private ResourceLocation[] pyramidTexIds = new ResourceLocation[10];
    private TextureTarget[] pyramidBuffers = new TextureTarget[10];
    private TextureTarget[] pyramidBuffers2 = new TextureTarget[10];
    private BloomfogTex[] pyramidTextures = new BloomfogTex[10];
    private static int arrowShaderProgram;
    private static Bloomfog INSTANCE;
    public static boolean bloomfog_resize;
    private float layers = 1.0f;
    private Quaternionf invCameraRotation = new Quaternionf();
    private int[] lastSize = new int[]{1, 1};
    private int secondaryBindTex = 0;
    public static int sceneDepthBuffer;

    public static void initShaders() {
        try {
            blurShaderUp = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "bloomfog_upsample", DefaultVertexFormat.POSITION_TEX_COLOR);
            blurShaderDown = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "bloomfog_downsample", DefaultVertexFormat.POSITION_TEX_COLOR);
            gaussianV = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "gaussian_v", DefaultVertexFormat.POSITION_TEX_COLOR);
            gaussianH = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "gaussian_h", DefaultVertexFormat.POSITION_TEX_COLOR);
            blueNoise = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "blue_noise", DefaultVertexFormat.POSITION_TEX_COLOR);
            blitShader = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "beatcraft_blit", DefaultVertexFormat.POSITION_TEX_COLOR);
            compositeShader = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "composite", DefaultVertexFormat.POSITION_TEX_COLOR);
            bloomfogPositionColor = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "col_bloomfog", DefaultVertexFormat.POSITION_COLOR);
            backlightsPositionColorShader = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "backlights_position_color", DefaultVertexFormat.POSITION_COLOR);
            bloomfogLineShader = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "bloomfog_lines", DefaultVertexFormat.POSITION_COLOR_NORMAL);
            bloomfogColorFix = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "bloomfog_colorfix", DefaultVertexFormat.POSITION_TEX_COLOR_NORMAL);
            bloomMaskLightShader = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "position_color_bloom_mask", DefaultVertexFormat.POSITION_COLOR);
            bloomMaskLightTextureShader = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "position_color_texture_bloom_mask", DefaultVertexFormat.POSITION_TEX_COLOR);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static float[] getFogHeights(Vector3f position) {
        return BeatmapManager.getAverageFogHeight(position);
    }

    public Bloomfog(boolean initMirror) {
        if (initMirror) {
            MirrorHandler.init();
        }
        if (!initMirror) {
            Bloomfog.initShaders();
        }
        this.framebuffer = new TextureTarget(1920, 1080, true, Minecraft.ON_OSX);
        this.blurredBuffer = new TextureTarget(1920, 1080, true, Minecraft.ON_OSX);
        this.extraBuffer = new TextureTarget(1920, 1080, true, Minecraft.ON_OSX);
        bloomInput = new TextureTarget(1920, 1080, true, Minecraft.ON_OSX);
        bloomSwap = new TextureTarget(1920, 1080, true, Minecraft.ON_OSX);
        bloomOutput = new TextureTarget(1920, 1080, true, Minecraft.ON_OSX);
        lightDepth = new TextureTarget(1920, 1080, true, Minecraft.ON_OSX);
        this.tex = new BloomfogTex(this.framebuffer);
        this.blurredTex = new BloomfogTex(this.blurredBuffer);
        TextureManager texManager = Minecraft.getInstance().getTextureManager();
        texManager.register(this.textureId, (AbstractTexture)this.tex);
        texManager.register(this.blurredTexId, (AbstractTexture)this.blurredTex);
        for (int i = 0; i < 10; ++i) {
            this.pyramidBuffers[i] = new TextureTarget(512, 512, false, Minecraft.ON_OSX);
            this.pyramidBuffers2[i] = new TextureTarget(512, 512, false, Minecraft.ON_OSX);
        }
        LightMesh.buildMeshes();
    }

    public static Bloomfog create() {
        if (INSTANCE == null) {
            INSTANCE = new Bloomfog(true);
        }
        return INSTANCE;
    }

    public void resize(int width, int height, boolean resizeMirror) {
        bloomfog_resize = true;
        this.framebuffer.resize(width * 2, height * 2, Minecraft.ON_OSX);
        this.blurredBuffer.resize(width * 2, height * 2, Minecraft.ON_OSX);
        this.extraBuffer.resize(width * 2, height * 2, Minecraft.ON_OSX);
        bloomInput.resize(width, height, Minecraft.ON_OSX);
        bloomSwap.resize(width, height, Minecraft.ON_OSX);
        bloomOutput.resize(width, height, Minecraft.ON_OSX);
        lightDepth.resize(width, height, Minecraft.ON_OSX);
        this.layers = 7.0f;
        float mod = 2.0f;
        int l = 0;
        while ((float)l < this.layers) {
            if ((int)((float)width / mod) > 0 && (int)((float)height / mod) > 0) {
                this.pyramidBuffers[l].resize((int)((float)(width * 2) / mod), (int)((float)(height * 2) / mod), Minecraft.ON_OSX);
                this.pyramidBuffers2[l].resize((int)((float)(width * 2) / mod), (int)((float)(height * 2) / mod), Minecraft.ON_OSX);
            }
            mod *= 2.0f;
            ++l;
        }
        if (resizeMirror) {
            MirrorHandler.resize();
        }
        bloomfog_resize = false;
    }

    public void unload() {
        Minecraft.getInstance().getTextureManager().release(this.textureId);
        this.framebuffer.destroyBuffers();
    }

    public int getTexture() {
        return this.framebuffer.getColorTextureId();
    }

    public ResourceLocation getId() {
        return this.blurredTexId;
    }

    public void record(QuadConsumer<BufferBuilder, Vector3f, Quaternionf, Boolean> call) {
        this.renderCalls.add(call);
    }

    public static float calculateRoll(Vector3f up, Vector3f left) {
        return (float)Math.atan2(left.y, up.y);
    }

    public void render(boolean isMirror, float tickDelta) {
        float f;
        Minecraft client = Minecraft.getInstance();
        Window window = client.getWindow();
        int width = window.getWidth();
        int height = window.getHeight();
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vector3f cameraPos = camera.getPosition().toVector3f();
        if (ClientDataHolderVR.getInstance().vr != null) {
            Matrix4f rotationMatrix = RenderHelper.getVRModelView((RenderPass)ClientDataHolderVR.getInstance().currentPass);
            this.invCameraRotation = rotationMatrix.getUnnormalizedRotation(new Quaternionf());
        } else {
            this.invCameraRotation = camera.rotation().conjugate(new Quaternionf());
            float pitch = camera.getXRot();
            Vector3f up = camera.getUpVector();
            Vector3f left = camera.getLeftVector();
            f = Math.abs(pitch) >= 90.0f ? 0.0f : Bloomfog.calculateRoll(up, left);
            Quaternionf rollQuat = new Quaternionf().rotationAxis(f, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f));
            rollQuat.mul((Quaternionfc)this.invCameraRotation, this.invCameraRotation);
        }
        if (!BeatcraftClient.playerConfig.quality.doBloomfog()) {
            return;
        }
        this.framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.framebuffer.clear(Minecraft.ON_OSX);
        if (width != this.lastSize[0] || height != this.lastSize[1]) {
            this.lastSize = new int[]{Math.max(1, width), Math.max(1, height)};
            this.resize(Math.max(1, width), Math.max(1, height), true);
        }
        Minecraft.getInstance().getMainRenderTarget().unbindWrite();
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = this.framebuffer;
        this.framebuffer.bindWrite(true);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (QuadConsumer quadConsumer : this.renderCalls) {
            quadConsumer.accept(buffer, cameraPos, this.invCameraRotation, false);
        }
        this.renderCalls.clear();
        MeshData buff = buffer.build();
        if (buff != null) {
            RenderSystem.setShader(() -> bloomfogLineShader);
            RenderSystem.lineWidth((float)((float)window.getWidth() / 225.0f));
            BufferUploader.drawWithShader((MeshData)buff);
        }
        LightMesh.renderAllBloomfog();
        this.framebuffer.unbindWrite();
        BeatcraftRenderer.bloomfog.overrideBuffer = isMirror;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = isMirror ? this.overrideFramebuffer : null;
        MirrorHandler.invCameraRotation = this.invCameraRotation;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        this.applyPyramidBlur(isMirror);
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
        RenderSystem.depthMask((boolean)false);
        buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        f = 0.0f;
        buffer.addVertex(-2.0f, -2.0f, f).setUv(0.0f, 0.0f);
        buffer.addVertex(2.0f, -2.0f, f).setUv(1.0f, 0.0f);
        buffer.addVertex(2.0f, 2.0f, f).setUv(1.0f, 1.0f);
        buffer.addVertex(-2.0f, 2.0f, f).setUv(0.0f, 1.0f);
        Matrix4f oldProjMat = RenderSystem.getProjectionMatrix();
        VertexSorting oldVertexSort = RenderSystem.getVertexSorting();
        Matrix4f orthoMatrix = new Matrix4f().ortho(0.0f, (float)width, (float)height, 0.0f, -1000.0f, 1000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)orthoMatrix, (VertexSorting)VertexSorting.DISTANCE_TO_ORIGIN);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.blurredTexId);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.setProjectionMatrix((Matrix4f)oldProjMat, (VertexSorting)oldVertexSort);
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
    }

    public void loadTex() {
        RenderSystem.setShaderTexture((int)0, (int)this.blurredBuffer.getColorTextureId());
    }

    public void loadTexSecondary() {
        RenderSystem.setShaderTexture((int)1, (int)this.blurredBuffer.getColorTextureId());
    }

    public int getBloomfogColorAttachment() {
        return this.blurredBuffer.getColorTextureId();
    }

    private void applyPyramidBlur(boolean isMirror) {
        TextureTarget current = this.framebuffer;
        int l = 0;
        while ((float)l < this.layers) {
            this.applyEffectPass(isMirror, (RenderTarget)current, (RenderTarget)this.pyramidBuffers[l], PassType.DOWNSAMPLE, true);
            current = this.pyramidBuffers[l];
            ++l;
        }
        this.applyEffectPass(isMirror, (RenderTarget)current, (RenderTarget)this.extraBuffer, PassType.UPSAMPLE, true);
        this.applyEffectPass(isMirror, (RenderTarget)this.extraBuffer, (RenderTarget)this.framebuffer, PassType.GAUSSIAN_V, true);
        this.applyEffectPass(isMirror, (RenderTarget)this.framebuffer, (RenderTarget)this.extraBuffer, PassType.GAUSSIAN_H, true);
        this.applyEffectPass(isMirror, (RenderTarget)this.extraBuffer, (RenderTarget)this.blurredBuffer, PassType.BLUE_NOISE, false);
    }

    private void applyEffectPass(boolean isMirror, RenderTarget in, RenderTarget out, PassType pass) {
        this.applyEffectPass(isMirror, in, out, pass, false);
    }

    private void applyEffectPass(boolean isMirror, RenderTarget in, RenderTarget out, PassType pass, boolean overrideSampleMode) {
        out.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        out.clear(Minecraft.ON_OSX);
        out.bindWrite(true);
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = out;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float w = Minecraft.getInstance().getWindow().getWidth();
        float h = Minecraft.getInstance().getWindow().getHeight();
        RenderSystem.setShaderTexture((int)0, (int)in.getColorTextureId());
        ShaderInstance shader = switch (pass.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> blurShaderDown;
            case 1 -> blurShaderUp;
            case 2 -> gaussianV;
            case 3 -> gaussianH;
            case 4 -> blueNoise;
            case 5 -> blitShader;
            case 6 -> compositeShader;
        };
        RenderSystem.setShader(() -> shader);
        GlUtil.useProgram(shader.getId());
        GlUtil.setTex(shader.getId(), "Sampler0", 0, in.getColorTextureId());
        if (overrideSampleMode) {
            GL31.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL31.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL31.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL31.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (pass == PassType.BLUE_NOISE) {
            RenderSystem.setShaderTexture((int)1, (ResourceLocation)blueNoiseTexture);
            shader.safeGetUniform("texelSize").set(512.0f / w, 512.0f / h);
        } else if (pass == PassType.COMP) {
            shader.setSampler("Sampler1", (Object)this.secondaryBindTex);
            RenderSystem.setShaderTexture((int)1, (int)this.secondaryBindTex);
        } else {
            shader.safeGetUniform("texelSize").set(radius / w, radius / h);
        }
        RenderSystem.enableBlend();
        float z = 0.0f;
        buffer.addVertex(new Vector3f(-1.0f, -1.0f, z)).setUv(0.0f, 0.0f).setColor(-16645632);
        buffer.addVertex(new Vector3f(1.0f, -1.0f, z)).setUv(1.0f, 0.0f).setColor(-16645632);
        buffer.addVertex(new Vector3f(1.0f, 1.0f, z)).setUv(1.0f, 1.0f).setColor(-16645632);
        buffer.addVertex(new Vector3f(-1.0f, 1.0f, z)).setUv(0.0f, 1.0f).setColor(-16645632);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        out.unbindWrite();
        BeatcraftRenderer.bloomfog.overrideBuffer = isMirror;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = isMirror ? this.overrideFramebuffer : null;
    }

    public void recordBloomCall(TriConsumer<BufferBuilder, Vector3f, Quaternionf> call) {
        if (!BeatcraftClient.playerConfig.quality.doBloom()) {
            return;
        }
        this.bloomCalls.add(call);
    }

    public void recordMiscBloomCall(TriConsumer<Vector3f, Quaternionf, Integer> call) {
        if (!BeatcraftClient.playerConfig.quality.doBloom()) {
            return;
        }
        this.miscBloomCalls.add(call);
    }

    public void recordNoteBloomCall(TriConsumer<BufferBuilder, Vector3f, Quaternionf> call) {
        if (!BeatcraftClient.playerConfig.quality.doBloom()) {
            return;
        }
        this.noteBloomCalls.add(call);
    }

    public void recordArrowBloomCall(TriConsumer<BufferBuilder, Vector3f, Quaternionf> call) {
        if (!BeatcraftClient.playerConfig.quality.doBloom()) {
            return;
        }
        this.arrowBloomCalls.add(call);
    }

    public void renderBloom() {
        if (!BeatcraftClient.playerConfig.quality.doBloom()) {
            this.bloomCalls.clear();
            this.noteBloomCalls.clear();
            this.arrowBloomCalls.clear();
            this.miscBloomCalls.clear();
            MeshLoader.COLOR_NOTE_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.CHAIN_HEAD_NOTE_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.CHAIN_LINK_NOTE_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.BOMB_NOTE_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.NOTE_ARROW_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.NOTE_DOT_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.CHAIN_DOT_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.HEADSET_INSTANCED_MESH.cancelBloomCalls();
            LightMesh.cancelBloomDraws();
            bloomOutput.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            bloomOutput.clear(Minecraft.ON_OSX);
            Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
            return;
        }
        Matrix4f old = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        RenderSystem.getModelViewMatrix().identity();
        RenderSystem.disableCull();
        sceneDepthBuffer = Minecraft.getInstance().getMainRenderTarget().getDepthTextureId();
        Minecraft.getInstance().getMainRenderTarget().unbindWrite();
        Minecraft.getInstance().getMainRenderTarget().bindRead();
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = bloomInput;
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        bloomInput.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        bloomInput.clear(Minecraft.ON_OSX);
        bloomInput.bindWrite(true);
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.getInstance();
        Window window = Minecraft.getInstance().getWindow();
        int width = window.getWidth();
        int height = window.getHeight();
        Vector3f cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        for (TriConsumer<BufferBuilder, Vector3f, Quaternionf> call : this.bloomCalls) {
            call.accept((Object)buffer, (Object)cameraPos, (Object)this.invCameraRotation);
        }
        this.bloomCalls.clear();
        MeshData buff = buffer.build();
        RenderSystem.disableDepthTest();
        if (buff != null) {
            Matrix4f worldTransform = new Matrix4f();
            worldTransform.translate((Vector3fc)cameraPos);
            worldTransform.rotate((Quaternionfc)this.invCameraRotation.conjugate(new Quaternionf()));
            RenderSystem.setShader(() -> bloomMaskLightShader);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShaderTexture((int)0, (int)sceneDepthBuffer);
            bloomMaskLightShader.setSampler("Sampler0", (Object)sceneDepthBuffer);
            bloomMaskLightShader.safeGetUniform("WorldTransform").set(worldTransform);
            bloomMaskLightShader.safeGetUniform("u_fog").set(Bloomfog.getFogHeights(cameraPos));
            BufferUploader.drawWithShader((MeshData)buff);
            RenderSystem.enableDepthTest();
        }
        buffer = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (TriConsumer triConsumer : this.noteBloomCalls) {
            triConsumer.accept((Object)buffer, (Object)cameraPos, (Object)this.invCameraRotation);
        }
        this.noteBloomCalls.clear();
        buff = buffer.build();
        if (buff != null) {
            RenderSystem.setShader(() -> bloomMaskLightTextureShader);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MeshLoader.NOTE_TEXTURE);
            RenderSystem.setShaderTexture((int)1, (int)sceneDepthBuffer);
            bloomMaskLightShader.setSampler("Sampler1", (Object)sceneDepthBuffer);
            bloomMaskLightShader.safeGetUniform("u_fog").set(Bloomfog.getFogHeights(cameraPos));
            BufferUploader.drawWithShader((MeshData)buff);
            RenderSystem.enableDepthTest();
        }
        buffer = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (TriConsumer triConsumer : this.arrowBloomCalls) {
            triConsumer.accept((Object)buffer, (Object)cameraPos, (Object)this.invCameraRotation);
        }
        this.arrowBloomCalls.clear();
        buff = buffer.build();
        if (buff != null) {
            RenderSystem.setShader(() -> bloomMaskLightTextureShader);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)MeshLoader.ARROW_TEXTURE);
            RenderSystem.setShaderTexture((int)1, (int)sceneDepthBuffer);
            bloomMaskLightShader.setSampler("Sampler1", (Object)sceneDepthBuffer);
            bloomMaskLightShader.safeGetUniform("u_fog").set(Bloomfog.getFogHeights(cameraPos));
            BufferUploader.drawWithShader((MeshData)buff);
            RenderSystem.enableDepthTest();
        }
        for (TriConsumer triConsumer : this.miscBloomCalls) {
            triConsumer.accept((Object)cameraPos, (Object)this.invCameraRotation, (Object)sceneDepthBuffer);
        }
        this.miscBloomCalls.clear();
        MeshLoader.COLOR_NOTE_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.CHAIN_HEAD_NOTE_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.CHAIN_LINK_NOTE_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.BOMB_NOTE_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.NOTE_ARROW_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.NOTE_DOT_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.CHAIN_DOT_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.HEADSET_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        LightMesh.renderAllBloom(sceneDepthBuffer);
        bloomInput.unbindWrite();
        BeatcraftRenderer.bloomfog.overrideBuffer = false;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = null;
        Minecraft.getInstance().getMainRenderTarget().unbindRead();
        float r = radius;
        radius = 3.25f;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        this.applyEffectPass(false, (RenderTarget)bloomInput, (RenderTarget)bloomSwap, PassType.GAUSSIAN_H, true);
        this.applyEffectPass(false, (RenderTarget)bloomSwap, (RenderTarget)bloomOutput, PassType.GAUSSIAN_V, true);
        radius = r;
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
        RenderSystem.depthMask((boolean)false);
        buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float f = 0.0f;
        buffer.addVertex(new Vector3f(-1.0f, -1.0f, f)).setUv(0.0f, 0.0f).setColor(-16645632);
        buffer.addVertex(new Vector3f(1.0f, -1.0f, f)).setUv(1.0f, 0.0f).setColor(-16645632);
        buffer.addVertex(new Vector3f(1.0f, 1.0f, f)).setUv(1.0f, 1.0f).setColor(-16645632);
        buffer.addVertex(new Vector3f(-1.0f, 1.0f, f)).setUv(0.0f, 1.0f).setColor(-16645632);
        RenderSystem.setShader(() -> blitShader);
        RenderSystem.setShaderTexture((int)0, (int)bloomOutput.getColorTextureId());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        Matrix4f oldProjMat = RenderSystem.getProjectionMatrix();
        VertexSorting oldVertexSort = RenderSystem.getVertexSorting();
        Matrix4f orthoMatrix = new Matrix4f().ortho(0.0f, (float)width, (float)height, 0.0f, -1000.0f, 1000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)orthoMatrix, (VertexSorting)VertexSorting.DISTANCE_TO_ORIGIN);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.setProjectionMatrix((Matrix4f)oldProjMat, (VertexSorting)oldVertexSort);
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.getModelViewMatrix().set((Matrix4fc)old);
    }

    static {
        blueNoiseTexture = Beatcraft.id("textures/noise/blue_noise.png");
        radius = 11.0f;
        arrowShaderProgram = 0;
        INSTANCE = null;
        bloomfog_resize = false;
    }

    public static class BloomfogTex
    extends AbstractTexture {
        private final TextureTarget buffer;

        protected BloomfogTex(TextureTarget buffer) {
            this.buffer = buffer;
        }

        public int getId() {
            return this.buffer.getColorTextureId();
        }

        public void load(ResourceManager manager) throws IOException {
        }
    }

    @FunctionalInterface
    public static interface QuadConsumer<T, U, S, V> {
        public void accept(T var1, U var2, S var3, V var4);
    }

    private static enum PassType {
        DOWNSAMPLE,
        UPSAMPLE,
        GAUSSIAN_V,
        GAUSSIAN_H,
        BLUE_NOISE,
        BLIT,
        COMP;

    }
}

