/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.effect;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.instancing.lightshow.light_object.LightMesh;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.beatcraft.common.memory.MemoryPool;
import com.beatcraft.mixin_utils.BufferBuilderAccessor;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MirrorHandler {
    private final BeatmapController mapController;
    private static final ArrayList<MirrorHandler> mirrors = new ArrayList();
    public static Quaternionf invCameraRotation = new Quaternionf();
    private static final ArrayList<BiConsumer<BufferBuilder, Vector3f>> plainMirrorCalls = new ArrayList();
    private final ArrayList<TriConsumer<BufferBuilder, Vector3f, Quaternionf>> drawCalls = new ArrayList();
    private final ArrayList<Bloomfog.QuadConsumer<BufferBuilder, Vector3f, Quaternionf, Boolean>> mirrorDraws = new ArrayList();
    private final ArrayList<BiConsumer<BufferBuilder, Vector3f>> mirrorNotes = new ArrayList();
    private final ArrayList<BiConsumer<BufferBuilder, Vector3f>> mirrorArrows = new ArrayList();
    private final ArrayList<BiConsumer<BufferBuilder, Vector3f>> mirrorWallGlows = new ArrayList();
    private final ArrayList<Runnable> earlyCalls = new ArrayList();
    private final ArrayList<TriConsumer<BufferBuilder, Vector3f, Integer>> obstacleRenderCalls = new ArrayList();
    public static TextureTarget mirrorFramebuffer;
    public static TextureTarget depthFramebuffer;
    public static ShaderInstance mirrorShader;
    public static ShaderInstance mirrorPositionColorClip;

    public static void init() {
        Window window = Minecraft.getInstance().getWindow();
        mirrorFramebuffer = new TextureTarget(window.getWidth(), window.getHeight(), true, Minecraft.ON_OSX);
        depthFramebuffer = new TextureTarget(window.getWidth(), window.getHeight(), true, Minecraft.ON_OSX);
        try {
            mirrorShader = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "light_mirror", DefaultVertexFormat.POSITION_COLOR);
            mirrorPositionColorClip = new ShaderInstance((ResourceProvider)Minecraft.getInstance().getResourceManager(), "position_color_clip", DefaultVertexFormat.POSITION_COLOR);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MirrorHandler(BeatmapController map) {
        this.mapController = map;
        mirrors.add(this);
    }

    public static void resize() {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        Window window = Minecraft.getInstance().getWindow();
        mirrorFramebuffer.resize(Math.max(1, window.getWidth()), Math.max(1, window.getHeight()), Minecraft.ON_OSX);
        depthFramebuffer.resize(Math.max(1, window.getWidth()), Math.max(1, window.getHeight()), Minecraft.ON_OSX);
    }

    public void recordMirrorLightDraw(Bloomfog.QuadConsumer<BufferBuilder, Vector3f, Quaternionf, Boolean> call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.mirrorDraws.add(call);
    }

    public void recordMirrorNoteDraw(BiConsumer<BufferBuilder, Vector3f> call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.mirrorNotes.add(call);
    }

    public void recordMirrorArrowDraw(BiConsumer<BufferBuilder, Vector3f> call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.mirrorArrows.add(call);
    }

    public void recordMirrorLaserRenderCall(BiConsumer<BufferBuilder, Vector3f> call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.mirrorWallGlows.add(call);
    }

    public void recordEarlyRenderCall(Runnable call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.earlyCalls.add(call);
    }

    public void recordCall(TriConsumer<BufferBuilder, Vector3f, Quaternionf> call) {
        this.drawCalls.add(call);
    }

    public void recordPlainCall(BiConsumer<BufferBuilder, Vector3f> call) {
        plainMirrorCalls.add(call);
    }

    public void recordMirroredObstacleRenderCall(TriConsumer<BufferBuilder, Vector3f, Integer> call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.obstacleRenderCalls.add(call);
    }

    private void renderEarly(Tesselator tesselator, Vector3f cameraPos) {
        for (Runnable call : this.earlyCalls) {
            call.run();
        }
        this.earlyCalls.clear();
    }

    private void renderObstacles(Tesselator tesselator, Vector3f cameraPos) {
        if (this.mapController == null) {
            this.obstacleRenderCalls.clear();
            return;
        }
        int color = this.mapController.difficulty.getSetDifficulty().getColorScheme().getObstacleColor().toARGB(0.15f);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (TriConsumer<BufferBuilder, Vector3f, Integer> call : this.obstacleRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos, (Object)color);
        }
        this.obstacleRenderCalls.clear();
        MeshData buff = buffer.build();
        if (buff != null) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            buff.sortQuads(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), VertexSorting.DISTANCE_TO_ORIGIN);
            BufferUploader.drawWithShader((MeshData)buff);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }
    }

    private void renderNotes(Tesselator tesselator, Vector3f cameraPos) {
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        Quaternionf q = MemoryPool.newQuaternionf();
        MeshLoader.MIRROR_COLOR_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_CHAIN_HEAD_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_CHAIN_LINK_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_BOMB_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_NOTE_ARROW_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_NOTE_DOT_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_CHAIN_DOT_INSTANCED_MESH.render(cameraPos);
        MemoryPool.releaseSafe(q);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
    }

    private void renderNotes0(Tesselator tesselator, Vector3f cameraPos) {
        BufferBuilder triBuffer = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX_COLOR);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        int oldTexture = RenderSystem.getShaderTexture((int)0);
        RenderSystem.setShader(() -> BeatcraftRenderer.noteShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MeshLoader.NOTE_TEXTURE);
        for (BiConsumer<BufferBuilder, Vector3f> renderCall : this.mirrorNotes) {
            try {
                renderCall.accept(triBuffer, cameraPos);
            }
            catch (Exception e) {
                Beatcraft.LOGGER.error("Render call failed! ", (Throwable)e);
            }
        }
        MeshData triBuff = triBuffer.build();
        if (triBuff != null) {
            BufferUploader.drawWithShader((MeshData)triBuff);
        }
        triBuffer = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX_COLOR);
        RenderSystem.setShader(() -> BeatcraftRenderer.arrowShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MeshLoader.ARROW_TEXTURE);
        for (BiConsumer<BufferBuilder, Vector3f> renderCall : this.mirrorArrows) {
            try {
                renderCall.accept(triBuffer, cameraPos);
            }
            catch (Exception e) {
                Beatcraft.LOGGER.error("Render call failed! ", (Throwable)e);
            }
        }
        triBuff = triBuffer.build();
        if (triBuff != null) {
            BufferUploader.drawWithShader((MeshData)triBuff);
        }
        RenderSystem.setShaderTexture((int)0, (int)oldTexture);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        this.mirrorNotes.clear();
        this.mirrorArrows.clear();
    }

    private void renderFloorLights(Tesselator tesselator, Vector3f cameraPos) {
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (BiConsumer<BufferBuilder, Vector3f> call : this.mirrorWallGlows) {
            call.accept(buffer, cameraPos);
        }
        this.mirrorWallGlows.clear();
        MeshData buff = buffer.build();
        if (buff == null) {
            return;
        }
        buff.sortQuads(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), VertexSorting.DISTANCE_TO_ORIGIN);
        BufferUploader.drawWithShader((MeshData)buff);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private void renderForDepth(Tesselator tesselator, Vector3f cameraPos) {
        depthFramebuffer.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        depthFramebuffer.clear(Minecraft.ON_OSX);
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = depthFramebuffer;
        depthFramebuffer.bindWrite(true);
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (TriConsumer<BufferBuilder, Vector3f, Quaternionf> call : this.drawCalls) {
            call.accept((Object)buffer, (Object)cameraPos, (Object)invCameraRotation.conjugate(new Quaternionf()));
        }
        MeshData buff = buffer.build();
        if (buff != null) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            BufferUploader.drawWithShader((MeshData)buff);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
        }
        BeatcraftRenderer.bloomfog.overrideFramebuffer = null;
        BeatcraftRenderer.bloomfog.overrideBuffer = false;
        depthFramebuffer.unbindWrite();
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
    }

    public void drawMirror() {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Vector3f cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        Matrix4f worldTransform = new Matrix4f();
        worldTransform.translate((Vector3fc)cameraPos);
        Quaternionf q = MemoryPool.newQuaternionf(invCameraRotation).conjugate();
        worldTransform.rotate((Quaternionfc)q);
        if (BeatcraftClient.playerConfig.quality.doMirror()) {
            this.renderForDepth(tesselator, cameraPos);
        }
        for (BiConsumer<BufferBuilder, Vector3f> biConsumer : plainMirrorCalls) {
            biConsumer.accept(buffer, cameraPos);
        }
        plainMirrorCalls.clear();
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            q.set((Quaternionfc)invCameraRotation);
            q.conjugate();
            for (TriConsumer triConsumer : this.drawCalls) {
                triConsumer.accept((Object)buffer, (Object)cameraPos, (Object)q);
            }
            this.drawCalls.clear();
        }
        MemoryPool.releaseSafe(q);
        MeshData buff = buffer.build();
        if (buff != null) {
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(() -> Bloomfog.bloomfogPositionColor);
            Bloomfog.bloomfogPositionColor.safeGetUniform("WorldTransform").set(worldTransform);
            Bloomfog.bloomfogPositionColor.safeGetUniform("u_fog").set(Bloomfog.getFogHeights(cameraPos));
            BeatcraftRenderer.bloomfog.loadTex();
            BufferUploader.drawWithShader((MeshData)buff);
            RenderSystem.enableCull();
        }
        mirrorFramebuffer.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        mirrorFramebuffer.clear(Minecraft.ON_OSX);
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            this.earlyCalls.clear();
            this.mirrorDraws.clear();
            this.mirrorNotes.clear();
            this.mirrorArrows.clear();
            this.mirrorWallGlows.clear();
            this.obstacleRenderCalls.clear();
            MeshLoader.MIRROR_COLOR_NOTE_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_CHAIN_HEAD_NOTE_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_CHAIN_LINK_NOTE_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_BOMB_NOTE_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_NOTE_ARROW_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_NOTE_DOT_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_CHAIN_DOT_INSTANCED_MESH.cancelDraws();
            LightMesh.cancelMirrorDraws();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
            return;
        }
        Minecraft.getInstance().getMainRenderTarget().unbindWrite();
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = mirrorFramebuffer;
        mirrorFramebuffer.bindWrite(true);
        this.renderEarly(tesselator, cameraPos);
        buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (Bloomfog.QuadConsumer<BufferBuilder, Vector3f, Quaternionf, Boolean> quadConsumer : this.mirrorDraws) {
            quadConsumer.accept(buffer, cameraPos, new Quaternionf(), true);
        }
        this.mirrorDraws.clear();
        buff = buffer.build();
        if (buff != null) {
            RenderSystem.setShader(() -> mirrorPositionColorClip);
            RenderSystem.setShaderTexture((int)0, (int)depthFramebuffer.getDepthTextureId());
            mirrorPositionColorClip.setSampler("Sampler0", (Object)depthFramebuffer.getDepthTextureId());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableCull();
            BufferUploader.drawWithShader((MeshData)buff);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableCull();
        }
        this.renderNotes(tesselator, cameraPos);
        this.renderFloorLights(tesselator, cameraPos);
        this.renderObstacles(tesselator, cameraPos);
        LightMesh.renderAllMirror();
        BeatcraftRenderer.bloomfog.overrideFramebuffer = null;
        BeatcraftRenderer.bloomfog.overrideBuffer = false;
        mirrorFramebuffer.unbindWrite();
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
        buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (TriConsumer<BufferBuilder, Vector3f, Quaternionf> triConsumer : this.drawCalls) {
            triConsumer.accept((Object)buffer, (Object)cameraPos, (Object)invCameraRotation.conjugate(new Quaternionf()));
        }
        this.drawCalls.clear();
        buff = buffer.build();
        if (buff != null) {
            RenderSystem.setShader(() -> mirrorShader);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderTexture((int)0, (int)mirrorFramebuffer.getColorTextureId());
            mirrorShader.setSampler("Sampler0", (Object)mirrorFramebuffer.getColorTextureId());
            RenderSystem.setShaderTexture((int)1, (int)mirrorFramebuffer.getDepthTextureId());
            mirrorShader.setSampler("Sampler1", (Object)mirrorFramebuffer.getDepthTextureId());
            RenderSystem.setShaderTexture((int)2, (int)BeatcraftRenderer.bloomfog.blurredBuffer.getColorTextureId());
            mirrorShader.setSampler("Sampler2", (Object)BeatcraftRenderer.bloomfog.blurredBuffer.getColorTextureId());
            mirrorShader.safeGetUniform("WorldPos").set(cameraPos);
            mirrorShader.safeGetUniform("GameTime").set(BeatcraftClient.random.nextFloat());
            BufferUploader.drawWithShader((MeshData)buff);
            RenderSystem.depthMask((boolean)false);
        }
    }
}

