/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.effect;

import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapManager;
import com.beatcraft.client.logic.PhysicsTransform;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.HUDRenderer;
import com.beatcraft.common.data.ControllerProfile;
import com.beatcraft.common.data.components.ModComponents;
import com.beatcraft.common.data.types.CycleStack;
import com.beatcraft.common.items.ModItems;
import com.beatcraft.common.items.data.ItemStackWithSaberTrailStack;
import com.beatcraft.common.replay.PlayFrame;
import com.beatcraft.mixin_utils.BufferBuilderAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

public class SaberRenderer {
    public static final HashMap<UUID, PlayFrame> otherPlayerSabers = new HashMap();
    private static final ArrayList<Function<BufferBuilder, Void>> render_calls = new ArrayList();

    private static void renderOtherPlayerSabers() {
        otherPlayerSabers.forEach((uuid, playFrame) -> {
            ClientLevel world = Minecraft.getInstance().level;
            if (world == null) {
                return;
            }
            Player player = world.getPlayerByUUID(uuid);
            if (player == null) {
                return;
            }
            ItemStack stack = player.getMainHandItem();
            ItemStack stack2 = player.getOffhandItem();
            if (player.getMainArm() == HumanoidArm.LEFT) {
                ItemStack s3 = stack;
                stack = stack2;
                stack2 = s3;
            }
            if (stack.is(ModItems.SABER_ITEM)) {
                SaberRenderer.renderReplaySaber(stack, playFrame.rightSaberPosition(), playFrame.rightSaberRotation());
            }
            if (stack2.is(ModItems.SABER_ITEM)) {
                SaberRenderer.renderReplaySaber(stack2, playFrame.leftSaberPosition(), playFrame.leftSaberRotation());
            }
        });
    }

    public static void renderReplaySaber(ItemStack item, Vector3f position, Quaternionf orientation) {
        SaberRenderer.renderReplayTrail(item, position, orientation);
        PoseStack matrices = new PoseStack();
        Vector3f cam = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        matrices.translate(-cam.x, -cam.y, -cam.z);
        matrices.translate(position.x, position.y, position.z);
        matrices.mulPose(orientation);
        matrices.scale(0.3333f, 0.3333f, 0.3333f);
        BeatcraftRenderer.recordSaberRenderCall(() -> Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, 255, 0, matrices, (MultiBufferSource)HUDRenderer.buffers, (Level)Minecraft.getInstance().level, 0));
    }

    public static void renderSaber(ItemStack item, PoseStack matrices, MultiBufferSource vertexConsumerProvider, InteractionHand hand, AbstractClientPlayer player, float tickDelta) {
        matrices.pushPose();
        Vector3f worldPos = matrices.last().pose().getTranslation(new Vector3f());
        Quaternionf worldRotation = matrices.last().pose().getNormalizedRotation(new Quaternionf());
        SaberRenderer.renderTrail(true, matrices, hand.equals((Object)InteractionHand.MAIN_HAND), player, tickDelta, item);
        Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, 255, 0, matrices, vertexConsumerProvider, null, 0);
        UUID uuid = player.getUUID();
        if (!BeatcraftClient.controllerTransforms.containsKey(uuid)) {
            BeatcraftClient.controllerTransforms.put(uuid, (Triplet<PhysicsTransform, PhysicsTransform, PhysicsTransform>)new Triplet((Object)new PhysicsTransform(-0.4f, 0.0f, 0.0f), (Object)new PhysicsTransform(0.0f, 0.0f, 0.0f), (Object)new PhysicsTransform(0.4f, 0.0f, 0.0f)));
        }
        boolean isRightHanded = player.getMainArm() == HumanoidArm.RIGHT;
        InteractionHand right = isRightHanded ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        Triplet<PhysicsTransform, PhysicsTransform, PhysicsTransform> sabers = BeatcraftClient.controllerTransforms.get(uuid);
        Vector3f camPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        Matrix4f mat = new Matrix4f().translate((Vector3fc)camPos).mul((Matrix4fc)matrices.last().pose());
        if (hand == right) {
            ((PhysicsTransform)sabers.getC()).update(mat);
        } else {
            ((PhysicsTransform)sabers.getA()).update(mat);
        }
        matrices.popPose();
    }

    public static void renderReplayTrail(ItemStack stack, Vector3f basePos, Quaternionf rotation) {
        Vector3f hiltPos = new Vector3f(0.0f, 0.175f, 0.0f).rotate((Quaternionfc)rotation).add((Vector3fc)basePos);
        Vector3f tipPos = new Vector3f(0.0f, 1.025f, 0.0f).rotate((Quaternionfc)rotation).add((Vector3fc)basePos);
        CycleStack<Pair<Vector3f, Vector3f>> cycleStack = ((ItemStackWithSaberTrailStack)stack).beatcraft$getTrailStash(ClientDataHolderVR.getInstance().currentPass);
        int sync = (Integer)stack.getOrDefault((DataComponentType)ModComponents.AUTO_SYNC_COLOR.get(), (Object)-1);
        int color = sync == -1 || !BeatmapManager.hasNearbyActiveBeatmap(basePos) ? (Integer)stack.getOrDefault((DataComponentType)ModComponents.SABER_COLOR_COMPONENT.get(), (Object)0) + -16777216 : (sync == 0 ? BeatmapManager.nearestActiveBeatmap((Vector3f)basePos).difficulty.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB() : BeatmapManager.nearestActiveBeatmap((Vector3f)basePos).difficulty.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB());
        SaberRenderer.queueRender(hiltPos, tipPos, cycleStack, color);
    }

    public static void renderTrail(boolean doCollisionCheck, PoseStack matrix, boolean mainHand, AbstractClientPlayer player, float tickDelta, ItemStack stack) {
        if (stack.is(ModItems.SABER_ITEM)) {
            Quaternionf rotation;
            Vector3f translation;
            matrix.scale(0.3333f, 0.3333f, 0.3333f);
            matrix.translate(0.0, -0.25, 0.35);
            matrix.mulPose(new Quaternionf().rotationXYZ(-0.7853982f, 0.0f, 0.0f));
            ControllerProfile profile = BeatcraftClient.playerConfig.controller.activeProfile();
            if (player.getMainArm() == HumanoidArm.RIGHT && mainHand || player.getMainArm() == HumanoidArm.LEFT && !mainHand) {
                translation = profile.getRightTranslation();
                rotation = profile.getRightRotation();
                boolean rightHand = true;
            } else {
                translation = profile.getLeftTranslation();
                rotation = profile.getLeftRotation();
                boolean rightHand = false;
            }
            matrix.translate(translation.x, translation.y, translation.z);
            matrix.mulPose(rotation);
            if (doCollisionCheck) {
                matrix.pushPose();
                matrix.translate(0.0, 0.525, 0.0);
                Vector3f blade_base = matrix.last().pose().getTranslation(new Vector3f());
                matrix.popPose();
                matrix.pushPose();
                matrix.translate(0.0, 3.0749999999999997, 0.0);
                Vector3f blade_tip = matrix.last().pose().getTranslation(new Vector3f());
                matrix.popPose();
                Vector3f playerPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
                blade_tip.add((Vector3fc)playerPos);
                blade_base.add((Vector3fc)playerPos);
                CycleStack<Pair<Vector3f, Vector3f>> stash = ((ItemStackWithSaberTrailStack)stack).beatcraft$getTrailStash(ClientDataHolderVR.getInstance().currentPass);
                int sync = (Integer)stack.getOrDefault((DataComponentType)ModComponents.AUTO_SYNC_COLOR.get(), (Object)-1);
                int color = sync == -1 || !BeatmapManager.hasNearbyActiveBeatmap(blade_base) ? (Integer)stack.getOrDefault((DataComponentType)ModComponents.SABER_COLOR_COMPONENT.get(), (Object)0) + -16777216 : (sync == 0 ? BeatmapManager.nearestActiveBeatmap((Vector3f)blade_base).difficulty.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB() : BeatmapManager.nearestActiveBeatmap((Vector3f)blade_base).difficulty.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB());
                if (stash != null) {
                    SaberRenderer.queueRender(blade_base, blade_tip, stash, color);
                }
            }
        }
    }

    public static void renderItemEntityTrail(ItemEntity entity, float tickDelta, BakedModel bakedModel) {
        ItemStack stack = entity.getItem();
        if (stack.is(ModItems.SABER_ITEM)) {
            PoseStack matrix = new PoseStack();
            float j = Mth.sin((float)(((float)entity.getAge() + tickDelta) / 10.0f + entity.bobOffs)) * 0.1f + 0.1f;
            float k = bakedModel.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
            matrix.translate(0.0f, j + 0.25f * k, 0.0f);
            float l = entity.getSpin(tickDelta);
            matrix.mulPose(new Quaternionf().rotateAxis(l, 0.0f, 1.0f, 0.0f));
            matrix.pushPose();
            bakedModel.getTransforms().getTransform(ItemDisplayContext.GROUND).apply(false, matrix);
            matrix.pushPose();
            matrix.translate(0.0, 1.05, 0.0);
            Vector3f blade_base = matrix.last().pose().getTranslation(new Vector3f());
            matrix.popPose();
            matrix.pushPose();
            matrix.translate(0.0, 3.0749999999999997, 0.0);
            Vector3f blade_tip = matrix.last().pose().getTranslation(new Vector3f());
            matrix.popPose();
            Vector3f pos = entity.getPosition(tickDelta).toVector3f();
            blade_base.add((Vector3fc)pos);
            blade_tip.add((Vector3fc)pos);
            CycleStack<Pair<Vector3f, Vector3f>> stash = ((ItemStackWithSaberTrailStack)stack).beatcraft$getTrailStash(ClientDataHolderVR.getInstance().currentPass);
            int sync = (Integer)stack.getOrDefault((DataComponentType)ModComponents.AUTO_SYNC_COLOR.get(), (Object)-1);
            int color = sync == -1 || !BeatmapManager.hasNearbyActiveBeatmap(blade_base) ? (Integer)stack.getOrDefault((DataComponentType)ModComponents.SABER_COLOR_COMPONENT.get(), (Object)0) + -16777216 : (sync == 0 ? BeatmapManager.nearestActiveBeatmap((Vector3f)blade_base).difficulty.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB() : BeatmapManager.nearestActiveBeatmap((Vector3f)blade_base).difficulty.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB());
            if (stash != null) {
                SaberRenderer.queueRender(blade_base, blade_tip, stash, color);
            }
        }
    }

    public static void queueRender(Vector3f blade_base, Vector3f blade_tip, CycleStack<Pair<Vector3f, Vector3f>> cycleStack, int col) {
        Function<BufferBuilder, Void> callable = trail_buffer -> {
            SaberRenderer.render(blade_base, blade_tip, cycleStack, col, trail_buffer);
            return null;
        };
        render_calls.add(callable);
    }

    public static void renderAll() {
        SaberRenderer.renderOtherPlayerSabers();
        if (render_calls.isEmpty()) {
            return;
        }
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder trail_buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (Function<BufferBuilder, Void> runnable : render_calls) {
            runnable.apply(trail_buffer);
        }
        MeshData buffer = trail_buffer.build();
        render_calls.clear();
        if (buffer != null) {
            buffer.sortQuads(((BufferBuilderAccessor)trail_buffer).beatcraft$getAllocator(), VertexSorting.ORTHOGRAPHIC_Z);
            BufferUploader.drawWithShader((MeshData)buffer);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
    }

    public static void render(Vector3f blade_base, Vector3f blade_tip, CycleStack<Pair<Vector3f, Vector3f>> cycleStack, int col, BufferBuilder trail_buffer) {
        if (cycleStack.getSize() <= 3) {
            return;
        }
        Vector3f current_base = blade_base;
        Vector3f current_tip = blade_tip;
        Vec3 cam = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        if (!cycleStack.isEmpty()) {
            int opacity = 0;
            float step = 127.0f / (float)cycleStack.getSize();
            for (Pair<Vector3f, Vector3f> ab : cycleStack) {
                Vector3f a = (Vector3f)ab.getA();
                Vector3f b = (Vector3f)ab.getB();
                int op = 127 - (int)(step * (float)opacity) << 24;
                int op2 = 127 - (int)(step * (float)(opacity + 1)) << 24;
                ++opacity;
                if (op == 0 || op2 == 0) continue;
                trail_buffer.addVertex((float)((double)current_base.x - cam.x), (float)((double)current_base.y - cam.y), (float)((double)current_base.z - cam.z)).setColor(col + op);
                trail_buffer.addVertex((float)((double)a.x - cam.x), (float)((double)a.y - cam.y), (float)((double)a.z - cam.z)).setColor(col + op2);
                trail_buffer.addVertex((float)((double)b.x - cam.x), (float)((double)b.y - cam.y), (float)((double)b.z - cam.z)).setColor(col + op2);
                trail_buffer.addVertex((float)((double)current_tip.x - cam.x), (float)((double)current_tip.y - cam.y), (float)((double)current_tip.z - cam.z)).setColor(col + op);
                current_base = a;
                current_tip = b;
            }
        }
        cycleStack.push((Pair<Vector3f, Vector3f>)new Pair((Object)blade_base, (Object)blade_tip));
    }
}

