/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.instancing;

import com.beatcraft.client.render.gl.GlUtil;
import com.beatcraft.client.render.instancing.ArrowInstanceData;
import com.beatcraft.client.render.instancing.DrawPass;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.memory.MemoryPool;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.system.MemoryUtil;
import oshi.util.tuples.Triplet;

public class InstancedMesh<I extends InstanceData> {
    private static final ArrayList<InstancedMesh<? extends InstanceData>> meshes = new ArrayList();
    public static final int FLOAT_SIZE_BYTES = 4;
    public static final int VECTOR3F_SIZE_BYTES = 12;
    public static final int VECTOR2F_SIZE_BYTES = 8;
    public static final int MATRIX4F_SIZE_BYTES = 64;
    public static final int VEC4_SIZE_BYTES = 16;
    private static final int POSITION_LOCATION = 0;
    private static final int TEXCOORD_LOCATION = 1;
    private static final int NORMAL_LOCATION = 2;
    private final ResourceLocation shaderName;
    private final ResourceLocation texture;
    private final Triplet<Vector3f, Vector2f, Vector3f>[] vertices;
    private int vao;
    private int vertexVbo;
    private int uvVbo;
    private int normalVbo;
    private int instanceVbo;
    private int indicesVbo;
    private int[] indices;
    private final int vertexCount;
    private int instanceCount;
    private int shaderProgram;
    private final ArrayList<I> instanceDataList;
    private final ArrayList<I> bloomCopyCalls;
    private boolean initialized;
    public static boolean isQuest3 = false;
    private ResourceLocation vertexShaderLoc;
    private ResourceLocation fragmentShaderLoc;

    public InstancedMesh(ResourceLocation shaderName, ResourceLocation texture, Triplet<Vector3f, Vector2f, Vector3f>[] vertices) {
        this.shaderName = shaderName;
        this.texture = texture;
        this.vertices = vertices;
        this.vertexCount = vertices.length;
        this.instanceDataList = new ArrayList();
        this.bloomCopyCalls = new ArrayList();
        this.instanceCount = 0;
        this.initialized = false;
        this.generateIndices();
        meshes.add(this);
    }

    public InstancedMesh<I> copy() {
        return new InstancedMesh<I>(this.shaderName, this.texture, this.vertices);
    }

    private void generateIndices() {
        int i;
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (i = 0; i < this.vertexCount; i += 3) {
            indexList.add(i);
            indexList.add(i + 1);
            indexList.add(i + 2);
        }
        this.indices = new int[indexList.size()];
        for (i = 0; i < indexList.size(); ++i) {
            this.indices[i] = (Integer)indexList.get(i);
        }
    }

    public void init(I setupFrame) {
        if (this.initialized) {
            return;
        }
        String vendor = GL31.glGetString((int)7936);
        isQuest3 = vendor != null && vendor.contains("QuestCraft");
        this.vertexShaderLoc = ResourceLocation.tryBuild((String)this.shaderName.getNamespace(), (String)("shaders/" + this.shaderName.getPath() + ".vsh"));
        this.fragmentShaderLoc = ResourceLocation.tryBuild((String)this.shaderName.getNamespace(), (String)("shaders/" + this.shaderName.getPath() + ".fsh"));
        this.vao = GL45C.glCreateVertexArrays();
        GL30.glBindVertexArray((int)this.vao);
        this.vertexVbo = GL15.glGenBuffers();
        FloatBuffer posBuffer = MemoryUtil.memAllocFloat((int)(this.vertices.length * 3));
        for (Triplet<Vector3f, Vector2f, Vector3f> vertex : this.vertices) {
            Vector3f pos = (Vector3f)vertex.getA();
            posBuffer.put(pos.x).put(pos.y).put(pos.z);
        }
        posBuffer.flip();
        GL15.glBindBuffer((int)34962, (int)this.vertexVbo);
        GL15.glBufferData((int)34962, (FloatBuffer)posBuffer, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)0);
        MemoryUtil.memFree((Buffer)posBuffer);
        this.uvVbo = GL15.glGenBuffers();
        FloatBuffer uvBuffer = MemoryUtil.memAllocFloat((int)(this.vertices.length * 2));
        for (Triplet<Vector3f, Vector2f, Vector3f> vertex : this.vertices) {
            Vector2f uv = (Vector2f)vertex.getB();
            uvBuffer.put(uv.x).put(uv.y);
        }
        uvBuffer.flip();
        GL15.glBindBuffer((int)34962, (int)this.uvVbo);
        GL15.glBufferData((int)34962, (FloatBuffer)uvBuffer, (int)35044);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)1);
        MemoryUtil.memFree((Buffer)uvBuffer);
        this.normalVbo = GL45C.glCreateBuffers();
        FloatBuffer normalBuffer = MemoryUtil.memAllocFloat((int)(this.vertices.length * 3));
        for (Triplet<Vector3f, Vector2f, Vector3f> vertex : this.vertices) {
            Vector3f normal = (Vector3f)vertex.getC();
            normalBuffer.put(normal.x).put(normal.y).put(normal.z);
        }
        normalBuffer.flip();
        GL15.glBindBuffer((int)34962, (int)this.normalVbo);
        GL15.glBufferData((int)34962, (FloatBuffer)normalBuffer, (int)35044);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL20.glEnableVertexAttribArray((int)2);
        MemoryUtil.memFree((Buffer)normalBuffer);
        this.indicesVbo = GL15.glGenBuffers();
        IntBuffer indicesBuffer = MemoryUtil.memAllocInt((int)this.indices.length);
        indicesBuffer.put(this.indices).flip();
        GL15.glBindBuffer((int)34963, (int)this.indicesVbo);
        GL15.glBufferData((int)34963, (IntBuffer)indicesBuffer, (int)35044);
        MemoryUtil.memFree((Buffer)indicesBuffer);
        this.instanceVbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.instanceVbo);
        setupFrame.init();
        GL30.glBindVertexArray((int)0);
        GL15.glBindBuffer((int)34962, (int)0);
        this.initialized = true;
    }

    public void draw(I data) {
        this.instanceDataList.add(data);
    }

    public void copyDrawToBloom(Color color) {
        InstanceData draw = ((InstanceData)this.instanceDataList.getLast()).copy();
        if (draw instanceof ArrowInstanceData) {
            ArrowInstanceData arrowDraw = (ArrowInstanceData)draw;
            arrowDraw.setColor(color);
        }
        this.bloomCopyCalls.add(draw);
    }

    public void copyDrawToBloom() {
        this.copyDrawToBloom(null);
    }

    public void cancelDraws() {
        this.instanceDataList.clear();
        this.bloomCopyCalls.clear();
    }

    public void renderBloom(Vector3f cameraPos, Quaternionf cameraRotation) {
        this.render(cameraPos, this.bloomCopyCalls, cameraRotation, DrawPass.Bloom);
    }

    public void render(Vector3f cameraPos) {
        Quaternionf q = MemoryPool.newQuaternionf();
        this.render(cameraPos, this.instanceDataList, q, DrawPass.Normal);
        MemoryPool.releaseSafe(q);
    }

    public void cancelBloomCalls() {
        this.bloomCopyCalls.clear();
    }

    protected void render(Vector3f cameraPos, ArrayList<I> dataList, Quaternionf cameraRotation, DrawPass pass) {
        if (dataList.isEmpty()) {
            return;
        }
        InstanceData first = (InstanceData)dataList.getFirst();
        if (!this.initialized) {
            this.init(first);
        }
        int[] attrLocations = first.getLocations();
        this.instanceCount = dataList.size();
        dataList.sort((a, b) -> {
            Matrix4f ta = a.getTransform();
            Matrix4f tb = b.getTransform();
            Vector3f posA = new Vector3f(ta.m30(), ta.m31(), ta.m32());
            Vector3f posB = new Vector3f(tb.m30(), tb.m31(), tb.m32());
            float distA = posA.distanceSquared((Vector3fc)cameraPos);
            float distB = posB.distanceSquared((Vector3fc)cameraPos);
            return Float.compare(distB, distA);
        });
        IntBuffer vaoBuf = BufferUtils.createIntBuffer((int)1);
        GL11.glGetIntegerv((int)34229, (IntBuffer)vaoBuf);
        int oldVAO = vaoBuf.get(0);
        IntBuffer vboBuf = BufferUtils.createIntBuffer((int)1);
        GL11.glGetIntegerv((int)34964, (IntBuffer)vboBuf);
        int oldVBO = vboBuf.get(0);
        GL30.glBindVertexArray((int)this.vao);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)0, (int)0);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)1, (int)0);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)2, (int)0);
        for (int loc : attrLocations) {
            ARBInstancedArrays.glVertexAttribDivisorARB((int)loc, (int)1);
        }
        this.activateShaderAndTexture(cameraPos, cameraRotation);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        first.setup(this.shaderProgram, pass);
        FloatBuffer instanceDataBuffer = MemoryUtil.memAllocFloat((int)(this.instanceCount * first.getFrameSize()));
        for (InstanceData data : dataList) {
            data.putData(instanceDataBuffer);
        }
        instanceDataBuffer.flip();
        GL15.glBindBuffer((int)34962, (int)this.instanceVbo);
        GL15.glBufferData((int)34962, (FloatBuffer)instanceDataBuffer, (int)35048);
        MemoryUtil.memFree((Buffer)instanceDataBuffer);
        GL31.glDrawElementsInstanced((int)4, (int)this.indices.length, (int)5125, (long)0L, (int)this.instanceCount);
        first.cleanup();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableCull();
        GL20.glUseProgram((int)0);
        for (Object loc : (Object)attrLocations) {
            ARBInstancedArrays.glVertexAttribDivisorARB((int)loc, (int)0);
        }
        GL15.glBindBuffer((int)34962, (int)oldVBO);
        GL30.glBindVertexArray((int)oldVAO);
        dataList.forEach((Consumer<I>)((Consumer<InstanceData>)InstanceData::free));
        dataList.clear();
    }

    private void activateShaderAndTexture(Vector3f cameraPos, Quaternionf cameraRotation) {
        this.shaderProgram = GlUtil.getOrCreateShaderProgram(this.vertexShaderLoc, this.fragmentShaderLoc);
        GlUtil.useProgram(this.shaderProgram);
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        AbstractTexture abstractTexture = textureManager.getTexture(this.texture);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        RenderSystem.bindTexture((int)0);
        GlUtil.setTex(this.shaderProgram, "u_texture", 0, abstractTexture.getId());
        Matrix4f projMat = RenderSystem.getProjectionMatrix();
        Matrix4f viewMat = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix()).rotate((Quaternionfc)cameraRotation).translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        GlUtil.uniformMat4f("u_projection", projMat);
        GlUtil.uniformMat4f("u_view", viewMat);
    }

    public void cleanup() {
        GL15.glDeleteBuffers((int)this.vertexVbo);
        GL15.glDeleteBuffers((int)this.uvVbo);
        GL15.glDeleteBuffers((int)this.normalVbo);
        GL15.glDeleteBuffers((int)this.instanceVbo);
        GL15.glDeleteBuffers((int)this.indicesVbo);
        GL30.glDeleteVertexArrays((int)this.vao);
    }

    public static void cleanupAll() {
        meshes.forEach((Consumer<InstancedMesh<? extends InstanceData>>)((Consumer<InstancedMesh>)InstancedMesh::cleanup));
        meshes.clear();
    }

    public static interface InstanceData {
        public Matrix4f getTransform();

        public void putData(FloatBuffer var1);

        public int getFrameSize();

        public void init();

        public int[] getLocations();

        default public void setup(int program) {
        }

        default public void setup(int program, DrawPass pass) {
            this.setup(program);
        }

        public void cleanup();

        public void free();

        public InstanceData copy();
    }
}

