/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.instancing.lightshow.light_object;

import java.util.ArrayList;
import java.util.List;
import org.joml.Vector2i;

public class RectanglePacker {
    private final int binWidth;
    private final int binHeight;
    private final List<Shelf> shelves;

    public RectanglePacker(int width, int height) {
        this.binWidth = width;
        this.binHeight = height;
        this.shelves = new ArrayList<Shelf>();
    }

    public Vector2i pack(int width, int height) {
        Shelf newShelf;
        Vector2i result;
        if (width <= 0 || height <= 0) {
            return null;
        }
        if (width > this.binWidth || height > this.binHeight) {
            return null;
        }
        for (Shelf shelf : this.shelves) {
            result = shelf.tryPack(width, height);
            if (result == null) continue;
            return result;
        }
        int nextShelfY = this.getNextShelfY();
        if (nextShelfY + height <= this.binHeight && (result = (newShelf = new Shelf(nextShelfY, height)).tryPack(width, height)) != null) {
            this.shelves.add(newShelf);
            return result;
        }
        return null;
    }

    private int getNextShelfY() {
        if (this.shelves.isEmpty()) {
            return 0;
        }
        Shelf lastShelf = this.shelves.getLast();
        return lastShelf.y + lastShelf.height;
    }

    public double getUtilization() {
        int totalArea = this.binWidth * this.binHeight;
        int usedArea = 0;
        for (Shelf shelf : this.shelves) {
            usedArea += shelf.getUsedArea();
        }
        return (double)usedArea / (double)totalArea * 100.0;
    }

    public void clear() {
        this.shelves.clear();
    }

    public int getWidth() {
        return this.binWidth;
    }

    public int getHeight() {
        return this.binHeight;
    }

    private class Shelf {
        final int y;
        final int height;
        int currentX;

        Shelf(int y, int height) {
            this.y = y;
            this.height = height;
            this.currentX = 0;
        }

        Vector2i tryPack(int width, int height) {
            if (height <= this.height && this.currentX + width <= RectanglePacker.this.binWidth) {
                Vector2i result = new Vector2i(this.currentX, this.y);
                this.currentX += width;
                return result;
            }
            return null;
        }

        int getUsedArea() {
            return this.currentX * this.height;
        }
    }
}

