/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.item;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapManager;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.gl.GlUtil;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.beatcraft.client.render.mesh.Triangle;
import com.beatcraft.client.render.mesh.TriangleMesh;
import com.beatcraft.common.data.components.ModComponents;
import com.beatcraft.common.data.types.Color;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.File;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL32;
import org.vivecraft.client_vr.ClientDataHolderVR;

public class SaberItemRenderer {
    public static final ArrayList<SaberModel> models = new ArrayList();
    private static SaberModel active = null;
    private static SaberModel builtin = null;
    private static boolean initialized = false;

    private static void loadCustomModels() {
        String rootModelFolder = String.valueOf(Minecraft.getInstance().gameDirectory.toPath()) + "/beatcraft/custom_sabers/";
        File folder = new File(rootModelFolder);
        if (!folder.exists() && !folder.mkdirs()) {
            Beatcraft.LOGGER.error("Failed to create custom sabers folder");
            return;
        }
        File[] modelFolders = folder.listFiles(File::isDirectory);
        if (modelFolders == null) {
            Beatcraft.LOGGER.error("Failed to load custom sabers");
            return;
        }
        models.forEach(SaberModel::destroy);
        models.clear();
        for (File modelFolder : modelFolders) {
            File[] pngs = modelFolder.listFiles(f -> f.isFile() && f.getAbsolutePath().endsWith(".png"));
            File[] models = modelFolder.listFiles(f -> f.isFile() && f.getAbsolutePath().endsWith(".json"));
            if (models == null) {
                Beatcraft.LOGGER.error("No model files found in model folder. make sure models are in blockbench's java block/item json format");
                continue;
            }
            if (pngs == null) {
                Beatcraft.LOGGER.error("No image files found in model folder. check that images are valid png files");
                continue;
            }
            HashMap<String, File> textureLookup = new HashMap<String, File>();
            for (File png : pngs) {
                String name = png.getName().replaceFirst("\\.png$", "");
                textureLookup.put(name, png);
            }
            for (File modelFile : models) {
                SaberModel model = MeshLoader.loadSaberMesh(modelFile.getAbsolutePath(), textureLookup);
                if (model == null) continue;
                SaberItemRenderer.models.add(model);
            }
        }
        SaberModel legacy = MeshLoader.loadSaberMesh(Beatcraft.id("saber/legacy.json"), Beatcraft.id("textures/item/saber.png"));
        models.add(legacy);
        legacy = MeshLoader.loadSaberMesh(Beatcraft.id("saber/legacy_updated.json"), Beatcraft.id("textures/item/saber.png"));
        models.add(legacy);
    }

    public static void selectModel(String id) {
        boolean found = false;
        for (SaberModel model : models) {
            if (!model.id.equals(id)) continue;
            active = model;
            found = true;
            break;
        }
        if (!found) {
            active = builtin;
        }
        BeatcraftClient.playerConfig.preferences.selectedSaber(SaberItemRenderer.active.id);
    }

    public static void init() {
        AttributedMesh.init();
        SaberItemRenderer.loadCustomModels();
        builtin = MeshLoader.loadSaberMesh(Beatcraft.id("saber/builtin_saber.json"), Beatcraft.id("textures/item/saber.png"));
        models.add(builtin);
        SaberItemRenderer.selectModel(BeatcraftClient.playerConfig.preferences.selectedSaber());
        initialized = true;
    }

    public void render(ItemStack stack, ItemDisplayContext mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (!initialized) {
            SaberItemRenderer.init();
        }
        Vector3f cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        int sync = (Integer)stack.getOrDefault((DataComponentType)ModComponents.AUTO_SYNC_COLOR.get(), (Object)-1);
        int color = sync == -1 || !BeatmapManager.hasNearbyActiveBeatmapToPlayer() ? (Integer)stack.getOrDefault((DataComponentType)ModComponents.SABER_COLOR_COMPONENT.get(), (Object)0) + -16777216 : (sync == 0 ? BeatmapManager.nearestActiveBeatmapToPlayer().difficulty.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB() : BeatmapManager.nearestActiveBeatmapToPlayer().difficulty.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB());
        active.render(matrices.last().pose(), color, cameraPos, mode == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || mode == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || mode == ItemDisplayContext.GUI);
    }

    public static class SaberModel {
        public final String id;
        public final String modelName;
        public final List<String> authors;
        private final ArrayList<AttributedMesh> meshComponents;
        public final int performanceImpactScore;
        private final ResourceLocation texture;

        public SaberModel(String id, String modelName, List<String> authors, ArrayList<AttributedMesh> meshComponents, int performanceImpactScore, ResourceLocation texture) {
            this.id = id;
            this.modelName = modelName;
            this.authors = authors;
            this.meshComponents = meshComponents;
            this.performanceImpactScore = performanceImpactScore;
            this.texture = texture;
        }

        public void render(Matrix4f matrices, int color, Vector3f cameraPos, boolean bypassBloom) {
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX_COLOR);
            ArrayList<Runnable> afterCalls = new ArrayList<Runnable>();
            for (AttributedMesh mesh : this.meshComponents) {
                mesh.draw(matrices, color, cameraPos, buffer, afterCalls, this.texture, bypassBloom);
            }
            MeshData buff = buffer.build();
            if (buff != null) {
                RenderSystem.enableCull();
                RenderSystem.enableDepthTest();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
                RenderSystem.bindTexture((int)0);
                RenderSystem.setShader(() -> BeatcraftRenderer.BCPosTexColShader);
                BufferUploader.drawWithShader((MeshData)buff);
            }
            for (Runnable c : afterCalls) {
                try {
                    c.run();
                }
                catch (Exception e) {
                    Beatcraft.LOGGER.error("Saber Model late callback errored!", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        public void destroy() {
            this.meshComponents.forEach(AttributedMesh::destroy);
            this.meshComponents.clear();
        }
    }

    public static class AttributedMesh {
        public TriangleMesh mesh;
        private boolean swivel = false;
        private Vector3f swivelAxis;
        private final Vector3f pivot;
        private boolean spin = false;
        private Vector3f spinAxis;
        private float spinSecondsPerRev;
        private boolean doBloom = false;
        private boolean tinted = false;
        private String shader = null;
        private int shaderProgram = 0;
        private int vao = -1;
        private int vbo = -1;
        private int bloom_vao = -1;
        private int bloom_vbo = -1;
        private int bloomShaderProgram = 0;
        private String[] shaderVariables;
        private static final HashMap<String, String> shaderSources = new HashMap();
        private static final String[] sources = new String[]{"circle.fsh", "circle_bloom_mask.fsh", "vertex.vsh"};
        private static final Pattern axesPattern = Pattern.compile("(?:x(?<x>[+-]?(?:\\d+\\.\\d*|\\.\\d+|\\d+)(?:[eE][+-]?\\d+)?[fF]?)?)?(?:y(?<y>[+-]?(?:\\d+\\.\\d*|\\.\\d+|\\d+)(?:[eE][+-]?\\d+)?[fF]?)?)?(?:z(?<z>[+-]?(?:\\d+\\.\\d*|\\.\\d+|\\d+)(?:[eE][+-]?\\d+)?[fF]?)?)?");

        public static void init() {
            for (String source : sources) {
                try {
                    String src = ((Resource)Minecraft.getInstance().getResourceManager().getResource(Beatcraft.id("shaders/saber/" + source)).orElseThrow()).openAsReader().lines().filter(x -> !x.contains("REMOVELINE")).collect(Collectors.joining("\n"));
                    shaderSources.put(source, src);
                }
                catch (IOException e) {
                    Beatcraft.LOGGER.error("Could not find saber shader '{}'", (Object)source);
                    throw new RuntimeException(e);
                }
            }
        }

        private void initCustom() {
            this.vao = GL31.glGenVertexArrays();
            this.vbo = GL31.glGenBuffers();
            GL31.glBindVertexArray((int)this.vao);
            GL31.glBindBuffer((int)34962, (int)this.vbo);
            int stride = 36;
            GL31.glEnableVertexAttribArray((int)0);
            GL31.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL31.glEnableVertexAttribArray((int)1);
            GL31.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)12L);
            GL31.glEnableVertexAttribArray((int)2);
            GL31.glVertexAttribPointer((int)2, (int)4, (int)5126, (boolean)false, (int)stride, (long)20L);
            GL31.glBindVertexArray((int)0);
        }

        private void initCustomBloom() {
            this.bloom_vao = GL31.glGenVertexArrays();
            this.bloom_vbo = GL31.glGenBuffers();
            GL31.glBindVertexArray((int)this.bloom_vao);
            GL31.glBindBuffer((int)34962, (int)this.bloom_vbo);
            int stride = 36;
            GL31.glEnableVertexAttribArray((int)0);
            GL31.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
            GL31.glEnableVertexAttribArray((int)1);
            GL31.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)12L);
            GL31.glEnableVertexAttribArray((int)2);
            GL31.glVertexAttribPointer((int)2, (int)4, (int)5126, (boolean)false, (int)stride, (long)20L);
            GL31.glBindVertexArray((int)0);
        }

        public boolean matchesAttributes(AttributedMesh other) {
            return this.swivel == other.swivel && this.swivelAxis == other.swivelAxis && this.pivot == other.pivot && this.doBloom == other.doBloom && this.tinted == other.tinted && Objects.equals(this.shader, other.shader);
        }

        private static Vector3f getAxis(String in) {
            float z;
            Matcher matcher = axesPattern.matcher(in);
            float x = in.contains("x") ? 1.0f : 0.0f;
            float y = in.contains("y") ? 1.0f : 0.0f;
            float f = z = in.contains("z") ? 1.0f : 0.0f;
            if (matcher.find()) {
                String rx = matcher.group("x");
                String ry = matcher.group("y");
                String rz = matcher.group("z");
                if (rx != null) {
                    x = Float.parseFloat(rx);
                }
                if (ry != null) {
                    y = Float.parseFloat(ry);
                }
                if (rz != null) {
                    z = Float.parseFloat(rz);
                }
            }
            return new Vector3f(x, y, z).normalize();
        }

        public AttributedMesh(TriangleMesh mesh, Vector3f pivot, String attributes) {
            this.mesh = mesh;
            this.pivot = pivot;
            for (String attr : attributes.split(";")) {
                if (attr.equals("bloom")) {
                    this.doBloom = true;
                    continue;
                }
                if (attr.equals("colored")) {
                    this.tinted = true;
                    continue;
                }
                if (attr.startsWith("swivel:")) {
                    String axis = attr.replace("swivel:", "").toLowerCase();
                    this.swivelAxis = AttributedMesh.getAxis(axis);
                    this.swivel = true;
                    continue;
                }
                if (attr.startsWith("spin:")) {
                    String[] axisSpeed = attr.replace("spin:", "").toLowerCase().split(":");
                    String axis = axisSpeed[0];
                    this.spinAxis = AttributedMesh.getAxis(axis);
                    this.spinSecondsPerRev = Float.parseFloat(axisSpeed[1]);
                    this.spin = true;
                    continue;
                }
                if (!attr.startsWith("shader:") || mesh == null) continue;
                String shaderData = attr.replace("shader:", "");
                String[] nameVars = shaderData.split(":", 2);
                String shaderName = nameVars[0];
                String shaderVars = nameVars[1];
                this.shader = shaderName;
                this.shaderVariables = (String[])Arrays.stream(shaderVars.splitWithDelimiters("[a-zA-Z]+", 0)).filter(e -> !e.isBlank()).toArray(String[]::new);
                String src = shaderSources.getOrDefault(shaderName + ".fsh", null);
                String vert = shaderSources.get("vertex.vsh");
                if (src == null) {
                    Beatcraft.LOGGER.error("Saber shader name '{}' is not valid", (Object)shaderName);
                    throw new RuntimeException("Saber shader name '" + shaderName + "' is not valid");
                }
                for (int i = 0; i < this.shaderVariables.length; i += 2) {
                    String vName = this.shaderVariables[i];
                    float vVal = 0.0f;
                    try {
                        vVal = Float.parseFloat(this.shaderVariables[i + 1]);
                    }
                    catch (NumberFormatException e2) {
                        Beatcraft.LOGGER.error("Saber shader variable '{}' had non-parseable float value: '{}'", (Object)vName, (Object)this.shaderVariables[i + 1]);
                    }
                    src = src.replace("${" + vName + "}", String.valueOf(vVal));
                }
                this.shaderProgram = GlUtil.createShaderProgram(vert, src);
                this.initCustom();
            }
            if (this.shaderProgram != 0 && this.doBloom) {
                String src = shaderSources.getOrDefault(this.shader + "_bloom_mask.fsh", null);
                String vert = shaderSources.get("vertex.vsh");
                for (int i = 0; i < this.shaderVariables.length; i += 2) {
                    String vName = this.shaderVariables[i];
                    float vVal = 0.0f;
                    try {
                        vVal = Float.parseFloat(this.shaderVariables[i + 1]);
                    }
                    catch (NumberFormatException e3) {
                        Beatcraft.LOGGER.error("Saber bloom shader variable '{}' had non-parseable float value: '{}'", (Object)vName, (Object)this.shaderVariables[i + 1]);
                    }
                    src = src.replace("${" + vName + "}", String.valueOf(vVal));
                }
                this.bloomShaderProgram = GlUtil.createShaderProgram(vert, src);
                this.initCustomBloom();
            }
        }

        private void addVertex(List<Float> list, Vector3f pos, Vector2f uv, Vector4f color) {
            list.add(Float.valueOf(pos.x));
            list.add(Float.valueOf(pos.y));
            list.add(Float.valueOf(pos.z));
            list.add(Float.valueOf(uv.x));
            list.add(Float.valueOf(uv.y));
            list.add(Float.valueOf(color.x));
            list.add(Float.valueOf(color.y));
            list.add(Float.valueOf(color.z));
            list.add(Float.valueOf(color.w));
        }

        private void customRender(int c, ResourceLocation texture, Matrix4f mts, Quaternionf ori, Quaternionf cameraRot, boolean isBloom, int depthBuffer) {
            int program;
            int vVao = isBloom ? this.bloom_vao : this.vao;
            int vVbo = isBloom ? this.bloom_vbo : this.vbo;
            int n = program = isBloom ? this.bloomShaderProgram : this.shaderProgram;
            if (this.shader.equals("circle")) {
                IntBuffer vaoBuf = BufferUtils.createIntBuffer((int)1);
                GL11.glGetIntegerv((int)34229, (IntBuffer)vaoBuf);
                int oldVAO = vaoBuf.get(0);
                IntBuffer vboBuf = BufferUtils.createIntBuffer((int)1);
                GL11.glGetIntegerv((int)34964, (IntBuffer)vboBuf);
                int oldVBO = vboBuf.get(0);
                GL31.glBindVertexArray((int)vVao);
                GL31.glUseProgram((int)program);
                Matrix4f projMat = RenderSystem.getProjectionMatrix();
                Matrix4f viewMat = RenderSystem.getModelViewMatrix();
                GlUtil.setMat4f(program, "u_projection", projMat);
                GlUtil.setMat4f(program, "u_view", viewMat);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
                if (isBloom) {
                    GlUtil.setTex(program, "u_depth", 1, depthBuffer);
                }
                Color col = new Color(c);
                Vector4f vColor = new Vector4f(col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha());
                ArrayList<Float> dataList = new ArrayList<Float>();
                for (Triangle tri : this.mesh.tris) {
                    Vector3f v0 = new Vector3f((Vector3fc)this.mesh.vertices.get(tri.a()));
                    Vector3f v1 = new Vector3f((Vector3fc)this.mesh.vertices.get(tri.b()));
                    Vector3f v2 = new Vector3f((Vector3fc)this.mesh.vertices.get(tri.c()));
                    v0.sub((Vector3fc)this.pivot).rotate((Quaternionfc)ori).add((Vector3fc)this.pivot);
                    v1.sub((Vector3fc)this.pivot).rotate((Quaternionfc)ori).add((Vector3fc)this.pivot);
                    v2.sub((Vector3fc)this.pivot).rotate((Quaternionfc)ori).add((Vector3fc)this.pivot);
                    mts.transformPosition(v0);
                    mts.transformPosition(v1);
                    mts.transformPosition(v2);
                    v0.rotate((Quaternionfc)cameraRot);
                    v1.rotate((Quaternionfc)cameraRot);
                    v2.rotate((Quaternionfc)cameraRot);
                    Vector2f uv0 = tri.uvA();
                    Vector2f uv1 = tri.uvB();
                    Vector2f uv2 = tri.uvC();
                    this.addVertex(dataList, v0, uv0, vColor);
                    this.addVertex(dataList, v1, uv1, vColor);
                    this.addVertex(dataList, v2, uv2, vColor);
                }
                FloatBuffer vertexBuffer = BufferUtils.createFloatBuffer((int)dataList.size());
                Iterator iterator = dataList.iterator();
                while (iterator.hasNext()) {
                    float f = ((Float)iterator.next()).floatValue();
                    vertexBuffer.put(f);
                }
                vertexBuffer.flip();
                RenderSystem.enableCull();
                if (!isBloom) {
                    RenderSystem.enableDepthTest();
                    RenderSystem.depthMask((boolean)true);
                }
                RenderSystem.enableBlend();
                GL31.glBindBuffer((int)34962, (int)vVbo);
                GL31.glBufferData((int)34962, (FloatBuffer)vertexBuffer, (int)35048);
                GL31.glDrawArrays((int)4, (int)0, (int)(dataList.size() / 9));
                GL31.glBindBuffer((int)34962, (int)oldVBO);
                GL31.glBindVertexArray((int)oldVAO);
            }
        }

        public void draw(Matrix4f matrices, int color, Vector3f cameraPos, BufferBuilder buffer, ArrayList<Runnable> afterCalls, ResourceLocation texture, boolean bypassBloom) {
            boolean vrActive;
            int c = this.tinted ? color : -1;
            Quaternionf currentOri = matrices.getUnnormalizedRotation(new Quaternionf());
            Quaternionf orientation = new Quaternionf();
            if (this.spin) {
                double s = (double)System.nanoTime() / 1.0E9;
                double revs = s / (double)this.spinSecondsPerRev;
                float angle = (float)(revs * 2.0 * Math.PI % (Math.PI * 2));
                orientation.rotateAxis(angle, (Vector3fc)this.spinAxis);
            }
            if (this.swivel) {
                Vector3f axisWorld = new Vector3f((Vector3fc)this.swivelAxis).normalize().rotate((Quaternionfc)currentOri);
                Vector3f modelWorldPos = new Vector3f((Vector3fc)this.pivot).mulPosition((Matrix4fc)matrices);
                Vector3f toModel = new Vector3f((Vector3fc)modelWorldPos).negate();
                Vector3f projectedToModel = new Vector3f((Vector3fc)toModel).sub((Vector3fc)new Vector3f((Vector3fc)axisWorld).mul(toModel.dot((Vector3fc)axisWorld))).normalize();
                if (projectedToModel.lengthSquared() >= 1.0E-6f) {
                    orientation.identity();
                    Vector3f forwardWorld = this.swivelAxis.x == 0.0f && this.swivelAxis.y == 0.0f && this.swivelAxis.z != 0.0f ? new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)currentOri) : new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)currentOri);
                    Vector3f projectedForward = new Vector3f((Vector3fc)forwardWorld).sub((Vector3fc)new Vector3f((Vector3fc)axisWorld).mul(forwardWorld.dot((Vector3fc)axisWorld))).normalize();
                    float dot = projectedForward.dot((Vector3fc)projectedToModel);
                    dot = Math.max(-1.0f, Math.min(1.0f, dot));
                    float angle = (float)Math.acos(dot);
                    Vector3f cross = projectedForward.cross((Vector3fc)projectedToModel, new Vector3f());
                    float sign = Math.signum(cross.dot((Vector3fc)axisWorld));
                    orientation.rotateAxis(angle *= sign, (Vector3fc)this.swivelAxis);
                }
            }
            if (this.shaderProgram == 0) {
                for (Triangle tri : this.mesh.tris) {
                    Vector3f v0 = new Vector3f((Vector3fc)this.mesh.vertices.get(tri.a()));
                    Vector3f v1 = new Vector3f((Vector3fc)this.mesh.vertices.get(tri.b()));
                    Vector3f v2 = new Vector3f((Vector3fc)this.mesh.vertices.get(tri.c()));
                    v0.sub((Vector3fc)this.pivot).rotate((Quaternionfc)orientation).add((Vector3fc)this.pivot);
                    v1.sub((Vector3fc)this.pivot).rotate((Quaternionfc)orientation).add((Vector3fc)this.pivot);
                    v2.sub((Vector3fc)this.pivot).rotate((Quaternionfc)orientation).add((Vector3fc)this.pivot);
                    buffer.addVertex(matrices, v0.x, v0.y, v0.z).setUv(tri.uvA().x, tri.uvA().y).setColor(c);
                    buffer.addVertex(matrices, v1.x, v1.y, v1.z).setUv(tri.uvB().x, tri.uvB().y).setColor(c);
                    buffer.addVertex(matrices, v2.x, v2.y, v2.z).setUv(tri.uvC().x, tri.uvC().y).setColor(c);
                }
            } else {
                Matrix4f mts = new Matrix4f((Matrix4fc)matrices);
                Quaternionf ori = new Quaternionf((Quaternionfc)orientation);
                afterCalls.add(() -> this.customRender(c, texture, mts, ori, new Quaternionf(), false, 0));
            }
            boolean bl = vrActive = ClientDataHolderVR.getInstance().vr != null && ClientDataHolderVR.getInstance().vr.isActive();
            if (this.doBloom && (!bypassBloom || vrActive)) {
                Matrix4f mts = new Matrix4f((Matrix4fc)matrices);
                Quaternionf ori = new Quaternionf((Quaternionfc)orientation);
                if (this.shaderProgram == 0) {
                    BeatcraftRenderer.bloomfog.recordMiscBloomCall((TriConsumer<Vector3f, Quaternionf, Integer>)((TriConsumer)(camPos, cameraRot, depthBuffer) -> {
                        BufferBuilder b = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX_COLOR);
                        for (Triangle tri : this.mesh.tris) {
                            Vector3f v0 = new Vector3f((Vector3fc)this.mesh.vertices.get(tri.a()));
                            Vector3f v1 = new Vector3f((Vector3fc)this.mesh.vertices.get(tri.b()));
                            Vector3f v2 = new Vector3f((Vector3fc)this.mesh.vertices.get(tri.c()));
                            v0.sub((Vector3fc)this.pivot).rotate((Quaternionfc)ori).add((Vector3fc)this.pivot);
                            v1.sub((Vector3fc)this.pivot).rotate((Quaternionfc)ori).add((Vector3fc)this.pivot);
                            v2.sub((Vector3fc)this.pivot).rotate((Quaternionfc)ori).add((Vector3fc)this.pivot);
                            mts.transformPosition(v0);
                            mts.transformPosition(v1);
                            mts.transformPosition(v2);
                            v0.rotate((Quaternionfc)cameraRot);
                            v1.rotate((Quaternionfc)cameraRot);
                            v2.rotate((Quaternionfc)cameraRot);
                            b.addVertex(v0.x, v0.y, v0.z).setUv(tri.uvA().x, tri.uvA().y).setColor(c);
                            b.addVertex(v1.x, v1.y, v1.z).setUv(tri.uvB().x, tri.uvB().y).setColor(c);
                            b.addVertex(v2.x, v2.y, v2.z).setUv(tri.uvC().x, tri.uvC().y).setColor(c);
                        }
                        MeshData buff = b.build();
                        if (buff != null) {
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
                            RenderSystem.setShaderTexture((int)1, (int)depthBuffer);
                            RenderSystem.enableBlend();
                            RenderSystem.setShader(() -> Bloomfog.bloomMaskLightTextureShader);
                            BufferUploader.drawWithShader((MeshData)buff);
                        }
                    }));
                } else {
                    BeatcraftRenderer.bloomfog.recordMiscBloomCall((TriConsumer<Vector3f, Quaternionf, Integer>)((TriConsumer)(v, q, d) -> this.customRender(c, texture, mts, ori, (Quaternionf)q, true, (int)d)));
                }
            }
        }

        public void destroy() {
            if (this.shaderProgram != 0) {
                GL15.glBindBuffer((int)34962, (int)0);
                GL30.glBindVertexArray((int)0);
                GL15.glDeleteBuffers((int)this.vbo);
                GL30.glDeleteVertexArrays((int)this.vao);
                GL31.glDeleteProgram((int)this.shaderProgram);
                if (this.doBloom && this.bloomShaderProgram != 0) {
                    GL15.glBindBuffer((int)34962, (int)0);
                    GL30.glBindVertexArray((int)0);
                    GL15.glDeleteBuffers((int)this.bloom_vbo);
                    GL30.glDeleteVertexArrays((int)this.bloom_vao);
                    GL32.glDeleteProgram((int)this.bloomShaderProgram);
                }
            }
        }
    }
}

