/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.menu;

import com.beatcraft.client.menu.Menu;
import com.beatcraft.client.render.dynamic_loader.DynamicTexture;
import com.beatcraft.common.utils.MathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import oshi.util.tuples.Pair;

public abstract class MenuPanel<T extends Menu> {
    protected Vector3f position = new Vector3f();
    protected Quaternionf orientation = new Quaternionf();
    protected Vector2f size = new Vector2f();
    protected int backgroundColor = -1879048192;
    protected T data;
    protected ArrayList<Widget> widgets = new ArrayList();

    public MenuPanel(T data) {
        this.data = data;
    }

    public Pair<Vector3f, Vector2f> raycast(Vector3f position, Quaternionf orientation) {
        float wa = ((Menu)this.data).hudRenderer.controller.worldAngle;
        Vector3f wp = ((Menu)this.data).hudRenderer.controller.worldPosition;
        Pair<Vector3f, Vector2f> out = MathUtil.raycastPlane(position.sub((Vector3fc)wp, new Vector3f()).rotateY(-wa), new Quaternionf().rotationY(-wa).mul((Quaternionfc)orientation).normalize(), this.position, this.orientation, this.size.div(128.0f, new Vector2f()));
        if (out != null) {
            ((Vector3f)out.getA()).rotateY(wa).add((Vector3fc)wp);
        }
        return out;
    }

    public Vector3f getNormal() {
        return new Vector3f(0.0f, 0.0f, -1.0f).rotateY(((Menu)this.data).hudRenderer.controller.worldAngle).rotate((Quaternionfc)this.orientation);
    }

    public void render(MultiBufferSource.BufferSource immediate, @Nullable Vector2f pointerPosition, boolean triggerPressed) {
        GuiGraphics context = new GuiGraphics(Minecraft.getInstance(), immediate);
        Vector3f camPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
        context.pose().translate(-camPos.x, -camPos.y, -camPos.z);
        Vector3f wp = ((Menu)this.data).hudRenderer.controller.worldPosition;
        context.pose().translate(wp.x, wp.y, wp.z);
        context.pose().mulPose(new Quaternionf().rotationY(((Menu)this.data).hudRenderer.controller.worldAngle));
        context.pose().translate(this.position.x, this.position.y, this.position.z);
        context.pose().mulPose(this.orientation);
        context.pose().scale(0.0078125f, 0.0078125f, 0.0078125f);
        context.pose().pushPose();
        context.fill((int)(-this.size.x / 2.0f), (int)(-this.size.y / 2.0f), (int)(this.size.x / 2.0f), (int)(this.size.y / 2.0f), this.backgroundColor);
        this.widgets.forEach(w -> w.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f()), triggerPressed));
        context.flush();
        context.pose().popPose();
    }

    protected static abstract class Widget {
        protected Vector3f position = new Vector3f();
        protected Vector2f size = new Vector2f();
        protected ArrayList<Widget> children = new ArrayList();

        protected Widget() {
        }

        protected void draw(GuiGraphics context, @Nullable Vector2f pointerPosition, boolean triggerPressed) {
            context.pose().pushPose();
            Vector2f p = pointerPosition == null ? null : new Vector2f((Vector2fc)pointerPosition).sub((Vector2fc)new Vector2f(this.position.x, this.position.y));
            this.render(context, p, triggerPressed);
            this.children.forEach(w -> w.draw(context, p, triggerPressed));
            context.pose().popPose();
        }

        protected abstract void render(GuiGraphics var1, @Nullable Vector2f var2, boolean var3);
    }

    protected static class ContainerWidget
    extends Widget {
        protected ContainerWidget(Vector3f position, Vector2f size, Widget ... children) {
            this.position = position;
            this.size = size;
            this.children = new ArrayList<Widget>(Arrays.stream(children).toList());
        }

        @Override
        protected void render(GuiGraphics context, Vector2f pointerPosition, boolean triggerPressed) {
            context.pose().translate(-this.position.x, -this.position.y, -this.position.z);
        }
    }

    protected static class DynamicGradientWidget
    extends Widget {
        private final Callable<Integer> col1;
        private final Callable<Integer> col2;
        private final float angle;

        protected DynamicGradientWidget(Vector3f position, Vector2f size, Callable<Integer> col1, Callable<Integer> col2, float angle) {
            this.position = position;
            this.size = size;
            this.col1 = col1;
            this.col2 = col2;
            this.angle = angle;
        }

        @Override
        protected void render(GuiGraphics context, Vector2f pointerPosition, boolean triggerPressed) {
            context.pose().translate(-this.position.x, -this.position.y, -this.position.z);
            try {
                context.fillGradient((int)(-this.size.x) / 2, (int)(-this.size.y) / 2, (int)this.size.x / 2, (int)this.size.y / 2, this.col1.call().intValue(), this.col2.call().intValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static class GradientWidget
    extends Widget {
        private final int col1;
        private final int col2;
        private final float angle;

        protected GradientWidget(Vector3f position, Vector2f size, int col1, int col2, float angle) {
            this.position = position;
            this.size = size;
            this.col1 = col1;
            this.col2 = col2;
            this.angle = angle;
        }

        @Override
        protected void render(GuiGraphics context, Vector2f pointerPosition, boolean triggerPressed) {
            context.pose().translate(-this.position.x, -this.position.y, -this.position.z);
            context.fillGradient((int)(-this.size.x) / 2, (int)(-this.size.y) / 2, (int)this.size.x / 2, (int)this.size.y / 2, this.col1, this.col2);
        }
    }

    protected static class HoverWidget
    extends Widget {
        protected ArrayList<Widget> childrenB;
        protected boolean hovered = false;

        protected HoverWidget(Vector3f position, Vector2f size, List<Widget> childrenA, List<Widget> childrenB) {
            this.position = position;
            this.size = size;
            this.children = new ArrayList<Widget>(childrenA);
            this.childrenB = new ArrayList<Widget>(childrenB);
        }

        @Override
        protected void draw(GuiGraphics context, @Nullable Vector2f pointerPosition, boolean triggerPressed) {
            context.pose().pushPose();
            Vector2f p = pointerPosition == null ? null : new Vector2f((Vector2fc)pointerPosition).sub((Vector2fc)new Vector2f(this.position.x, this.position.y));
            this.render(context, p, triggerPressed);
            if (this.hovered) {
                this.childrenB.forEach(w -> w.draw(context, p, triggerPressed));
            } else {
                this.children.forEach(w -> w.draw(context, p, triggerPressed));
            }
            context.pose().popPose();
        }

        @Override
        protected void render(GuiGraphics context, @Nullable Vector2f pointerPosition, boolean triggerPressed) {
            context.pose().translate(-this.position.x, -this.position.y, -this.position.z);
            this.hovered = pointerPosition != null ? MathUtil.check2DPointCollision(pointerPosition, new Vector2f(), this.size) : false;
        }
    }

    protected static class ToggleWidget
    extends Widget {
        protected ArrayList<Widget> childrenB;
        protected Consumer<Boolean> changeHandler;
        protected boolean state = false;

        protected ToggleWidget(Vector3f position, Vector2f size, List<Widget> childrenA, List<Widget> childrenB, Consumer<Boolean> toggleHandler) {
            this.children = new ArrayList<Widget>(childrenA);
            this.childrenB = new ArrayList<Widget>(childrenB);
            this.position = position;
            this.size = size;
            this.changeHandler = toggleHandler;
        }

        public void setState(boolean state) {
            if (state == this.state) {
                return;
            }
            this.state = state;
            this.changeHandler.accept(state);
        }

        @Override
        protected void draw(GuiGraphics context, @Nullable Vector2f pointerPosition, boolean triggerPressed) {
            context.pose().pushPose();
            Vector2f p = pointerPosition == null ? null : new Vector2f((Vector2fc)pointerPosition).sub((Vector2fc)new Vector2f(this.position.x, this.position.y));
            this.render(context, p, triggerPressed);
            if (this.state) {
                this.children.forEach(w -> w.draw(context, p, triggerPressed));
            } else {
                this.childrenB.forEach(w -> w.draw(context, p, triggerPressed));
            }
            context.pose().popPose();
        }

        @Override
        protected void render(GuiGraphics context, @Nullable Vector2f pointerPosition, boolean triggerPressed) {
            context.pose().translate(-this.position.x, -this.position.y, -this.position.z);
            if (pointerPosition != null && MathUtil.check2DPointCollision(pointerPosition, new Vector2f(), this.size) && triggerPressed) {
                assert (Minecraft.getInstance().player != null);
                Minecraft.getInstance().player.playNotifySound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.MASTER, 0.2f, 1.0f);
                this.state = !this.state;
                this.changeHandler.accept(this.state);
            }
        }
    }

    protected static class TextureWidget
    extends Widget {
        protected ResourceLocation texture = null;
        protected DynamicTexture dynamicTexture = null;
        protected float scaleX = 1.0f;
        protected float scaleY = 1.0f;

        protected TextureWidget(ResourceLocation texture, Vector3f position, Vector2f size) {
            this.texture = texture;
            this.position = position;
            this.size = size;
        }

        protected TextureWidget(DynamicTexture texture, Vector3f position) {
            this.position = position;
            this.dynamicTexture = texture;
            this.texture = texture.id();
        }

        protected TextureWidget withScale(float scale) {
            this.scaleX = scale;
            this.scaleY = scale;
            return this;
        }

        protected TextureWidget withScale(float scaleX, float scaleY) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            return this;
        }

        @Override
        protected void render(GuiGraphics context, @Nullable Vector2f pointerPosition, boolean triggerPressed) {
            context.pose().translate(-this.position.x, -this.position.y, -this.position.z);
            context.pose().scale(-this.scaleX, -this.scaleY, -1.0f);
            context.blit(this.texture, -((int)(this.size.x / 2.0f)), -((int)(this.size.y / 2.0f)), (float)((int)this.size.x), (float)((int)this.size.y), (int)this.size.x, (int)this.size.y, (int)this.size.x, (int)this.size.y);
        }
    }

    protected static class TextWidget
    extends Widget {
        protected String text;
        protected float scale = 1.0f;
        public int color = -1;
        private int alignment = 1;
        private int wrapWidth = 0;
        private boolean doDynamicScaling = false;
        private int scalingWidth = 0;
        private boolean doDynamicUpdating = false;
        private Callable<String> textGetter = null;

        protected TextWidget(Callable<String> textProvider, Vector3f position, float scale) {
            try {
                this.text = textProvider.call();
                this.doDynamicUpdating = true;
                this.textGetter = textProvider;
                this.position = position;
                this.scale = scale;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected TextWidget(Callable<String> textProvider, Vector3f position) {
            try {
                this.text = textProvider.call();
                this.doDynamicUpdating = true;
                this.textGetter = textProvider;
                this.position = position;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected TextWidget(String text, Vector3f position, float scale) {
            this.text = text;
            this.position = position;
            this.scale = scale;
        }

        protected TextWidget(String text, Vector3f position) {
            this.text = text;
            this.position = position;
        }

        protected TextWidget(Component text, Vector3f position) {
            this(() -> ((Component)text).getString(), position);
        }

        protected TextWidget(Component text, Vector3f position, float scale) {
            this(() -> ((Component)text).getString(), position, scale);
        }

        protected TextWidget alignedLeft() {
            this.alignment = 0;
            return this;
        }

        protected TextWidget withWrapWidth(int width) {
            this.wrapWidth = width;
            this.alignment = -1;
            return this;
        }

        protected TextWidget withColor(int color) {
            this.color = color;
            return this;
        }

        protected TextWidget withScale(float scale) {
            this.scale = scale;
            return this;
        }

        protected TextWidget withDynamicScaling(int maxWidth) {
            this.scalingWidth = maxWidth;
            this.doDynamicScaling = true;
            return this;
        }

        @Override
        protected void render(GuiGraphics context, @Nullable Vector2f pointerPosition, boolean triggerPressed) {
            int currentWidth;
            context.pose().translate(-this.position.x, -this.position.y, -this.position.z);
            context.pose().scale(-this.scale, -this.scale, -this.scale);
            if (this.doDynamicUpdating) {
                try {
                    this.text = this.textGetter.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.doDynamicScaling && (currentWidth = Minecraft.getInstance().font.width(this.text)) > this.scalingWidth) {
                float rescale = (float)this.scalingWidth / (float)currentWidth;
                context.pose().pushPose();
                context.pose().scale(rescale, rescale, rescale);
            }
            if (this.alignment == 0) {
                context.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)this.text), 0, 0, this.color, false);
            } else if (this.alignment == 1) {
                context.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)this.text), -Minecraft.getInstance().font.width(this.text) / 2, 0, this.color, false);
            } else if (this.alignment == -1) {
                context.drawWordWrap(Minecraft.getInstance().font, (FormattedText)Component.literal((String)this.text), -this.wrapWidth / 2, 0, this.wrapWidth, this.color);
            }
            if (pointerPosition != null) {
                pointerPosition.mul(this.scale);
            }
            if (this.doDynamicScaling && (currentWidth = Minecraft.getInstance().font.width(this.text)) > this.scalingWidth) {
                context.pose().popPose();
            }
            context.pose().scale(-1.0f / this.scale, -1.0f / this.scale, -1.0f / this.scale);
        }
    }

    protected static class ButtonWidget
    extends Widget {
        protected Runnable onClickHandler;

        protected ButtonWidget(Vector3f position, Vector2f size, Runnable onClickHandler, Widget ... children) {
            this.position = position;
            this.size = size;
            this.onClickHandler = onClickHandler;
            this.children = new ArrayList<Widget>(Arrays.stream(children).toList());
        }

        @Override
        protected void render(GuiGraphics context, @Nullable Vector2f pointerPosition, boolean triggerPressed) {
            context.pose().translate(-this.position.x, -this.position.y, -this.position.z);
            if (pointerPosition != null && MathUtil.check2DPointCollision(pointerPosition, new Vector2f(), this.size) && triggerPressed) {
                assert (Minecraft.getInstance().player != null);
                Minecraft.getInstance().player.playNotifySound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.MASTER, 0.2f, 1.0f);
                this.onClickHandler.run();
            }
        }
    }
}

