/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.menu;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.menu.SongDownloaderMenu;
import com.beatcraft.client.render.HUDRenderer;
import com.beatcraft.client.render.menu.MenuPanel;
import com.beatcraft.client.render.menu.SettingsMenuPanel;
import com.beatcraft.client.render.menu.SongSelectMenuPanel;
import com.beatcraft.client.render.menu.TextInput;
import com.beatcraft.common.data.map.SongDownloader;
import com.beatcraft.common.data.map.song_preview.SongPreview;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SongDownloaderMenuPanel
extends MenuPanel<SongDownloaderMenu> {
    private final TextInput searchInput = new TextInput();
    private final MenuPanel.ContainerWidget resultsContainer = new MenuPanel.ContainerWidget(new Vector3f(-200.0f, 0.0f, 0.0f), new Vector2f(600.0f, 450.0f), new MenuPanel.Widget[0]);
    private final MenuPanel.ContainerWidget previewContainer = new MenuPanel.ContainerWidget(new Vector3f(300.0f, 0.0f, 0.0f), new Vector2f(300.0f, 500.0f), new MenuPanel.Widget[0]);
    private static final Component SEARCH = Component.translatable((String)"menu.beatcraft.song_download.search");
    private boolean refresh = false;
    private final MenuPanel.ContainerWidget coverContainer = new MenuPanel.ContainerWidget(new Vector3f(0.0f, -200.0f, 0.0f), new Vector2f(200.0f, 200.0f), new MenuPanel.Widget[0]);
    private static final int DISPLAY_WIDTH = 300;
    private static final Component DOWNLOAD = Component.translatable((String)"menu.beatcraft.song_download.download");

    public SongDownloaderMenuPanel(HUDRenderer hudRenderer) {
        super(new SongDownloaderMenu(hudRenderer));
        this.backgroundColor = 0;
        this.position.set(0.1f, 2.0f, 6.0f);
        this.size.set(1000.0f, 500.0f);
        this.initLayout();
    }

    private void initLayout() {
        this.widgets.clear();
        this.widgets.addAll(List.of(SettingsMenuPanel.getButton(new MenuPanel.TextWidget(() -> {
            String t = this.searchInput.buffer.toString();
            return t.isEmpty() ? SEARCH.getString() : t;
        }, new Vector3f(-290.0f, -11.0f, 0.01f), 2.0f).alignedLeft(), () -> ((SongDownloaderMenu)this.data).hudRenderer.hookToKeyboard(this.searchInput), new Vector3f(-200.0f, -225.0f, 0.0f), new Vector2f(600.0f, 50.0f)), SettingsMenuPanel.getButton(new MenuPanel.TextWidget("\ud83d\udd0e", new Vector3f(0.0f, -11.0f, 0.01f), 2.0f), () -> {
            ((SongDownloaderMenu)this.data).hudRenderer.hideKeyboard();
            SongDownloader.queryBuilder.q = this.searchInput.buffer.toString();
            SongDownloader.queryBuilder.page = 0;
            SongDownloader.loadFromSearch(() -> {
                this.refresh = true;
            });
        }, new Vector3f(130.0f, -225.0f, 0.0f), new Vector2f(50.0f, 50.0f)), this.resultsContainer, this.previewContainer, new MenuPanel.ButtonWidget(new Vector3f(30.0f, -150.0f, 0.05f), new Vector2f(50.0f, 50.0f), this::scrollUp, new MenuPanel.TextureWidget(Beatcraft.id("textures/gui/song_selector/up_arrow.png"), new Vector3f(), new Vector2f(50.0f, 50.0f)).withScale(0.75f)), new MenuPanel.ButtonWidget(new Vector3f(30.0f, 185.0f, 0.05f), new Vector2f(50.0f, 50.0f), this::scrollDown, new MenuPanel.TextureWidget(Beatcraft.id("textures/gui/song_selector/down_arrow.png"), new Vector3f(), new Vector2f(50.0f, 50.0f)).withScale(0.75f))));
    }

    private void scrollUp() {
        SongDownloader.queryBuilder.page = Math.max(0, SongDownloader.queryBuilder.page - 1);
        SongDownloader.loadFromSearch(() -> {
            this.refresh = true;
        });
    }

    private void scrollDown() {
        ++SongDownloader.queryBuilder.page;
        SongDownloader.loadFromSearch(() -> {
            this.refresh = true;
        });
    }

    private void refreshList() {
        this.resultsContainer.children.clear();
        Vector3f pos = new Vector3f(-300.0f, -150.0f, 0.0f);
        for (SongPreview previewData : SongDownloader.songPreviews) {
            SongPreviewWidget previewCard = new SongPreviewWidget(this, previewData, new Vector3f((Vector3fc)pos), () -> this.setPreview(previewData));
            this.resultsContainer.children.add(previewCard);
            pos.y += 55.0f;
        }
    }

    private void setPreview(SongPreview data) {
        this.previewContainer.children.clear();
        this.previewContainer.children.addAll(List.of(new MenuPanel.TextWidget(data.id(), new Vector3f(-125.0f, -25.0f, 0.01f), 1.0f).withDynamicScaling(300).alignedLeft(), new MenuPanel.TextWidget(data.name(), new Vector3f(0.0f, -10.0f, 0.01f), 2.0f).withDynamicScaling(150), new MenuPanel.TextWidget(data.uploaderData().name(), new Vector3f(0.0f, 20.0f, 0.01f), 1.5f).withDynamicScaling(200), new MenuPanel.TextWidget(data.getSets(), new Vector3f(0.0f, 50.0f, 0.01f), 1.5f).withDynamicScaling(200), new MenuPanel.TextWidget(data.getDiffs(), new Vector3f(0.0f, 80.0f, 0.01f), 1.5f).withDynamicScaling(200), SettingsMenuPanel.getButton(new MenuPanel.TextWidget(DOWNLOAD, new Vector3f(0.0f, -11.0f, 0.01f), 2.0f), () -> this.downloadSong(data), new Vector3f(0.0f, 140.0f, 0.0f), new Vector2f(250.0f, 50.0f))));
    }

    @Override
    public void render(MultiBufferSource.BufferSource immediate, Vector2f pointerPosition, boolean triggerPressed) {
        super.render(immediate, pointerPosition, triggerPressed);
        if (this.refresh) {
            this.refresh = false;
            this.refreshList();
        }
    }

    private void downloadSong(SongPreview data) {
        SongDownloader.downloadSong(data, Minecraft.getInstance().gameDirectory.getAbsolutePath(), () -> {
            BeatcraftClient.songs.loadSongs();
            SongSelectMenuPanel.refreshList = true;
        });
    }

    private class SongPreviewWidget
    extends MenuPanel.Widget {
        private static final int LIST_MAX_WIDTH = 480;
        protected SongPreview preview;

        protected SongPreviewWidget(SongDownloaderMenuPanel songDownloaderMenuPanel, SongPreview preview, Vector3f position, Runnable previewDisplayer) {
            this.preview = preview;
            this.position = position;
            this.children.addAll(List.of(new MenuPanel.ButtonWidget(new Vector3f(250.0f, 3.0f, -0.05f), new Vector2f(500.0f, 50.0f), previewDisplayer, new MenuPanel.HoverWidget(new Vector3f(), new Vector2f(500.0f, 50.0f), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f(500.0f, 50.0f), 0x5F222222, 0x5F222222, 0.0f)), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f(500.0f, 50.0f), 0x5F444444, 0x5F444444, 0.0f)))), new MenuPanel.TextWidget(preview.name(), new Vector3f(2.0f, -15.0f, 0.0f)).alignedLeft().withScale(2.0f).withDynamicScaling(240), new MenuPanel.TextWidget(preview.uploaderData().name(), new Vector3f(6.0f, 3.0f, 0.0f)).alignedLeft().withScale(1.5f).withColor(-5592406).withDynamicScaling(320)));
        }

        @Override
        protected void render(GuiGraphics context, Vector2f pointerPosition, boolean triggerPressed) {
            context.pose().translate(-this.position.x, -this.position.y, -this.position.z);
        }
    }
}

