/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.particle;

import com.beatcraft.client.render.particle.Particle;
import com.beatcraft.common.utils.MathUtil;
import com.mojang.blaze3d.vertex.BufferBuilder;
import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MenuPointerParticle
implements Particle {
    private boolean shouldRemove = false;
    private final Vector3f position;
    private final Vector3f normal;

    public MenuPointerParticle(Vector3f position, Vector3f normal) {
        this.position = position;
        this.normal = normal;
    }

    @Override
    public void update(float deltaTime, BufferBuilder buffer, Vector3f cameraPos) {
        this.shouldRemove = true;
        List<Vector3f[]> circle = MathUtil.fillMesh(MathUtil.generateCircle(this.normal, 0.05f, 8, this.position.sub((Vector3fc)cameraPos, new Vector3f())));
        for (Vector3f[] tri : circle) {
            buffer.addVertex(tri[0].x, tri[0].y, tri[0].z).setColor(-1);
            buffer.addVertex(tri[1].x, tri[1].y, tri[1].z).setColor(-1);
            buffer.addVertex(tri[2].x, tri[2].y, tri[2].z).setColor(-1);
        }
    }

    @Override
    public boolean shouldRemove() {
        return this.shouldRemove;
    }
}

