/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.particle;

import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.render.HUDRenderer;
import com.beatcraft.client.render.particle.Particle;
import com.beatcraft.common.utils.MathUtil;
import com.mojang.blaze3d.vertex.BufferBuilder;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ScoreDisplay
implements Particle {
    private final int score;
    private final double spawnTime;
    private final Vector3f position;
    private final Vector3f endPoint;
    private final Quaternionf orientation;
    private static final Function<Float, Float> easing = Easing.getEasing("easeOutExpo");
    private static final Component MISS = Component.translatable((String)"hud.beatcraft.miss");

    public ScoreDisplay(int score, Vector3f position, Vector3f endPoint, Quaternionf orientation) {
        this.score = score;
        this.position = position;
        this.endPoint = endPoint;
        this.spawnTime = (double)System.nanoTime() / 1.0E9;
        this.orientation = orientation;
    }

    @Override
    public void update(float deltaTime, BufferBuilder buffer, Vector3f cameraPos) {
        float f = (float)MathUtil.inverseLerp(this.spawnTime, this.spawnTime + 1.25, (double)System.nanoTime() / 1.0E9);
        f = Math.clamp(f, 0.0f, 1.0f);
        Vector3f currentPos = MathUtil.lerpVector3(this.position, this.endPoint, easing.apply(Float.valueOf(f)).floatValue()).sub((Vector3fc)cameraPos);
        Matrix4f matrix = new Matrix4f();
        matrix.translate((Vector3fc)currentPos);
        matrix.scale(0.015625f);
        matrix.rotate((Quaternionfc)new Quaternionf().rotateZ((float)Math.PI));
        matrix.rotate((Quaternionfc)this.orientation);
        if (HUDRenderer.buffers != null) {
            Font textRenderer = Minecraft.getInstance().font;
            String display = String.valueOf(this.score == 0 ? "x" : (this.score == -1 ? MISS.getString() : Integer.valueOf(this.score)));
            int color = this.score > 100 ? -1 : -7303024;
            int w = textRenderer.width(display);
            textRenderer.drawInBatch((Component)Component.literal((String)display), (float)(-w) / 2.0f, 0.0f, color, false, matrix, (MultiBufferSource)HUDRenderer.buffers, Font.DisplayMode.NORMAL, 0, 255);
        }
    }

    @Override
    public boolean shouldRemove() {
        float f = (float)MathUtil.inverseLerp(this.spawnTime, this.spawnTime + 1.25, (double)System.nanoTime() / 1.0E9);
        return (double)f >= 1.25;
    }
}

