/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.common.data.map;

import com.beatcraft.Beatcraft;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;

public class FileDownloader {
    private static final HttpClient httpClient = HttpClient.newHttpClient();

    public static void downloadCoverImage(String url, String outputFileName, Runnable after) {
        CompletableFuture.runAsync(() -> FileDownloader._downloadCoverImage(url, outputFileName)).thenRun(after);
    }

    private static void _downloadCoverImage(String url, String outputFileName) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        try {
            HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
            if (response.statusCode() != 200 || response.body() == null) {
                Beatcraft.LOGGER.error("Failed to download file from '{}'", (Object)url);
                throw new IOException("Failed to download file from: " + url);
            }
            File tempFile = new File(outputFileName + ".tmp");
            Files.write(tempFile.toPath(), response.body(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            File finalPngFile = new File(outputFileName);
            FileDownloader.convertAndResize(tempFile, finalPngFile);
            boolean deleted = tempFile.delete();
            if (!deleted) {
                Beatcraft.LOGGER.warn("Failed to delete temporary file '{}'", (Object)tempFile.getAbsolutePath());
            }
        }
        catch (IOException | InterruptedException e) {
            Beatcraft.LOGGER.error("Failed to download file '{}'", (Object)url, (Object)e);
            throw new RuntimeException("Failed to download image: " + url, e);
        }
    }

    private static void convertAndResize(File inputFile, File outputFile) throws IOException {
        BufferedImage originalImage = ImageIO.read(inputFile);
        if (originalImage == null) {
            throw new IOException("Invalid image file: " + inputFile.getAbsolutePath());
        }
        BufferedImage resizedImage = new BufferedImage(100, 100, 2);
        Graphics2D g2d = resizedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(originalImage, 0, 0, 100, 100, null);
        g2d.dispose();
        ImageIO.write((RenderedImage)resizedImage, "png", outputFile);
    }
}

